/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service.helper;

import android.content.Context;
import android.content.SharedPreferences;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.data.AniwaysStorageManager;
import java.io.File;
import java.io.IOException;

public class ConfigHelper {
    private static ConfigHelper mInstance;
    private static final String TAG = "AniwaysConfigHelper";

    private ConfigHelper() {
    }

    public static ConfigHelper getInstance() {
        if (null == mInstance) {
            mInstance = new ConfigHelper();
        }
        return mInstance;
    }

    public synchronized void setConfigVersion(Context context, String version, String eTag) {
        Log.i(TAG, "Setting config version to: " + version);
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString("com.aniways.CONFIG_VERSION", version);
        edit.putString("com.aniways.CONFIG_ETAG", eTag);
        edit.commit();
    }

    public synchronized String getConfigVersion(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        return prefs.getString("com.aniways.CONFIG_VERSION", "0.0");
    }

    public synchronized String getConfigEtag(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        return prefs.getString("com.aniways.CONFIG_ETAG", "");
    }

    public synchronized boolean upadateConfigFile(Context context, AniwaysStorageManager storageManager) throws IOException {
        String source = AniwaysStorageManager.getConfigCacheDirPath(context) + "/" + AniwaysStorageManager.getConfigFileName();
        String dest = AniwaysStorageManager.getConfigFilePath(context);
        File configDirFile = new File(AniwaysStorageManager.getConfigDirPath(context));
        if (!configDirFile.exists()) {
            if (!configDirFile.mkdirs()) {
                throw new IOException("Could not create config dir: " + configDirFile.getAbsolutePath());
            }
            Log.i(TAG, "Created config dir: " + configDirFile.getAbsolutePath());
        }
        Log.i(TAG, "Copying new config file from " + source + " to: " + dest);
        return new File(source).renameTo(new File(dest));
    }
}

