/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import com.aniways.data.AssetInfoBuilderRequestContext;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.IAssetInfoBuilder;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.service.utils.AniwaysAction;
import java.util.HashMap;
import java.util.List;

public abstract class PhraseAssetInfoBuilderBase {
    protected static final HashMap<Integer, AssetInfoBuilderRequestContext> requests = new HashMap();
    private static int lastRequestId = 0;

    protected AniwaysAction<List<IAniwaysAssetInfo>> getCompletionCallback(final int requestId, final AssetInfoBuilderRequestContext ctx) {
        return new AniwaysAction<List<IAniwaysAssetInfo>>(){

            @Override
            public synchronized void call(List<IAniwaysAssetInfo> assetInfoItems) {
                ++ctx.numCallbacksFromBuilders;
                if (assetInfoItems != null && !assetInfoItems.isEmpty()) {
                    ctx.assetInfoItems.addAll(assetInfoItems);
                }
                if (ctx.numBuilders == ctx.numCallbacksFromBuilders) {
                    ctx.callback.call(ctx.assetInfoItems);
                    requests.remove(requestId);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getNewRequestId() {
        int retRequestId;
        HashMap<Integer, AssetInfoBuilderRequestContext> hashMap = requests;
        synchronized (hashMap) {
            retRequestId = lastRequestId++;
        }
        return retRequestId;
    }

    public void cancelBuildAssetsRequest(int requestId) {
        AssetInfoBuilderRequestContext ctx = requests.get(requestId);
        if (ctx != null) {
            if (ctx.builders == null) {
                return;
            }
            for (IAssetInfoBuilder builder : ctx.builders) {
                builder.cancelPendingRequests();
            }
            requests.remove(requestId);
        }
    }

    public abstract Phrase getReferencePhrase(JsonParser var1, Phrase var2);

    public abstract boolean isEmpty();

    public abstract int buildAssets(AniwaysAction<List<IAniwaysAssetInfo>> var1, Phrase var2);
}

