/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.data.AnimatedGifPhraseAssetInfoBuilder;
import com.aniways.data.Chars;
import com.aniways.data.EmoticonsPhraseAssetBuilder;
import com.aniways.data.PhraseAssetInfoBuilderBase;
import java.io.Serializable;
import java.util.Locale;

public class Phrase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "AniwaysPhrase";
    int start;
    int length;
    private Chars chars;
    private int hash;
    public EmoticonsPhraseAssetBuilder emoticonsPhraseAssetBuilder;
    public AnimatedGifPhraseAssetInfoBuilder animatedGifsPhraseAssetBuilder;

    public Phrase(Chars chars, int start, int length, IconData[] icons) {
        this.chars = chars;
        this.start = start;
        this.length = length;
        this.emoticonsPhraseAssetBuilder = new EmoticonsPhraseAssetBuilder(icons);
    }

    public Phrase(String name, IconData icon) {
        this.chars = new Chars(name.toLowerCase(Locale.US));
        this.start = 0;
        this.length = name.length();
        this.emoticonsPhraseAssetBuilder = new EmoticonsPhraseAssetBuilder(new IconData[]{icon});
    }

    public String getName() {
        return new String(this.chars.chars, this.start, this.length);
    }

    public String getPartToReplace() {
        return this.getName();
    }

    public int getIndexOfPartToReplaceInPhrase() {
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Phrase)) {
            return false;
        }
        return this.equals((Phrase)o);
    }

    public boolean equals(Phrase o) {
        return this.chars == o.chars && this.start == o.start && this.length == o.length;
    }

    public boolean equals(CharSequence o) {
        if (this.length != o.length()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        int end = this.start + this.length;
        for (int i = this.start; i < end; ++i) {
            if (this.chars.chars[i] == o.charAt(i - this.start)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.getName().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return "Phrase [Name()=" + this.getName() + ", PartToReplace()=" + this.getPartToReplace() + "]";
    }

    public String getPhraseSubPhraseString() {
        return Phrase.getPhraseSubPhraseString(this.getName(), this.getPartToReplace());
    }

    public static String getPhraseSubPhraseString(String phraseName, String partToReplace) {
        return String.format("%s - %s", phraseName, phraseName.equalsIgnoreCase(partToReplace) ? "(null)" : partToReplace);
    }

    public boolean isFullReplacement() {
        return true;
    }

    public int getLengthOfPartToReplace() {
        return this.length;
    }

    public int getEndOfPartToReplace() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int getMarginBetweenEndOfPartToReplaceToPhraseEnd() {
        return this.getLength() - this.getEndOfPartToReplace();
    }

    public PhraseAssetInfoBuilderBase getAssetInfoBuilder(AssetType assetType) {
        switch (assetType) {
            case Emoticons: {
                return this.emoticonsPhraseAssetBuilder;
            }
            case AnimatedGif: {
                return this.animatedGifsPhraseAssetBuilder;
            }
        }
        Log.e(true, TAG, "Requested to get PhraseAssetBuilder for nonexistent asset type: " + (Object)((Object)assetType));
        return null;
    }
}

