/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.contextual;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.aniways.AssetType;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.contextual.SuggestionPopupModelBuilder;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysStatics;
import com.aniways.quick.action.ContextualPopupCreationContext;
import com.aniways.quick.action.PhraseContextualContentViewProvider;
import com.aniways.ui.views.AniwaysSlidingLayer;
import com.aniways.ui.views.ContextualAssetView;
import com.aniways.ui.views.ContextualSettingsView;
import java.util.List;

public class ContextualPopupAdapter
extends PagerAdapter
implements ViewPager.OnPageChangeListener {
    private final LayoutInflater inflater;
    private final ContextualAssetView[] assetViews;
    private final ViewPager pager;
    private final ContextualPopupCreationContext creationContext;
    private final float cardElevationInPixels;
    private final float cardRevealWidthInPixels;
    private final float cardRightMarginInPixels;
    private final List<PhraseContextualContentViewProvider> contextualTabs;
    private final float cardCornerRadius;
    private final int toastHeight;
    private final Toast pagingToast;
    private final ImageView pagingToastImageView;
    private final TextView pagingToastTextView;
    private int currentPageIndex = 0;
    AniwaysSlidingLayer.OnInteractListener slidingLayerInteractListener;

    public ContextualPopupAdapter(Context context, LayoutInflater inflater, ViewPager pager, ContextualPopupCreationContext creationContext) {
        this.inflater = inflater;
        this.pager = pager;
        this.creationContext = creationContext;
        this.contextualTabs = SuggestionPopupModelBuilder.getInstance().build(creationContext, context).getTabs();
        Resources res = context.getResources();
        this.cardElevationInPixels = res.getDimension(R.dimen.aniways_contextual_card_elevation);
        this.cardRevealWidthInPixels = res.getDimension(R.dimen.aniways_contextual_card_reveal_width);
        this.cardRightMarginInPixels = res.getDimension(R.dimen.aniways_contextual_card_right_margin_width);
        this.cardCornerRadius = res.getDimension(R.dimen.cardview_default_radius);
        this.toastHeight = (int)res.getDimension(R.dimen.aniways_asset_toast_height);
        View toastLayout = inflater.inflate(R.layout.aniways_asset_toast, null);
        this.pagingToast = new Toast(context);
        this.pagingToast.setView(toastLayout);
        this.pagingToastImageView = (ImageView)toastLayout.findViewById(R.id.aniways_asset_toast_icon);
        this.pagingToastTextView = (TextView)toastLayout.findViewById(R.id.aniways_asset_toast_text);
        this.assetViews = new ContextualAssetView[this.contextualTabs.size()];
        this.initSlidingLayerInteractionHandler(creationContext);
    }

    private void initSlidingLayerInteractionHandler(final ContextualPopupCreationContext creationContext) {
        this.slidingLayerInteractListener = new AniwaysSlidingLayer.OnInteractListener(){

            @Override
            public void onOpen() {
                AssetType assetType;
                ContextualPopupAdapter.this.pagingToast.cancel();
                int position = ContextualPopupAdapter.this.currentPageIndex;
                if (position == ContextualPopupAdapter.this.contextualTabs.size()) {
                    assetType = AssetType.Settings;
                } else {
                    assetType = ((PhraseContextualContentViewProvider)ContextualPopupAdapter.this.contextualTabs.get(position)).getAssetType();
                    ContextualPopupAdapter.this.assetViews[position].notifyRevealMore();
                }
                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Popup Reveal More-" + (Object)((Object)creationContext.selectionOrigin), assetType.toString() + "-" + position, creationContext.phrase.getPhraseSubPhraseString(), 0L);
                AnalyticsReporter.reportRevealMoreInPopup(assetType, position, creationContext);
            }

            @Override
            public void onClose() {
                int position = ContextualPopupAdapter.this.currentPageIndex;
                if (position != ContextualPopupAdapter.this.contextualTabs.size()) {
                    ContextualPopupAdapter.this.assetViews[position].notifyRevealLess();
                }
            }

            @Override
            public void onOpened() {
            }

            @Override
            public void onClosed() {
            }
        };
    }

    public Object instantiateItem(ViewGroup container, int position) {
        if (position < this.assetViews.length) {
            int distFromBottom = this.getCount() - (position + 1);
            ContextualAssetView assetView = (ContextualAssetView)this.inflater.inflate(R.layout.aniways_contextual_card, null);
            container.addView((View)assetView);
            this.assetViews[position] = assetView;
            CardView cardView = (CardView)assetView.findViewById(R.id.aniways_contextual_card_view);
            cardView.setCardElevation((float)distFromBottom * this.cardElevationInPixels);
            int cardSidePadding = 0;
            if (!Utils.isAndroidVersionAtLeast(21)) {
                float maxCardElevation = cardView.getMaxCardElevation();
                cardSidePadding = (int)((double)maxCardElevation + (1.0 - Math.cos(45.0)) * (double)this.cardCornerRadius);
                int cardTopBottomPadding = (int)((double)maxCardElevation * 1.5 + (1.0 - Math.cos(45.0)) * (double)this.cardCornerRadius);
                LinearLayout.LayoutParams cardLayoutParams = (LinearLayout.LayoutParams)cardView.getLayoutParams();
                cardLayoutParams.setMargins(-cardSidePadding, -cardTopBottomPadding, 0, -cardTopBottomPadding);
            }
            View rightSpacer = assetView.findViewById(R.id.aniways_contextual_card_right_spacer);
            ViewGroup.LayoutParams spacerLayoutParams = rightSpacer.getLayoutParams();
            int spacerWidth = this.getSpacerWidth(distFromBottom);
            spacerLayoutParams.width = spacerWidth + cardSidePadding;
            rightSpacer.setLayoutParams(spacerLayoutParams);
            assetView.initContent(this.contextualTabs.get(position), this.pager.getMeasuredHeight(), position, spacerWidth, this.slidingLayerInteractListener);
            this.setFirstPageAsSelected();
            return assetView;
        }
        ContextualSettingsView settingsView = (ContextualSettingsView)this.inflater.inflate(R.layout.aniways_contextual_settings_card, null);
        container.addView((View)settingsView);
        settingsView.initContent(this.pager.getMeasuredHeight());
        if (!Utils.isAndroidVersionAtLeast(21)) {
            CardView cardView = (CardView)settingsView.findViewById(R.id.aniways_contextual_settings_card_view);
            float maxCardElevation = cardView.getMaxCardElevation();
            int cardSidePadding = (int)((double)maxCardElevation + (1.0 - Math.cos(45.0)) * (double)this.cardCornerRadius);
            int cardTopBottomPadding = (int)((double)maxCardElevation * 1.5 + (1.0 - Math.cos(45.0)) * (double)this.cardCornerRadius);
            LinearLayout.LayoutParams cardLayoutParams = (LinearLayout.LayoutParams)cardView.getLayoutParams();
            cardLayoutParams.setMargins(-cardSidePadding, -cardTopBottomPadding, 0, -cardTopBottomPadding);
        }
        return settingsView;
    }

    public void setToastOffset(int yOffset) {
        this.pagingToast.setGravity(48, 0, yOffset - this.toastHeight);
    }

    private int getSpacerWidth(int distFromBottom) {
        return (int)(this.cardRevealWidthInPixels * (float)distFromBottom - this.cardRightMarginInPixels);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        if (position < this.assetViews.length) {
            this.assetViews[position] = null;
        }
    }

    public int getCount() {
        return this.contextualTabs.size() + 1;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        AssetType oldAssetType;
        AssetType newAssetType;
        int oldPos = this.currentPageIndex;
        this.currentPageIndex = position;
        if (position == this.contextualTabs.size()) {
            newAssetType = AssetType.Settings;
        } else {
            newAssetType = this.contextualTabs.get(position).getAssetType();
            this.assetViews[position].notifySelected();
        }
        if (oldPos == this.contextualTabs.size()) {
            oldAssetType = AssetType.Settings;
        } else {
            oldAssetType = this.contextualTabs.get(oldPos).getAssetType();
            this.assetViews[oldPos].notifyNotSelected();
        }
        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Popup Scroll-" + (Object)((Object)this.creationContext.selectionOrigin), "To:" + newAssetType.toString() + "-" + position + ". From: " + oldAssetType.toString() + "-" + oldPos, this.creationContext.phrase.getPhraseSubPhraseString(), 0L);
        AnalyticsReporter.reportPopupScroll(newAssetType, position, oldAssetType, oldPos, this.creationContext);
        switch (newAssetType) {
            case Emoticons: {
                this.pagingToastImageView.setImageResource(R.drawable.aniways_contextual_asset_emoticons_white);
                this.pagingToastTextView.setText(R.string.aniways_asset_type_emoticons);
                this.pagingToast.show();
                break;
            }
            case AnimatedGif: {
                this.pagingToastImageView.setImageResource(R.drawable.aniways_contextual_asset_gifs_white);
                this.pagingToastTextView.setText(R.string.aniways_asset_type_gifs);
                this.pagingToast.show();
                break;
            }
            case Settings: {
                this.pagingToast.cancel();
            }
        }
        SharedPreferences prefs = AniwaysStatics.getApplicationContext().getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        if (!prefs.contains("com.aniways.KEY_CONTEXTUAL_POPUP_CARD_SWIPED")) {
            prefs.edit().putString("com.aniways.KEY_CONTEXTUAL_POPUP_CARD_SWIPED", "1").commit();
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.currentPageIndex == this.assetViews.length) {
            return;
        }
        switch (state) {
            case 1: {
                this.assetViews[this.currentPageIndex].hideHint();
                break;
            }
            case 0: {
                this.assetViews[this.currentPageIndex].showHint();
            }
        }
    }

    private void setFirstPageAsSelected() {
        this.assetViews[0].notifySelected();
    }

    public void showFirstPageHintOrWink() {
        SharedPreferences prefs = AniwaysStatics.getApplicationContext().getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        if (!prefs.contains("com.aniways.KEY_CONTEXTUAL_POPUP_CARD_SWIPED")) {
            this.pager.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ContextualPopupAdapter.this.assetViews[0] != null) {
                        ContextualPopupAdapter.this.assetViews[0].wink();
                    }
                }
            }, 800L);
        } else {
            this.pager.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ContextualPopupAdapter.this.assetViews[0] != null) {
                        ContextualPopupAdapter.this.assetViews[0].showHint();
                    }
                }
            }, 800L);
        }
    }
}

