/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.contextual;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.contextual.ContextualPopupAdapter;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.nineoldandroids.view.ViewHelper;
import com.aniways.quick.action.ContextualItemSelectedByUserEvent;
import com.aniways.quick.action.ContextualPopupCreationContext;
import com.aniways.quick.action.SelectedGridItemInfo;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.ui.views.AniwaysPopupWindow;
import com.aniways.ui.views.ContextualAssetView;
import com.aniways.ui.views.ContextualSettingsView;

public class ContextualPopup
extends AniwaysPopupWindow
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final int MaxPagesToLoad = 10;
    private static final String TAG = "ContextualPopup";
    protected final WindowManager windowManager;
    private final ContextualPopupAdapter assetsAdapter;
    private final int cardAtHintHeight;
    private AniwaysLockedIconHelper mLockedIconHelper;

    public ContextualPopup(Context context, ContextualPopupCreationContext creationContext) {
        super(context, creationContext, true, new AniwaysPopupWindow.PopupTimingOptions());
        View popupContent = this.layoutInflater.inflate(R.layout.aniways_contextual_popup, null);
        this.setContentView(popupContent);
        ViewPager pager = (ViewPager)popupContent.findViewById(R.id.aniways_contextual_popup);
        this.assetsAdapter = new ContextualPopupAdapter(context, this.layoutInflater, pager, creationContext);
        pager.setAdapter((PagerAdapter)this.assetsAdapter);
        pager.setOffscreenPageLimit(10);
        pager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.assetsAdapter);
        pager.setPageTransformer(true, (ViewPager.PageTransformer)new StackedPagesPageTransformer(this.assetsAdapter.getCount(), context));
        this.windowManager = (WindowManager)context.getSystemService("window");
        Resources res = context.getResources();
        this.cardAtHintHeight = (int)(res.getDimension(R.dimen.aniways_contextual_card_min_height) + res.getDimension(R.dimen.aniways_contextual_card_hint_height));
        this.initLockedIconHelper();
    }

    @Override
    public void show(View anchor) {
        super.show(anchor);
        this.assetsAdapter.showFirstPageHintOrWink();
    }

    private void initLockedIconHelper() {
        try {
            this.mLockedIconHelper = new AniwaysLockedIconHelper(this.creationContext.parser, new AniwaysLockedIconHelper.OnItemContainingLockedIconClickListener(){

                @Override
                public void onItemClick(Object iconClickContext) {
                }
            }, null, new TextView(this.context), this, this.creationContext.anchor, true, this.context, "SP");
        }
        catch (Exception e) {
            Log.e(true, TAG, "Exception thrown while trying to init AniwaysLockedIconHelper in Contextual popup", e);
        }
    }

    public void handleLockedIconSelectedEvent(ContextualItemSelectedByUserEvent itemSelectedByUserEvent, final AniwaysAction<Boolean> callback) {
        try {
            SelectedGridItemInfo selectedGridItemInfo = itemSelectedByUserEvent.selectedGridItemInfo;
            View gridItem = selectedGridItemInfo.getGridItem();
            ImageView iconImage = (ImageView)gridItem.findViewById(R.id.aniways_action_item_icon);
            ImageView lockedImage = (ImageView)gridItem.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
            if (lockedImage == null) {
                callback.call(false);
                return;
            }
            this.mLockedIconHelper.onIconClicked(iconImage, lockedImage, itemSelectedByUserEvent.assetInfo.getIconData(), itemSelectedByUserEvent, new AniwaysLockedIconHelper.OnItemContainingLockedIconClickListener(){

                @Override
                public void onItemClick(Object iconClickContext) {
                    callback.call(true);
                }
            });
        }
        catch (Exception e) {
            Log.e(true, TAG, "Exception thrown while trying to call handleLockedIconSelectedEvent.onIconSelected in Contextual popup", e);
            callback.call(false);
        }
    }

    @Override
    protected Rect calculateTargetBounds(View anchor) {
        int[] location = new int[2];
        anchor.getLocationOnScreen(location);
        Rect rectangle = new Rect();
        anchor.getWindowVisibleDisplayFrame(rectangle);
        int statusBarHeight = rectangle.top;
        DisplayMetrics dm = new DisplayMetrics();
        this.windowManager.getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        int actionBarHeight = 0;
        TypedValue tv = new TypedValue();
        if (this.context.getTheme().resolveAttribute(16843499, tv, true)) {
            actionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
        }
        Rect retBounds = new Rect(0, statusBarHeight + actionBarHeight, screenWidth, location[1]);
        this.assetsAdapter.setToastOffset(retBounds.bottom - this.cardAtHintHeight - statusBarHeight);
        return retBounds;
    }

    private class StackedPagesPageTransformer
    implements ViewPager.PageTransformer {
        private final int pages;
        private final float settingsCardWidth;
        private final float settingsCardHookWidth;
        private final float cardIconWidth;
        private final float revealWidth;

        public StackedPagesPageTransformer(int pages, Context context) {
            this.pages = pages;
            this.settingsCardWidth = context.getResources().getDimension(R.dimen.aniways_contextual_card_setting_peek_width);
            this.settingsCardHookWidth = context.getResources().getDimension(R.dimen.aniways_contextual_card_setting_visible_width);
            this.cardIconWidth = context.getResources().getDimension(R.dimen.aniways_contextual_card_icon_holder_width);
            this.revealWidth = context.getResources().getDimension(R.dimen.aniways_contextual_card_reveal_width);
        }

        public void transformPage(View view, float position) {
            int pageWidth = view.getWidth();
            if (view instanceof ContextualAssetView) {
                ContextualAssetView assetView = (ContextualAssetView)view;
                assetView.updateByPosition(position);
                this.updateAssetPagePosition(assetView, position, pageWidth);
            } else if (view instanceof ContextualSettingsView) {
                ContextualSettingsView settingsView = (ContextualSettingsView)view;
                settingsView.updateByPosition(position, pageWidth);
                this.updateSettingsPagePosition(settingsView, position, pageWidth);
            }
        }

        private void updateAssetPagePosition(ContextualAssetView assetView, float position, int pageWidth) {
            float pinningPosition;
            if (position >= 0.0f) {
                ViewHelper.setTranslationX((View)assetView, (float)(-pageWidth) * position);
            } else if (assetView.index == this.pages - 2 && position <= -(pinningPosition = (this.settingsCardHookWidth - this.revealWidth) / (float)pageWidth)) {
                ViewHelper.setTranslationX((View)assetView, (float)(-pageWidth) * (pinningPosition + position));
            }
        }

        private void updateSettingsPagePosition(ContextualSettingsView settingsView, float position, int pageWidth) {
            float relativeIconWidth = this.cardIconWidth / (float)pageWidth;
            if ((double)position >= 1.0) {
                ViewHelper.setTranslationX((View)settingsView, (float)pageWidth * (1.0f - position - relativeIconWidth));
            } else {
                float pinningPosition = 1.0f - (this.settingsCardWidth - this.revealWidth) / (float)pageWidth;
                if (position >= pinningPosition) {
                    float relativeRevealWidth = this.revealWidth / (float)pageWidth;
                    float fullOverlap = relativeIconWidth - relativeRevealWidth;
                    float progress = 1.0f - (position - pinningPosition) / (1.0f - pinningPosition);
                    ViewHelper.setTranslationX((View)settingsView, (float)pageWidth * (-relativeIconWidth + progress * fullOverlap));
                } else {
                    float relativeCardWidth = this.settingsCardWidth / (float)pageWidth;
                    ViewHelper.setTranslationX((View)settingsView, (float)pageWidth * (1.0f - relativeCardWidth - position));
                }
            }
        }
    }
}

