/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag;

import com.aniways.bugsnag.BeforeNotify;
import com.aniways.bugsnag.Configuration;
import com.aniways.bugsnag.Diagnostics;
import com.aniways.bugsnag.Error;
import com.aniways.bugsnag.ExceptionHandler;
import com.aniways.bugsnag.Logger;
import com.aniways.bugsnag.MetaData;
import com.aniways.bugsnag.Notification;

public class Client {
    protected Configuration config = new Configuration();
    protected Diagnostics diagnostics = new Diagnostics(this.config);

    public Client(String apiKey) {
        this(apiKey, true);
    }

    public Client(String apiKey, boolean installHandler) {
        if (apiKey == null) {
            throw new RuntimeException("You must provide a Bugsnag API key");
        }
        this.config.apiKey = apiKey;
        if (installHandler) {
            ExceptionHandler.install(this);
        }
    }

    public void setContext(String context) {
        this.config.context.setLocked(context);
    }

    public void setUserId(String id2) {
        this.config.setUser(id2, null, null);
    }

    public void setUser(String id2, String email, String name) {
        this.config.setUser(id2, email, name);
    }

    public void setReleaseStage(String releaseStage) {
        this.config.releaseStage.setLocked(releaseStage);
    }

    public void setNotifyReleaseStages(String ... notifyReleaseStages) {
        this.config.setNotifyReleaseStages(notifyReleaseStages);
    }

    public void setAutoNotify(boolean autoNotify) {
        this.config.setAutoNotify(autoNotify);
    }

    public void setUseSSL(boolean useSSL) {
        this.config.setUseSSL(useSSL);
    }

    public boolean getUseSSL() {
        return this.config.useSSL;
    }

    public void setEndpoint(String endpoint) {
        this.config.setEndpoint(endpoint);
    }

    public void setFilters(String ... filters) {
        this.config.setFilters(filters);
    }

    public void setProjectPackages(String ... projectPackages) {
        this.config.setProjectPackages(projectPackages);
    }

    public void setOsVersion(String osVersion) {
        this.config.osVersion.setLocked(osVersion);
    }

    public void setAppVersion(String appVersion) {
        this.config.appVersion.setLocked(appVersion);
    }

    public void setNotifierName(String notifierName) {
        this.config.setNotifierName(notifierName);
    }

    public void setNotifierVersion(String notifierVersion) {
        this.config.setNotifierVersion(notifierVersion);
    }

    public void setNotifierUrl(String notifierUrl) {
        this.config.setNotifierUrl(notifierUrl);
    }

    public void setIgnoreClasses(String ... ignoreClasses) {
        this.config.setIgnoreClasses(ignoreClasses);
    }

    public void setLogger(Logger logger) {
        this.config.setLogger(logger);
    }

    public void addBeforeNotify(BeforeNotify beforeNotify) {
        this.config.addBeforeNotify(beforeNotify);
    }

    public void notify(Throwable e, String severity, MetaData metaData) {
    }

    public void notify(Throwable e, MetaData metaData) {
        this.notify(e, null, metaData);
    }

    public void notify(Throwable e, String severity) {
        this.notify(e, severity, null);
    }

    public void notify(Throwable e) {
        this.notify(e, null, null);
    }

    public void autoNotify(Throwable e) {
        if (this.config.autoNotify) {
            this.notify(e, "error");
        }
    }

    public void addToTab(String tab, String key, Object value) {
        this.config.addToTab(tab, key, value);
    }

    public void clearTab(String tab) {
        this.config.clearTab(tab);
    }

    public Notification createNotification() {
        return new Notification(this.config);
    }

    public Notification createNotification(Error error) {
        return new Notification(this.config, error);
    }

    public Error createError(Throwable e, String severity, MetaData metaData) {
        return new Error(e, severity, metaData, this.config, this.diagnostics);
    }
}

