/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.request.azure;

import java.net.HttpURLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class Utility {
    static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    static final Locale LOCALE_US = Locale.US;
    private static final String RFC1123_GMT_PATTERN = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";

    Utility() {
    }

    static String getGMTTime() {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat(RFC1123_GMT_PATTERN, LOCALE_US);
        rfc1123Format.setTimeZone(GMT_ZONE);
        return rfc1123Format.format(new Date());
    }

    static String getStandardHeaderValue(HttpURLConnection conn, String headerName) {
        String headerValue = conn.getRequestProperty(headerName);
        return headerValue == null ? "" : headerValue;
    }

    static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    static String trimStart(String value) {
        int spaceDex;
        for (spaceDex = 0; spaceDex < value.length() && value.charAt(spaceDex) == ' '; ++spaceDex) {
        }
        return value.substring(spaceDex);
    }
}

