/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.models;

import com.aniways.analytics.models.Context;
import com.aniways.analytics.models.EasyJSONObject;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONObject;

public class BasePayload
extends EasyJSONObject {
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String CONTEXT_KEY = "context";

    public BasePayload(JSONObject obj) {
        super(obj);
    }

    public BasePayload(Calendar timestamp, Context context) {
        if (timestamp == null) {
            timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
        if (context == null) {
            context = new Context();
        }
        this.setTimestamp(timestamp);
        this.setContext(context);
    }

    public Calendar getTimestamp() {
        return this.getCalendar(TIMESTAMP_KEY);
    }

    public void setTimestamp(Calendar timestamp) {
        super.put(TIMESTAMP_KEY, timestamp);
    }

    public Context getContext() {
        JSONObject object = this.getObject(CONTEXT_KEY);
        if (object == null) {
            return null;
        }
        return new Context(object);
    }

    public void setContext(Context context) {
        this.put(CONTEXT_KEY, context);
    }
}

