/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.info;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.aniways.Log;
import com.aniways.analytics.info.Info;
import com.aniways.analytics.models.EasyJSONObject;
import org.json.JSONObject;

public class Telephony
implements Info<JSONObject> {
    private static final String TAG = "AniwaysAnalyticsContextTelephony";

    @Override
    public String getKey() {
        return "telephony";
    }

    @Override
    public JSONObject get(Context context) {
        EasyJSONObject telephony = new EasyJSONObject();
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            if (manager != null) {
                telephony.put("carrier", manager.getNetworkOperatorName());
                telephony.put("radio", this.getRadio(manager));
            }
        }
        catch (Exception ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception in Telephony info", ex);
        }
        return telephony;
    }

    private String getRadio(TelephonyManager manager) {
        switch (manager.getPhoneType()) {
            case 0: {
                return "none";
            }
            case 1: {
                return "gsm";
            }
            case 2: {
                return "cdma";
            }
            case 3: {
                return "sip";
            }
        }
        return null;
    }
}

