/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.info;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.aniways.Log;
import com.aniways.analytics.info.Info;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.data.AniwaysPrivateConfig;
import org.json.JSONObject;

public class Build
implements Info<JSONObject> {
    private static final String TAG = "AniwaysAnalyticsContextBuild";
    private static final String UNKNOWN = "unknown";

    @Override
    public String getKey() {
        return "build";
    }

    @Override
    public JSONObject get(Context context) {
        EasyJSONObject build = new EasyJSONObject();
        try {
            String appName;
            String packageName;
            PackageInfo packageInfo = null;
            PackageManager pm = context.getPackageManager();
            if (pm != null && (packageName = context.getPackageName()) != null) {
                try {
                    packageInfo = pm.getPackageInfo(packageName, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.eToGaOnly(true, TAG, "Could not get package name", e);
                }
            }
            build.put("appName", (appName = Build.getAppName(context)) == null ? UNKNOWN : appName);
            build.put("packageName", packageInfo == null ? UNKNOWN : packageInfo.packageName);
            build.put("code", packageInfo == null ? UNKNOWN : Integer.valueOf(packageInfo.versionCode));
            build.put("name", packageInfo == null ? UNKNOWN : packageInfo.versionName);
            build.put("aniwaysVersion", "2.3.08");
            build.put("appId", AniwaysPrivateConfig.getInstance().appId);
        }
        catch (Exception ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception in Build info", ex);
        }
        return build;
    }

    public static String getAppName(Context context) {
        CharSequence appName;
        String packageName;
        ApplicationInfo appInfo = null;
        PackageManager pm = context.getPackageManager();
        if (pm != null && (packageName = context.getPackageName()) != null) {
            try {
                appInfo = pm.getApplicationInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.eToGaOnly(true, TAG, "Could not get package name", e);
            }
        }
        CharSequence charSequence = appName = appInfo == null ? null : pm.getApplicationLabel(appInfo);
        if (appName == null) {
            return null;
        }
        return appName.toString();
    }
}

