/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.db;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.util.Pair;
import com.aniways.Log;
import com.aniways.analytics.Constants;
import com.aniways.analytics.db.JsonPayloadSerializer;
import com.aniways.analytics.models.BasePayload;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Installation;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class PayloadDatabase
extends SQLiteOpenHelper {
    private static final String TAG = "AniwaysPayloadDatabase";
    private static PayloadDatabase instance;
    private AtomicLong count;
    private boolean initialCount;
    private AtomicLong errorCount;
    private boolean initialErrorsCount;
    private JsonPayloadSerializer serializer = new JsonPayloadSerializer();

    public static PayloadDatabase getInstance(Context context) {
        if (instance == null) {
            instance = new PayloadDatabase(context);
        }
        return instance;
    }

    private PayloadDatabase(Context context) {
        super(context, PayloadDatabase.getDbName(context), null, 4);
        Log.d(TAG, "Created DB with name: " + PayloadDatabase.getDbName(context));
        this.count = new AtomicLong();
        this.errorCount = new AtomicLong();
    }

    private static String getDbName(Context context) {
        String databaseName = context.getPackageName();
        if (databaseName == null) {
            databaseName = Installation.id(context);
        }
        return databaseName + ".AniwaysAnalyticsService";
    }

    public void onCreate(SQLiteDatabase db) {
        try {
            this.createPayloadTable(db);
            this.createErrorsDb(db);
        }
        catch (Throwable ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception in onCreate", ex);
        }
    }

    private void createPayloadTable(SQLiteDatabase db) {
        String sql = String.format("CREATE TABLE IF NOT EXISTS %s (%s %s, %s %s, %s %s);", "payload_table", "id", "INTEGER PRIMARY KEY AUTOINCREMENT", "payload", " TEXT", "payload_hash", " INTEGER UNIQUE");
        try {
            db.execSQL(sql);
        }
        catch (SQLException e) {
            Log.eToGaOnly(true, TAG, "Failed to create Segment.io SQL lite database: " + sql, e);
        }
    }

    public void onOpen(SQLiteDatabase db) {
        try {
            super.onOpen(db);
        }
        catch (Throwable ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception in onOpen", ex);
        }
    }

    private void ensureCount() {
        if (!this.initialCount) {
            this.count.set(this.countRows("payload_table"));
            this.initialCount = true;
        }
    }

    private void ensureErrorsCount() {
        if (!this.initialErrorsCount) {
            this.errorCount.set(this.countRows("errors_payload_table"));
            this.initialErrorsCount = true;
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.i(TAG, "Upgrading DB to version: " + newVersion + " . From version: " + oldVersion);
        db.execSQL("DROP TABLE IF EXISTS payload_table");
        db.execSQL("DROP TABLE IF EXISTS errors_payload_table");
        this.onCreate(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addPayload(String payload) {
        this.ensureCount();
        long rowCount = this.getRowCount();
        if (rowCount >= (long)AniwaysPrivateConfig.getInstance().analyticsMaxEventsInDb) {
            Log.wToGaOnly(true, TAG, "Cant add payload, the database is larger than max queue size.", null);
            return false;
        }
        boolean success = false;
        PayloadDatabase payloadDatabase = this;
        synchronized (payloadDatabase) {
            try (SQLiteDatabase db = null;){
                db = this.getWritableDatabase();
                ContentValues contentValues = new ContentValues();
                contentValues.put("payload", payload);
                int payloadHash = payload.hashCode();
                contentValues.put("payload_hash", Integer.valueOf(payloadHash));
                long result = db.insertWithOnConflict("payload_table", null, contentValues, 4);
                if (result == -1L) {
                    String sql = "SELECT COUNT(*) FROM payload_table WHERE ? = ?";
                    String[] selectionArgs = new String[]{"payload_hash", String.valueOf(payloadHash)};
                    Cursor cursor = db.rawQuery(sql, selectionArgs);
                    if (cursor.getCount() == 0) {
                        Log.eToGaOnly(true, TAG, "Database insert failed. Result: " + result, null);
                    }
                    cursor.close();
                } else {
                    success = true;
                    this.count.addAndGet(1L);
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addErrorPayload(String payload) {
        this.ensureErrorsCount();
        long rowCount = this.getErrorsRowCount();
        if (rowCount >= (long)AniwaysPrivateConfig.getInstance().analyticsMaxEventsInDb) {
            Log.wToGaOnly(true, TAG, "Cant add payload, the database is larger than max queue size.", null);
            return false;
        }
        boolean success = false;
        PayloadDatabase payloadDatabase = this;
        synchronized (payloadDatabase) {
            try (SQLiteDatabase db = null;){
                db = this.getWritableDatabase();
                ContentValues contentValues = new ContentValues();
                contentValues.put("payload", payload);
                long result = db.insert("errors_payload_table", null, contentValues);
                if (result == -1L) {
                    Log.eToGaOnly(true, TAG, "Errors Database insert failed. Result: " + result, null);
                } else {
                    success = true;
                    this.errorCount.addAndGet(1L);
                }
            }
            return success;
        }
    }

    private void createErrorsDb(SQLiteDatabase db) {
        String sql = String.format("CREATE TABLE IF NOT EXISTS %s (%s %s, %s %s);", "errors_payload_table", "id", "INTEGER PRIMARY KEY AUTOINCREMENT", "payload", " TEXT");
        try {
            db.execSQL(sql);
            Log.i(TAG, "Created errors table");
        }
        catch (SQLException e) {
            Log.eToGaOnly(true, TAG, "Failed to create SQL lite errors database: " + sql, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countRows(String tableName) {
        String sql = String.format("SELECT COUNT(*) FROM %s", tableName);
        long numberRows = 0L;
        SQLiteDatabase db = null;
        PayloadDatabase payloadDatabase = this;
        synchronized (payloadDatabase) {
            try {
                db = this.getWritableDatabase();
                SQLiteStatement statement = db.compileStatement(sql);
                numberRows = statement.simpleQueryForLong();
            }
            catch (SQLiteException e) {
                Log.eToGaOnly(true, TAG, "Failed to ensure row count in the table: " + tableName, e);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        return numberRows;
    }

    public long getRowCount() {
        if (!this.initialCount) {
            this.ensureCount();
        }
        return this.count.get();
    }

    public long getErrorsRowCount() {
        if (!this.initialErrorsCount) {
            this.ensureErrorsCount();
        }
        return this.errorCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Pair<Long, BasePayload>> getEvents(int limit) {
        LinkedList<Pair<Long, BasePayload>> result = new LinkedList<Pair<Long, BasePayload>>();
        SQLiteDatabase db = null;
        Cursor cursor = null;
        PayloadDatabase payloadDatabase = this;
        synchronized (payloadDatabase) {
            try {
                db = this.getWritableDatabase();
                String table = "payload_table";
                String[] columns = Constants.Database.PayloadTable.FIELD_NAMES;
                String selection = null;
                String[] selectionArgs = null;
                String groupBy = null;
                String having = null;
                String orderBy = "id ASC";
                String limitBy = "" + limit;
                cursor = db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limitBy);
                long maxMem = Runtime.getRuntime().maxMemory();
                long freeMem = Runtime.getRuntime().freeMemory();
                int maxJsonLength = (int)((maxMem - 0xA00000L) / 2L / 6L);
                Log.d(TAG, "MaxMem: " + maxMem / 0x100000L + " FreeMem: " + freeMem / 0x100000L + " maxLength: " + maxJsonLength);
                int jsonLength = 0;
                int counter = 0;
                while (cursor.moveToNext()) {
                    long id2 = cursor.getLong(0);
                    String json = cursor.getString(1);
                    jsonLength += json.length();
                    ++counter;
                    BasePayload payload = this.serializer.deseralize(json);
                    if (payload != null) {
                        result.add((Pair<Long, BasePayload>)new Pair((Object)id2, (Object)payload));
                    }
                    if (jsonLength <= maxJsonLength) continue;
                    Log.d(TAG, "Reached max mem after " + counter + " events");
                    AniwaysPrivateConfig.getInstance().analyticsMaxEventsBeforeFlush = counter / 2;
                    break;
                }
            }
            catch (SQLiteException e) {
                Log.eToGaOnly(true, TAG, "Failed to open or read from the Segment.io payload db: ", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (db != null) {
                    db.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Pair<Long, String>> getErrorEvents(int limit) {
        LinkedList<Pair<Long, String>> result = new LinkedList<Pair<Long, String>>();
        SQLiteDatabase db = null;
        Cursor cursor = null;
        PayloadDatabase payloadDatabase = this;
        synchronized (payloadDatabase) {
            try {
                db = this.getWritableDatabase();
                String table = "errors_payload_table";
                String[] columns = Constants.Database.ErrorsPayloadTable.FIELD_NAMES;
                String selection = null;
                String[] selectionArgs = null;
                String groupBy = null;
                String having = null;
                String orderBy = "id ASC";
                String limitBy = "" + limit;
                cursor = db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limitBy);
                while (cursor.moveToNext()) {
                    long id2 = cursor.getLong(0);
                    String xml = cursor.getString(1);
                    if (xml == null) continue;
                    result.add((Pair<Long, String>)new Pair((Object)id2, (Object)xml));
                }
            }
            catch (SQLiteException e) {
                Log.eToGaOnly(true, TAG, "Failed to open or read from the errors payload db: ", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (db != null) {
                    db.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DefaultLocale"})
    int removeEvents(long minId, long maxId) {
        this.ensureCount();
        SQLiteDatabase db = null;
        String ID_FIELD_NAME = "id";
        String filter = String.format(Locale.US, "%s >= %d AND %s <= %d", ID_FIELD_NAME, minId, ID_FIELD_NAME, maxId);
        Log.d(TAG, filter);
        int deleted = -1;
        PayloadDatabase payloadDatabase = this;
        synchronized (payloadDatabase) {
            try {
                db = this.getWritableDatabase();
                deleted = db.delete("payload_table", filter, null);
                this.count.addAndGet(-deleted);
            }
            catch (SQLiteException e) {
                Log.eToGaOnly(true, TAG, "Failed to remove items from the Segment.io payload db: ", e);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeErrorEvents(long minId, long maxId) {
        this.ensureErrorsCount();
        SQLiteDatabase db = null;
        String ID_FIELD_NAME = "id";
        String filter = String.format(Locale.US, "%s >= %d AND %s <= %d", ID_FIELD_NAME, minId, ID_FIELD_NAME, maxId);
        int deleted = -1;
        PayloadDatabase payloadDatabase = this;
        synchronized (payloadDatabase) {
            try {
                db = this.getWritableDatabase();
                deleted = db.delete("errors_payload_table", filter, null);
                this.errorCount.addAndGet(-deleted);
            }
            catch (SQLiteException e) {
                Log.eToGaOnly(true, TAG, "Failed to remove items from the errors payload db: ", e);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        return deleted;
    }
}

