/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import aniways.com.google.analytics.tracking.android.Fields;
import aniways.com.google.analytics.tracking.android.GAServiceManager;
import aniways.com.google.analytics.tracking.android.GoogleAnalytics;
import aniways.com.google.analytics.tracking.android.Logger;
import aniways.com.google.analytics.tracking.android.MapBuilder;
import aniways.com.google.analytics.tracking.android.Tracker;
import com.aniways.Log;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import java.util.Locale;

public class GoogleAnalyticsReporter {
    private static Tracker sGaTracker;
    private static final String TAG = "AniwaysGoogleAnalyticsReporter";

    static void ReportTiming(AniwaysConfiguration.Verbosity verbosity, long measuredTime, String category, String name, String labelValueString) {
        if (AniwaysPrivateConfig.getInstance().gaTimingEventsVerbosity.ordinal() <= verbosity.ordinal()) {
            sGaTracker.send(MapBuilder.createTiming((String)category, (Long)measuredTime, (String)name, (String)labelValueString).build());
        }
    }

    static void reportView(String viewName) {
        AniwaysConfiguration.Verbosity verbosity = AniwaysConfiguration.Verbosity.Info;
        if (AniwaysPrivateConfig.getInstance().gaScreenEventsVerbosity.ordinal() <= verbosity.ordinal()) {
            sGaTracker.set("&cd", viewName);
            sGaTracker.send(MapBuilder.createAppView().build());
        }
    }

    static void reportNewSession() {
        if (!AniwaysPrivateConfig.getInstance().isGoogleAnalyticsDisabled()) {
            GoogleAnalyticsReporter.dispatchGaEvents();
            MapBuilder builder = MapBuilder.createAppView();
            builder.set("&sc", "start");
            sGaTracker.set("&cd", "Unknown");
            sGaTracker.send(builder.build());
        }
    }

    static void reportException(String stack, Boolean isFatal) {
        if (AniwaysPrivateConfig.getInstance().googleAnalyticsEventsVerbosity.ordinal() <= AniwaysConfiguration.Verbosity.Error.ordinal()) {
            sGaTracker.send(MapBuilder.createException((String)stack, (Boolean)isFatal).build());
        }
    }

    public static void reportEvent(AniwaysConfiguration.Verbosity verbosity, String category, String action, String label, long value) {
        if (AniwaysPrivateConfig.getInstance().googleAnalyticsEventsVerbosity.ordinal() <= verbosity.ordinal()) {
            sGaTracker.send(MapBuilder.createEvent((String)category, (String)action, (String)label, (Long)value).build());
        }
    }

    static void dispatchGaEvents() {
        if (!AniwaysPrivateConfig.getInstance().isGoogleAnalyticsDisabled()) {
            GAServiceManager.getInstance().dispatchLocalHits();
        }
    }

    public static void forceInit(Context applicationContext) {
        String googleAnalyticsId = AniwaysPrivateConfig.getInstance().googleAnalyticsId;
        Log.i(TAG, "Calling init of GoogleAnalyticsReporter. New google analytics id is: " + googleAnalyticsId);
        GoogleAnalytics gaInstance = GoogleAnalytics.getInstance((Context)applicationContext);
        GAServiceManager.getInstance().setLocalDispatchPeriod(AniwaysPrivateConfig.getInstance().gaDispatchPeriod);
        gaInstance.getLogger().setLogLevel(GoogleAnalyticsReporter.getLogLevel());
        sGaTracker = gaInstance.getTracker(googleAnalyticsId);
        PackageManager manager = applicationContext.getPackageManager();
        PackageInfo info = null;
        try {
            info = manager.getPackageInfo(applicationContext.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(true, TAG, "Could not get package name", e);
        }
        GoogleAnalyticsReporter.reportNewSession();
        int versionCode = info == null ? 0 : info.versionCode;
        String versionName = info == null ? "Unknown" : info.versionName;
        GoogleAnalyticsReporter.reportCustomDimention(1, String.format(Locale.US, "%sX%sX%d", "2.3.08", versionName, versionCode));
        GoogleAnalyticsReporter.reportCustomDimention(2, String.format(Locale.US, "%s", "2.3.08"));
        GoogleAnalyticsReporter.reportCustomDimention(3, String.format(Locale.US, "%d", versionCode));
        GoogleAnalyticsReporter.reportCustomDimention(6, AniwaysPrivateConfig.getInstance().version + "x" + AniwaysPrivateConfig.getInstance().versionName);
        GoogleAnalyticsReporter.reportCustomDimention(7, AniwaysPrivateConfig.getInstance().appId);
        GoogleAnalyticsReporter.dispatchGaEvents();
    }

    private static Logger.LogLevel getLogLevel() {
        return AniwaysPrivateConfig.getInstance().gaDebug ? Logger.LogLevel.VERBOSE : Logger.LogLevel.WARNING;
    }

    static boolean isInitialized() {
        return sGaTracker != null;
    }

    public static void reportCustomDimention(int index, String value) {
        if (AniwaysPrivateConfig.getInstance().isGoogleAnalyticsDisabled()) {
            return;
        }
        sGaTracker.send(MapBuilder.createAppView().set(Fields.customDimension((int)index), value).build());
    }

    public static void onConfigChange(AniwaysPrivateConfig newConfig, Context context) {
        GoogleAnalyticsReporter.forceInit(context);
    }
}

