/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.aniways.AniwaysCommercialPhraseMatcher;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.ViewUtils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.Phrase;
import com.aniways.volley.toolbox.NetworkImageView;
import com.aniways.volley.toolbox.Volley;
import java.util.List;

public class AniwaysMessageListViewItemWrapperLayout
extends LinearLayout {
    private static final String TAG = "AniwaysMessageListViewItemWrapperLayout";
    private ImageView mAdvertisement;
    private IAniwaysTextContainer mTextContainer;
    private OnSetTextListener mSetTextListener;

    public AniwaysMessageListViewItemWrapperLayout(Context context) {
        this(context, null);
    }

    public AniwaysMessageListViewItemWrapperLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        if (!this.isInEditMode()) {
            // empty if block
        }
        this.init(context);
    }

    @SuppressLint(value={"NewApi"})
    public AniwaysMessageListViewItemWrapperLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.setOrientation(1);
        this.mSetTextListener = new OnSetTextListener(){

            @Override
            public void onSetText(CharSequence newText) {
                Phrase p;
                if (AniwaysMessageListViewItemWrapperLayout.this.mAdvertisement != null) {
                    AniwaysMessageListViewItemWrapperLayout.this.removeView((View)AniwaysMessageListViewItemWrapperLayout.this.mAdvertisement);
                    AniwaysMessageListViewItemWrapperLayout.this.mAdvertisement = null;
                }
                if ((p = AniwaysMessageListViewItemWrapperLayout.this.getAdvertisementPhrase(newText)) == null) {
                    return;
                }
                AniwaysMessageListViewItemWrapperLayout.this.addAdvertisement(p);
            }
        };
    }

    private void addAdvertisement(Phrase p) {
        NetworkImageView advertisement = new NetworkImageView(this.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        advertisement.setPadding(config.bannerPaddingLeft, config.bannerPaddingTop, config.bannerPaddingRight, config.bannerPaddingBottom);
        super.addView((View)advertisement, params);
        final IconData icon = p.emoticonsPhraseAssetBuilder.icons[0];
        advertisement.setImageUrl(config.getIconUrl(icon, false, true), icon, Volley.getImageLoader(), config.bannerHeight, config.bannerHeight, true);
        if (icon.hasExternalData()) {
            advertisement.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        String externalActivityPackage = icon.getExternalActivityPackage();
                        String externalWebsite = icon.getExternalWebsite();
                        Context context = AniwaysMessageListViewItemWrapperLayout.this.getContext();
                        if (!TextUtils.isEmpty((CharSequence)externalActivityPackage)) {
                            Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(externalActivityPackage);
                            if (launchIntent != null) {
                                Log.i(AniwaysMessageListViewItemWrapperLayout.TAG, "Starting external application: " + externalActivityPackage);
                                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application", externalActivityPackage, icon.getFileName(), 0L);
                                AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{icon}, AniwaysStoreManager.isIconUnlocked(icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, externalActivityPackage, AnalyticsReporter.ExternalDataType.openApp, IAniwaysImageSpan.ImageSpanMetadata.Empty);
                                context.startActivity(launchIntent);
                            } else {
                                try {
                                    Log.i(AniwaysMessageListViewItemWrapperLayout.TAG, "External application package " + externalActivityPackage + " not found, trying to start google market");
                                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application on Google market", externalActivityPackage, icon.getFileName(), 0L);
                                    AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{icon}, AniwaysStoreManager.isIconUnlocked(icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mExternalActivityPackage", AnalyticsReporter.ExternalDataType.openGooglePlay, IAniwaysImageSpan.ImageSpanMetadata.Empty);
                                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + externalActivityPackage))));
                                }
                                catch (ActivityNotFoundException anfe) {
                                    Log.i(AniwaysMessageListViewItemWrapperLayout.TAG, "Google market not found on device starting browser, openApp: " + externalActivityPackage);
                                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application on browser", externalActivityPackage, icon.getFileName(), 0L);
                                    AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{icon}, AniwaysStoreManager.isIconUnlocked(icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, "Browser:" + externalActivityPackage, AnalyticsReporter.ExternalDataType.openGooglePlayBrowser, IAniwaysImageSpan.ImageSpanMetadata.Empty);
                                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("http://play.google.com/store/apps/details?id=" + externalActivityPackage))));
                                }
                            }
                        } else if (!TextUtils.isEmpty((CharSequence)externalWebsite)) {
                            Intent i = new Intent("android.intent.action.VIEW");
                            i.setData(Uri.parse((String)externalWebsite));
                            Log.i(AniwaysMessageListViewItemWrapperLayout.TAG, "Starting browser with url: " + externalWebsite);
                            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External link", externalWebsite, icon.getFileName(), 0L);
                            AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{icon}, AniwaysStoreManager.isIconUnlocked(icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, externalWebsite, AnalyticsReporter.ExternalDataType.openWebsiteInBrowser, IAniwaysImageSpan.ImageSpanMetadata.Empty);
                            context.startActivity(i);
                        }
                    }
                    catch (Throwable ex) {
                        Log.e(true, AniwaysMessageListViewItemWrapperLayout.TAG, "Caught exception in onClick", ex);
                    }
                }
            });
        }
        this.mAdvertisement = advertisement;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        int numChildren;
        if (this.mAdvertisement != null && (index == (numChildren = this.getChildCount()) || index < 0)) {
            index = numChildren - 1;
        }
        super.addView(child, index, params);
        if (child instanceof IAniwaysTextContainer) {
            this.registerForTextChangeInTextView();
        }
    }

    public void removeView(View view) {
        super.removeView(view);
        this.onRemoveView(view);
    }

    private void onRemoveView(View view) {
        if (view == this.mTextContainer.getView()) {
            this.unregisterSetTextListener();
            this.registerForTextChangeInTextView();
        }
    }

    IAniwaysTextContainer getAniwaysTextContainer() {
        if (this.mTextContainer != null) {
            return this.mTextContainer;
        }
        List<IAniwaysTextContainer> textContainers = ViewUtils.find((ViewGroup)this, IAniwaysTextContainer.class);
        if (textContainers == null || textContainers.isEmpty()) {
            return null;
        }
        this.mTextContainer = textContainers.get(0);
        return this.mTextContainer;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        Log.i(TAG, "Finished inflating");
        if (this.isInEditMode()) {
            return;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        this.registerForTextChangeInTextView();
    }

    private void registerForTextChangeInTextView() {
        IAniwaysTextContainer textContainer = this.getAniwaysTextContainer();
        if (textContainer == null) {
            return;
        }
        textContainer.registerSetTextListener(this.mSetTextListener);
    }

    private void unregisterSetTextListener() {
        if (this.mTextContainer == null) {
            return;
        }
        this.mTextContainer.unregisterSetTextListener(this.mSetTextListener);
    }

    private Phrase getAdvertisementPhrase(CharSequence text) {
        return AniwaysCommercialPhraseMatcher.getInstance().isMatch(text.toString());
    }

    public static interface OnSetTextListener {
        public void onSetText(CharSequence var1);
    }
}

