/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.content.Context;
import android.text.Spannable;
import android.widget.EditText;
import com.aniways.AniwaysIgnorePhraseSpan;
import com.aniways.AniwaysNonSelectedWordMarkerSpan;
import com.aniways.AniwaysSuggestionSpan;
import com.aniways.AniwaysSuggestionSpanForAutoreplace;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IAniwaysWordMarkerSpan;
import com.aniways.ISuggestionDisplayer;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AniwaysMarkerInserter {
    public static final Map<Pattern, String> KEYWORDS = new HashMap<Pattern, String>();
    private static final String TAG = "AniwaysMarkerInserter";
    public static boolean sMapComplete = false;

    AniwaysMarkerInserter() {
    }

    static boolean addSuggestionMarkersToText(Spannable spannable, ISuggestionDisplayer suggestionDisplayer, JsonParser parser, Context context) {
        if (!AniwaysPrivateConfig.getInstance().contextualIconSuggestionsEnabled) {
            return false;
        }
        AniwaysMarkerInserter.removeAllSpansThatDoNotIntersectImageSpan(spannable, 0, spannable.length(), AniwaysSuggestionSpan.class);
        AniwaysMarkerInserter.removeAllSpansThatDoNotIntersectImageSpan(spannable, 0, spannable.length(), IAniwaysWordMarkerSpan.class);
        String s = spannable.toString().toLowerCase(Locale.US);
        String[] words = s.split("\\b|\\B(?=\\W)");
        boolean hasChanges = false;
        boolean ignorePhraseDetected = false;
        HashSet<String> ignoreWords = AniwaysPrivateConfig.getInstance().autoreplaceIgnorePhrases;
        int maxDepth = AniwaysPrivateConfig.getInstance().maxWordsInPhrase + AniwaysPrivateConfig.getInstance().maxWordsInPhrase - 1;
        int wordNumber = 0;
        int lengthSoFar = 0;
        int start = 0;
        int end = 0;
        String[] stringArray = words;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String word;
            String origWord = word = stringArray[i];
            StringBuilder sb = new StringBuilder(word);
            for (int i2 = 0; i2 < maxDepth; ++i2) {
                int index;
                start = lengthSoFar;
                if (i2 > 0) {
                    int lastWord = wordNumber + i2;
                    if (lastWord >= words.length) break;
                    sb.append(words[lastWord]);
                    word = sb.toString();
                }
                end = lengthSoFar + word.length();
                if (ignoreWords.contains(word)) {
                    ignorePhraseDetected = true;
                    AniwaysMarkerInserter.removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysSuggestionSpan.class);
                    AniwaysMarkerInserter.removeAllSpansIfCompletelyInRange(spannable, start, end, IAniwaysWordMarkerSpan.class);
                    AniwaysIgnorePhraseSpan ignoreSpan = new AniwaysIgnorePhraseSpan();
                    spannable.setSpan((Object)ignoreSpan, start, end, 33);
                    continue;
                }
                Phrase phrase = parser.getPhraseByName(word);
                if (phrase == null || AniwaysMarkerInserter.isRangeIntersectImageSpan(spannable, start += (index = phrase.getIndexOfPartToReplaceInPhrase()), end = start + phrase.getLengthOfPartToReplace())) continue;
                boolean spanLargerThanRangeExists = AniwaysMarkerInserter.removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysIgnorePhraseSpan.class);
                spanLargerThanRangeExists |= AniwaysMarkerInserter.removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysSuggestionSpan.class);
                if (spanLargerThanRangeExists |= AniwaysMarkerInserter.removeAllSpansIfCompletelyInRange(spannable, start, end, IAniwaysWordMarkerSpan.class)) continue;
                String originalWord = spannable.subSequence(start, end).toString();
                AniwaysSuggestionSpan ass = new AniwaysSuggestionSpan(phrase, suggestionDisplayer, originalWord);
                AniwaysNonSelectedWordMarkerSpan awms = new AniwaysNonSelectedWordMarkerSpan(context, originalWord, ((EditText)suggestionDisplayer).getTextSize());
                spannable.setSpan((Object)awms, start, end, 18);
                spannable.setSpan((Object)ass, start, end, 33);
                hasChanges = true;
            }
            lengthSoFar += origWord.length();
            ++wordNumber;
        }
        if (ignorePhraseDetected) {
            AniwaysMarkerInserter.removeAllSpansIfCompletelyInRange(spannable, 0, spannable.length(), AniwaysIgnorePhraseSpan.class);
        }
        return hasChanges;
    }

    static boolean addSuggestionMarkersToText(Spannable spannable, Pattern phrases, HashSet<String> ignorePhrases, JsonParser parser) {
        boolean hasChanges = false;
        if (phrases == null) {
            return false;
        }
        if (ignorePhrases == null) {
            ignorePhrases = new HashSet();
        }
        Matcher m = phrases.matcher((CharSequence)spannable);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String name = m.group().toLowerCase(Locale.US);
            if (ignorePhrases.contains(name)) continue;
            Phrase phrase = parser.getPhraseByName(name);
            if (phrase == null) {
                if (parser.getKeywordsVersion().equalsIgnoreCase("0.0")) continue;
                Log.w(true, TAG, "The word is set to be autoreplaced, but is not in the mapping. " + name + ". parser version: " + parser.getKeywordsVersion());
                continue;
            }
            int index = name.indexOf(phrase.getPartToReplace());
            if (AniwaysMarkerInserter.isRangeIntersectImageSpan(spannable, start += index, end = start + phrase.getPartToReplace().length())) continue;
            boolean spanLargerThanRangeExists = AniwaysMarkerInserter.removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysSuggestionSpan.class);
            if (spanLargerThanRangeExists |= AniwaysMarkerInserter.removeAllSpansIfCompletelyInRange(spannable, start, end, AniwaysIgnorePhraseSpan.class)) continue;
            String originalText = spannable.subSequence(start, end).toString();
            AniwaysSuggestionSpanForAutoreplace ass = new AniwaysSuggestionSpanForAutoreplace(phrase, null, originalText);
            try {
                spannable.setSpan((Object)ass, start, end, 33);
            }
            catch (IndexOutOfBoundsException ex) {
                Log.e(true, TAG, "Error while setting suggestion span. Orig message: " + spannable + ". to lower: " + spannable.toString().toLowerCase(Locale.US) + ". Word: " + name + ". Start: " + start + ". End: " + end + ". Spannable length: " + spannable.length() + ". Phrase: " + phrase);
            }
            hasChanges = true;
        }
        return hasChanges;
    }

    private static <T> void removeAllSpansThatDoNotIntersectImageSpan(Spannable spannable, int start, int end, Class<T> cl) {
        Object[] spans;
        for (Object span : spans = spannable.getSpans(start, end, cl)) {
            AniwaysMarkerInserter.RemoveSpanIfNotIntersectImageSpan(spannable, span);
        }
    }

    private static <T> boolean removeAllSpansIfCompletelyInRange(Spannable spannable, int start, int end, Class<T> cl) {
        Object[] spans;
        boolean spanBiggerThanRangeExists = false;
        for (Object span : spans = spannable.getSpans(start, end, cl)) {
            if (spannable.getSpanStart(span) >= start && spannable.getSpanEnd(span) <= end) {
                spannable.removeSpan(span);
                continue;
            }
            spanBiggerThanRangeExists = true;
        }
        return spanBiggerThanRangeExists;
    }

    private static void RemoveSpanIfNotIntersectImageSpan(Spannable spannable, Object span) {
        boolean spansIntersect = AniwaysMarkerInserter.isSpanIntersectImageSpan(spannable, span);
        if (!spansIntersect) {
            spannable.removeSpan(span);
        }
    }

    private static boolean isSpanIntersectImageSpan(Spannable spannable, Object span) {
        int start = spannable.getSpanStart(span);
        int end = spannable.getSpanEnd(span);
        return AniwaysMarkerInserter.isRangeIntersectImageSpan(spannable, start, end);
    }

    private static boolean isRangeIntersectImageSpan(Spannable spannable, int start, int end) {
        IAniwaysImageSpan[] ImageSpans = (IAniwaysImageSpan[])spannable.getSpans(start, end, IAniwaysImageSpan.class);
        boolean spansIntersect = false;
        for (IAniwaysImageSpan is : ImageSpans) {
            int isStart = spannable.getSpanStart((Object)is);
            int isEnd = spannable.getSpanEnd((Object)is);
            if (isStart >= end || isEnd <= start) continue;
            spansIntersect = true;
        }
        return spansIntersect;
    }
}

