/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.app.Activity;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.text.Editable;
import android.text.Spannable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.aniways.AniwaysEditText;
import com.aniways.AniwaysIconConverter;
import com.aniways.AniwaysMarkerInserter;
import com.aniways.AniwaysSuggestionSpan;
import com.aniways.AniwaysTutorialPopupWindow;
import com.aniways.AniwaysTutorialView;
import com.aniways.EmojiWithVarientSelector;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IAniwaysTextWatcher;
import com.aniways.IAniwaysWordMarkerSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.contextual.ContextualPopup;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.AppData;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker;
import com.aniways.quick.action.QuickAction;
import java.util.ArrayList;

public class AniwaysEditTextTextWatcher
implements IAniwaysTextWatcher {
    private AniwaysEditText mMessageEditor;
    private AniwaysTutorialPopupWindow mTutorialWindow;
    private AniwaysTutorialView mTutorialView;
    private Editable mEditable;
    private Rect mMarkedWordRect;
    private AniwaysSuggestionSpan mAniwaysSuggestionSpanForTutorial;
    private IAniwaysImageSpan mImageSpanToRemove;
    private CharSequence mTextBelowImageSpan;
    private IAniwaysWordMarkerSpan mMarkerSpanToRemove;
    private CharSequence mTextBelowMarkerSpan;
    private int mMarkerSpanToRemoveStart;
    private CharSequence textBeforeTextChange;
    private AniwaysSuggestionSpan mSuggestionSpanForTheReplacedImage;
    private int mNewTextStart;
    private int mNewTextEnd;
    private String mNewText;
    private int mPlaceToWatchOutForReAddingDeletedTextBelowMarkerSpan;
    private int mTextToRemoveStart;
    private CharSequence mTextToRemove;
    private String mPreviousTextReported;
    private boolean mDuplicateChangeReported;
    private boolean mLeftPopupOpenDueToSpace;
    private static final String TAG = "AniwaysEditTextTextWatcher";

    public AniwaysEditTextTextWatcher(AniwaysEditText messageEditor) {
        this.mMessageEditor = messageEditor;
        try {
            LayoutInflater inflater = (LayoutInflater)messageEditor.getContext().getSystemService("layout_inflater");
            this.mTutorialView = (AniwaysTutorialView)inflater.inflate(R.layout.aniways_contextual_suggestions_tutorial, null);
            Button closeTutorialButton = (Button)this.mTutorialView.findViewById(R.id.aniways_tutorial_close_button);
            if (this.mTutorialView.isNimbuzz()) {
                Log.d(TAG, "Nimbuzz detected");
                closeTutorialButton.setVisibility(8);
            } else {
                Log.d(TAG, "Showing regular tutorial");
                View disableText = this.mTutorialView.findViewById(R.id.aniways_tutorail_settings_text);
                disableText.setVisibility(8);
                closeTutorialButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        try {
                            AniwaysEditTextTextWatcher.this.cancelTutorial();
                        }
                        catch (Throwable ex) {
                            Log.e(true, AniwaysEditTextTextWatcher.TAG, "Caught Exception in onClick", ex);
                        }
                    }
                });
            }
            this.mTutorialView.setOnTutorialWindowSingleTapConfirmed(new AniwaysTutorialView.onTutorialWindowSingleTapConfirmed(){

                @Override
                public boolean tutorialWindowSingleTapConfirmed(boolean inHighlightedArea) {
                    try {
                        if (AniwaysEditTextTextWatcher.this.mTutorialWindow != null && AniwaysEditTextTextWatcher.this.mTutorialWindow.isShowing()) {
                            if (inHighlightedArea) {
                                AniwaysEditTextTextWatcher.this.mTutorialWindow.dismiss();
                                if (AniwaysEditTextTextWatcher.this.mAniwaysSuggestionSpanForTutorial != null) {
                                    AniwaysEditTextTextWatcher.this.mMessageEditor.displaySuggestions(AniwaysEditTextTextWatcher.this.mAniwaysSuggestionSpanForTutorial, AniwaysPhraseReplacementData.getDataParser(), IAniwaysImageSpan.IconSelectionOrigin.ContextualManual);
                                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Tutorial Phrase Clicked", "tutorial display number: " + AppData.getInt("edit_text_tutorial_showed_times") + ", phrase: " + ((AniwaysEditTextTextWatcher)AniwaysEditTextTextWatcher.this).mAniwaysSuggestionSpanForTutorial.phrase.getPhraseSubPhraseString(), 0L);
                                    AnalyticsReporter.reportEditTextTutorialEvent(AnalyticsReporter.EditTextTutorialAction.phraseClicked, AniwaysEditTextTextWatcher.this.mMessageEditor.getMessageId(), ((AniwaysEditTextTextWatcher)AniwaysEditTextTextWatcher.this).mAniwaysSuggestionSpanForTutorial.phrase, AppData.getInt("edit_text_tutorial_showed_times"));
                                    return true;
                                }
                            } else if (AniwaysPrivateConfig.getInstance().closeTutorialOnClickAnywhere) {
                                AniwaysEditTextTextWatcher.this.cancelTutorial();
                                return true;
                            }
                        }
                        return false;
                    }
                    catch (Throwable ex) {
                        Log.e(true, AniwaysEditTextTextWatcher.TAG, "Caught Exception in highlightedEllipseSingleTapConfirmed", ex);
                        return false;
                    }
                }
            });
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception while creating edit text text watcher");
        }
    }

    public void afterTextChanged(Editable editable) {
        if (this.mDuplicateChangeReported) {
            Log.v(TAG, "Duplicate text change reported. Ignoring.");
            return;
        }
        try {
            AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
            if (!config.contextualIconSuggestionsEnabled && config.debugPerformance) {
                return;
            }
            Log.d(TAG, "in after text changed");
            if (this.mImageSpanToRemove != null) {
                Log.d(TAG, "afterTextChanged: " + (editable.getSpanStart((Object)this.mImageSpanToRemove) >= 0 ? "true" : "false"));
            }
            this.mEditable = editable;
            this.mAniwaysSuggestionSpanForTutorial = null;
            long startTime = System.currentTimeMillis();
            if (this.mNewText != null && !this.mLeftPopupOpenDueToSpace) {
                switch (this.mNewText.length()) {
                    case 1: {
                        if (this.mNewText.charAt(0) == ' ') {
                            Log.v(TAG, "Found a first space after a phrase, leaving the popup as is.");
                            this.mLeftPopupOpenDueToSpace = true;
                            return;
                        }
                        if (!config.leaveAutoPopupOpenCharacters.contains(this.mNewText.subSequence(0, 1))) break;
                        Log.v(TAG, "Found a special character, leaving the popup as is.");
                        this.mLeftPopupOpenDueToSpace = false;
                        return;
                    }
                    case 2: {
                        if (!Character.isSurrogatePair(this.mNewText.charAt(0), this.mNewText.charAt(1)) || !config.leaveAutoPopupOpenCharacters.contains(this.mNewText.subSequence(0, 2))) break;
                        Log.v(TAG, "Found a special surrogate pair, leaving the popup as is.");
                        this.mLeftPopupOpenDueToSpace = false;
                        return;
                    }
                }
            }
            this.mLeftPopupOpenDueToSpace = false;
            IAniwaysTextWatcher watcher = this.mMessageEditor.removeTheAniwaysTextWatcher();
            this.assertWatcherIsThis(watcher);
            if (editable == this.textBeforeTextChange) {
                Log.d(TAG, "Start take care of span deletions");
                this.takeCareOfAniwaysSpanDeletions(editable);
                Log.d(TAG, "End take care of span deletions");
            }
            boolean shouldDismissExistingContextualPopup = true;
            if (this.mEditable.length() > 0) {
                long startTime2 = System.currentTimeMillis();
                JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
                Log.d(TAG, "Start add markers");
                AniwaysMarkerInserter.addSuggestionMarkersToText((Spannable)this.mEditable, this.mMessageEditor, parser, this.mMessageEditor.getContext());
                Log.d(TAG, "End add markers");
                AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Statistical, startTime2, "Performance", "Phrase Highlighting", String.valueOf(this.mEditable.length()), TAG, "num chars");
                int selStart = this.mMessageEditor.getSelectionStart();
                int selEnd = this.mMessageEditor.getSelectionEnd();
                AniwaysSuggestionSpan[] aniwaysSuggestionSpanCandidatesForTutorial = (AniwaysSuggestionSpan[])this.mEditable.getSpans(selStart, selEnd, AniwaysSuggestionSpan.class);
                if (aniwaysSuggestionSpanCandidatesForTutorial != null && aniwaysSuggestionSpanCandidatesForTutorial.length > 0) {
                    for (AniwaysSuggestionSpan candidateSpan : aniwaysSuggestionSpanCandidatesForTutorial) {
                        int spanEnd;
                        boolean foundCoveringImageSpan = false;
                        boolean foundCoveredMarkerSpan = false;
                        int spanStart = this.mEditable.getSpanStart((Object)candidateSpan);
                        IAniwaysImageSpan[] imageSpans = (IAniwaysImageSpan[])this.mEditable.getSpans(spanStart, spanEnd = this.mEditable.getSpanEnd((Object)candidateSpan), IAniwaysImageSpan.class);
                        if (imageSpans != null && imageSpans.length > 0) {
                            for (IAniwaysImageSpan imageSpan : imageSpans) {
                                int st = this.mEditable.getSpanStart((Object)imageSpan);
                                int e = this.mEditable.getSpanEnd((Object)imageSpan);
                                if (st == spanEnd || e == spanStart) continue;
                                foundCoveringImageSpan = true;
                                break;
                            }
                        }
                        if (foundCoveringImageSpan) continue;
                        IAniwaysWordMarkerSpan[] markerSpans = (IAniwaysWordMarkerSpan[])this.mEditable.getSpans(spanStart, spanEnd, IAniwaysWordMarkerSpan.class);
                        if (markerSpans != null && markerSpans.length > 0) {
                            for (IAniwaysWordMarkerSpan ms : markerSpans) {
                                int st = this.mEditable.getSpanStart((Object)ms);
                                int e = this.mEditable.getSpanEnd((Object)ms);
                                if (st != spanStart || e != spanEnd) continue;
                                foundCoveredMarkerSpan = true;
                                break;
                            }
                        }
                        if (!foundCoveredMarkerSpan) {
                            Log.e(true, TAG, "Could not find a marker span underneath a suggestion span without an image above it");
                            continue;
                        }
                        this.mAniwaysSuggestionSpanForTutorial = candidateSpan;
                        break;
                    }
                }
                if (this.mAniwaysSuggestionSpanForTutorial != null) {
                    ArrayList<String> wordsThatDisplayedTutorial;
                    String phrase;
                    int timesShowedTutorial;
                    boolean allowTutorial = false;
                    switch (config.suggestionMode) {
                        case Manual: {
                            allowTutorial = true;
                            break;
                        }
                        case AutoDisplaySuggestions: {
                            shouldDismissExistingContextualPopup = false;
                            this.mMessageEditor.displaySuggestions(this.mAniwaysSuggestionSpanForTutorial, parser, IAniwaysImageSpan.IconSelectionOrigin.ContextualAuto);
                            break;
                        }
                        case AutoReplacePhrases: {
                            shouldDismissExistingContextualPopup = false;
                            this.mMessageEditor.replaceSuggestionWithIcon(this.mAniwaysSuggestionSpanForTutorial, parser, IAniwaysImageSpan.IconSelectionOrigin.Autoreplace);
                        }
                    }
                    if (allowTutorial && config.useEditTextTutorial && !AniwaysEmoticonsButtonMaker.isEmoticonsButtonShowing() && this.mImageSpanToRemove == null && AppData.getInt("manual_taps_count_times") < AniwaysPrivateConfig.smartUseMarkerTapCount && (timesShowedTutorial = AppData.getInt("edit_text_tutorial_showed_times")) < config.maxTimesToShowTutorial && !Utils.isStringEmpty(phrase = this.mAniwaysSuggestionSpanForTutorial.phrase.getPartToReplace().trim()) && !(wordsThatDisplayedTutorial = AppData.getStringList("words_that_displayed_tutorial")).contains(phrase)) {
                        if (timesShowedTutorial == 0 || wordsThatDisplayedTutorial.size() / timesShowedTutorial >= config.numberOfWordsRequiredToShowTutorialAgain && AppData.getInt("manual_taps_count_times") <= timesShowedTutorial) {
                            this.mMarkedWordRect = this.calculateMarkedWordRect();
                            if (this.mMarkedWordRect != null && this.mMarkedWordRect.left < this.mMarkedWordRect.right) {
                                ContextualPopup.dismissAllOpenPopups();
                                this.showTutorialPopupWindow();
                                int timeTutorialShown = AppData.incrementInt("edit_text_tutorial_showed_times");
                                AnalyticsReporter.reportEditTextTutorialEvent(AnalyticsReporter.EditTextTutorialAction.opened, this.mMessageEditor.getMessageId(), this.mAniwaysSuggestionSpanForTutorial == null ? null : this.mAniwaysSuggestionSpanForTutorial.phrase, timeTutorialShown);
                            } else if (this.mMarkedWordRect == null) {
                                Log.w(true, TAG, "mMarkedWordRect is null, so not signaling to show tutorial");
                            }
                        }
                        AppData.putStringList("words_that_displayed_tutorial", wordsThatDisplayedTutorial);
                    }
                }
            }
            if (shouldDismissExistingContextualPopup) {
                ContextualPopup.dismissAllOpenPopups();
            }
            watcher = this.mMessageEditor.addTheAniwaysTextWatcher();
            this.assertWatcherIsThis(watcher);
            Log.d(TAG, "ATC end");
            AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Verbose, startTime, "Performance", "After Text Change Processing", String.valueOf(this.mEditable.length()), TAG, "num chars");
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in Aftet text changed. Message is: " + editable, ex);
        }
    }

    private void takeCareOfAniwaysSpanDeletions(Editable s) {
        try {
            Editable newText;
            Log.d(TAG, "Text below marker span: " + this.mTextBelowMarkerSpan + ". Below image span: " + this.mTextBelowImageSpan);
            if (this.mNewTextEnd <= s.length() && (newText = (Editable)s.subSequence(this.mNewTextStart, this.mNewTextEnd)) != null && newText.toString().equalsIgnoreCase(this.mNewText)) {
                int skip;
                Log.d(TAG, "Start make image spans fit emojis");
                boolean changed = AniwaysEditTextTextWatcher.makeImageSpansFitEmojiAgain((Spannable)s, this.mNewTextStart, this.mNewTextEnd, AniwaysPhraseReplacementData.getDataParser());
                Log.d(TAG, "End make image spans fit emojis. Changed something: " + changed);
                Log.d(TAG, "Start handle uncovered emojis");
                boolean coveredSomething = AniwaysIconConverter.handleUncoveredEmoji(s, this.mNewTextStart, this.mNewTextEnd, AniwaysPhraseReplacementData.getDataParser(), this.mMessageEditor.getContext(), this.mMessageEditor, null, false, false, true);
                Log.d(TAG, "End handle uncovered emojis. Covered something: " + coveredSomething);
                Log.d(TAG, "Start remove isolated surrogates");
                int mNewTextEnd = this.mNewTextStart + newText.length();
                for (int i = this.mNewTextStart; i < mNewTextEnd; i += skip) {
                    char c = s.charAt(i);
                    boolean remove = false;
                    skip = 1;
                    if (Character.isHighSurrogate(c)) {
                        if (this.mNewTextStart + 1 == s.length() || !Character.isLowSurrogate(s.charAt(i + 1))) {
                            remove = true;
                        } else {
                            ++skip;
                        }
                    } else if (Character.isLowSurrogate(c) && (this.mNewTextStart == 0 || !Character.isHighSurrogate(s.charAt(i - 1)))) {
                        remove = true;
                    }
                    if (!remove) continue;
                    s.delete(this.mNewTextStart, this.mNewTextStart + 1);
                    --mNewTextEnd;
                    Log.w(false, TAG, "Removed lone surrogate");
                }
                Log.d(TAG, "End remove isolated surrogates");
            }
            if (this.mImageSpanToRemove != null) {
                int start = this.mEditable.getSpanStart((Object)this.mImageSpanToRemove);
                if (start >= 0) {
                    Log.d(TAG, "ATC deletion of icon needing deletion detected");
                    int end = this.mEditable.getSpanEnd((Object)this.mImageSpanToRemove);
                    this.mEditable.removeSpan((Object)this.mImageSpanToRemove);
                    this.mEditable.removeSpan((Object)this.mSuggestionSpanForTheReplacedImage);
                    this.mEditable.delete(start, end);
                    this.mMessageEditor.setSelection(start);
                    Log.d(TAG, "Completely deleted an icon, and the text below it. Start pos: " + start + ". End: " + end);
                }
            } else if (this.mMarkerSpanToRemove != null) {
                Log.d(TAG, "ATC deletion of marker span detected");
                int start = this.mMarkerSpanToRemoveStart;
                int length = this.mTextBelowMarkerSpan.length() - 1;
                String textToAdd = this.mTextBelowMarkerSpan.subSequence(0, length).toString();
                Log.d(TAG, "Adding text that was below deleted marker span: " + textToAdd + ". Pos: " + start);
                this.mEditable.insert(start, (CharSequence)textToAdd);
                this.mMessageEditor.setSelection(start + length);
            } else if (this.mTextToRemove != null) {
                int start = this.mTextToRemoveStart;
                int selStart = this.mMessageEditor.getSelectionStart();
                Log.d(TAG, "Deleting text to remove: " + this.mTextToRemove + ". At position: " + start);
                this.mEditable.delete(start, start + this.mTextToRemove.length());
                this.mMessageEditor.setSelection(selStart - this.mTextToRemove.length());
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception while taking care of span deletion.", ex);
        }
    }

    private static boolean makeImageSpansFitEmojiAgain(Spannable text, int start, int end, JsonParser parser) {
        boolean result = false;
        IAniwaysImageSpan[] spans = (IAniwaysImageSpan[])text.getSpans(start = Math.max(0, start - 3), end = Math.min(end + 3, text.length()), IAniwaysImageSpan.class);
        if (spans != null && spans.length > 0) {
            for (IAniwaysImageSpan span : spans) {
                int skip;
                int startSpan = text.getSpanStart((Object)span);
                int origEndSpan = text.getSpanEnd((Object)span);
                int endSpan = Math.min(text.length(), origEndSpan + 1);
                int startEmoji = -1;
                int endEmoji = -1;
                for (int i = startSpan; i < endSpan; i += skip) {
                    int nextUnicode;
                    IconData icon = null;
                    int unicode = Character.codePointAt((CharSequence)text, i);
                    skip = Character.charCount(unicode);
                    if (unicode > 255) {
                        icon = parser.getEmoji(unicode);
                    }
                    boolean secondUnicodeExists = false;
                    int followUnicode = -1;
                    if (icon == null && i + skip < endSpan && (icon = parser.getEmoji(new int[]{unicode, followUnicode = Character.codePointAt((CharSequence)text, i + skip)})) != null) {
                        secondUnicodeExists = true;
                        skip += Character.charCount(followUnicode);
                    }
                    if (icon != null && i + skip < endSpan && (nextUnicode = Character.codePointAt((CharSequence)text, i + skip)) == EmojiWithVarientSelector.EMOJI_VARIENT_SELECTOR) {
                        IconData oldIcon = icon;
                        icon = secondUnicodeExists ? parser.getEmojiWithVarientSelector(new int[]{unicode, followUnicode}) : parser.getEmojiWithVarientSelector(unicode);
                        if (icon == null) {
                            icon = new EmojiWithVarientSelector(oldIcon);
                            parser.addEmojiWithVarientSelector(icon);
                        }
                        skip += Character.charCount(nextUnicode);
                    }
                    if (icon == null) continue;
                    startEmoji = i;
                    endEmoji = i + skip;
                    break;
                }
                if (startEmoji == startSpan && endEmoji == origEndSpan) continue;
                result = true;
                text.removeSpan((Object)span);
                AniwaysSuggestionSpan ss = AniwaysEditTextTextWatcher.getSuggestionSpanBelowImage(text, startSpan, origEndSpan);
                if (ss != null) {
                    text.removeSpan((Object)ss);
                }
                if (startEmoji < 0 || endEmoji < 0 || startEmoji < startSpan || endEmoji > endSpan) continue;
                if (startEmoji > startSpan || endEmoji < origEndSpan) {
                    if (ss != null) {
                        text.setSpan((Object)ss, startEmoji, endEmoji, 33);
                    }
                    text.setSpan((Object)span, startEmoji, endEmoji, 33);
                    Log.d(TAG, "Reduced emoji from: " + startSpan + "-" + endSpan + " to: " + startEmoji + "-" + endEmoji);
                    continue;
                }
                if (startEmoji < startSpan || origEndSpan >= endSpan || endEmoji <= origEndSpan || endEmoji > endSpan) continue;
                if (ss != null) {
                    text.setSpan((Object)ss, startEmoji, endEmoji, 33);
                }
                text.setSpan((Object)span, startEmoji, endEmoji, 33);
                Log.d(TAG, "Expanded emoji from: " + startSpan + "-" + endSpan + " to: " + startEmoji + "-" + endEmoji);
            }
        }
        return result;
    }

    private static AniwaysSuggestionSpan getSuggestionSpanBelowImage(Spannable text, int startSpan, int endSpan) {
        AniwaysSuggestionSpan[] suggestionSpans = (AniwaysSuggestionSpan[])text.getSpans(startSpan, endSpan, AniwaysSuggestionSpan.class);
        if (suggestionSpans != null && suggestionSpans.length > 0) {
            for (AniwaysSuggestionSpan suggestionSpan : suggestionSpans) {
                int suggestionSpanStart = text.getSpanStart((Object)suggestionSpan);
                int end2 = text.getSpanEnd((Object)suggestionSpan);
                if (suggestionSpanStart != startSpan || end2 != endSpan) continue;
                return suggestionSpan;
            }
        }
        return null;
    }

    public void beforeTextChanged(CharSequence text, int start, int count, int after) {
        try {
            AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
            if (!config.contextualIconSuggestionsEnabled && config.debugPerformance) {
                return;
            }
            QuickAction.cancelAutoDismissOfAllOpenQuickActions();
            ContextualPopup.cancelAutoDismissOfAllOpenQuickActions();
            long startTime = System.currentTimeMillis();
            this.mTextToRemoveStart = -1;
            this.mTextToRemove = null;
            if (start == this.mPlaceToWatchOutForReAddingDeletedTextBelowMarkerSpan && this.mTextBelowMarkerSpan != null && count == 0 && after == this.mTextBelowMarkerSpan.length()) {
                this.mTextToRemove = this.mTextBelowMarkerSpan;
                this.mTextToRemoveStart = start - (this.mTextToRemove.length() - 1);
            }
            this.mImageSpanToRemove = null;
            this.mSuggestionSpanForTheReplacedImage = null;
            this.mTextBelowImageSpan = null;
            this.mMarkerSpanToRemove = null;
            this.mTextBelowMarkerSpan = null;
            this.mMarkerSpanToRemoveStart = -1;
            this.textBeforeTextChange = text;
            this.mPlaceToWatchOutForReAddingDeletedTextBelowMarkerSpan = -1;
            Log.d(TAG, "B4 text changed - start: " + start + " count: " + count + " after: " + after);
            if (after < count) {
                IAniwaysWordMarkerSpan[] markerSpans;
                int imageSpanToRemoveStart = -1;
                Spannable spannable = (Spannable)text;
                IAniwaysImageSpan[] imageSpans = (IAniwaysImageSpan[])spannable.getSpans(start + count, start + count, IAniwaysImageSpan.class);
                int imageSpanEnd = 0;
                if (imageSpans != null && imageSpans.length > 0) {
                    for (IAniwaysImageSpan span : imageSpans) {
                        imageSpanToRemoveStart = spannable.getSpanStart((Object)span);
                        if (imageSpanToRemoveStart != start + count) {
                            this.mImageSpanToRemove = span;
                            imageSpanEnd = spannable.getSpanEnd((Object)span);
                            this.mTextBelowImageSpan = text.subSequence(imageSpanToRemoveStart, imageSpanEnd).toString();
                            break;
                        }
                        imageSpanToRemoveStart = -1;
                    }
                }
                if (this.mImageSpanToRemove != null) {
                    AniwaysSuggestionSpan[] suggestionSpans = (AniwaysSuggestionSpan[])spannable.getSpans(imageSpanToRemoveStart, imageSpanEnd, AniwaysSuggestionSpan.class);
                    if (suggestionSpans != null && suggestionSpans.length > 0) {
                        for (AniwaysSuggestionSpan suggestionSpan : suggestionSpans) {
                            int spanStart = spannable.getSpanStart((Object)suggestionSpan);
                            int spanEnd = spannable.getSpanEnd((Object)suggestionSpan);
                            if (spanStart != imageSpanToRemoveStart || spanEnd != imageSpanEnd) continue;
                            this.mSuggestionSpanForTheReplacedImage = suggestionSpan;
                            break;
                        }
                    }
                } else if (after == 0 && (markerSpans = (IAniwaysWordMarkerSpan[])spannable.getSpans(start + count, start + count, IAniwaysWordMarkerSpan.class)) != null && markerSpans.length > 0) {
                    for (IAniwaysWordMarkerSpan span : markerSpans) {
                        this.mMarkerSpanToRemoveStart = spannable.getSpanStart((Object)span);
                        int markerSpanEnd = spannable.getSpanEnd((Object)span);
                        if (this.mMarkerSpanToRemoveStart == start && markerSpanEnd == start + count) {
                            this.mMarkerSpanToRemove = span;
                            this.mTextBelowMarkerSpan = text.subSequence(this.mMarkerSpanToRemoveStart, markerSpanEnd).toString();
                            this.mPlaceToWatchOutForReAddingDeletedTextBelowMarkerSpan = markerSpanEnd - 1;
                            break;
                        }
                        this.mMarkerSpanToRemoveStart = -1;
                    }
                }
                if (this.mImageSpanToRemove != null) {
                    try {
                        String removedIconPath = this.mImageSpanToRemove.getIcon().getFileName();
                        Phrase p = null;
                        String phraseString = null;
                        if (this.mSuggestionSpanForTheReplacedImage == null) {
                            if (this.mImageSpanToRemove.getIcon().iconSelectionTag == null) {
                                Log.w(false, TAG, "There was no suggestion span for a replaced image span: " + removedIconPath);
                            }
                        } else {
                            p = this.mSuggestionSpanForTheReplacedImage.phrase;
                            if (p == null) {
                                Log.e(true, TAG, "There is a deleting, but phrase is null: " + removedIconPath);
                            } else {
                                phraseString = Phrase.getPhraseSubPhraseString(p.getName(), p.getPartToReplace());
                            }
                        }
                        AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.backspaceDelete, this.mMessageEditor.getMessageId(), p, null, AniwaysStoreManager.isIconUnlocked(this.mImageSpanToRemove.getIcon()), this.mImageSpanToRemove.getIcon(), false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, this.mImageSpanToRemove.getImageSpanMetadata());
                        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Deleted Icon", removedIconPath, phraseString, 0L);
                        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Verbose, startTime, "Performance", "B4 Text Change Processing", String.valueOf(text.length()), TAG, "num chars");
                    }
                    catch (Throwable ex) {
                        Log.e(true, TAG, "Caught exception while firing icon deleted event", ex);
                    }
                }
            }
            Log.d(TAG, "B4 text changed - end");
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in beforeTextChanged", ex);
        }
    }

    public void onTextChanged(CharSequence text, int start, int before, int count) {
        String stringContent = text.toString();
        if (this.mPreviousTextReported != null && this.mPreviousTextReported.contentEquals(stringContent)) {
            this.mDuplicateChangeReported = true;
            return;
        }
        this.mDuplicateChangeReported = false;
        this.mPreviousTextReported = stringContent;
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        if (!config.contextualIconSuggestionsEnabled && config.debugPerformance) {
            return;
        }
        Log.d(TAG, "onTextChanged.  text: " + text + ". start: " + start + ". before: " + before + ". count: " + count);
        if (this.mImageSpanToRemove != null) {
            Log.d(TAG, "onTextChanged: " + (((Spannable)text).getSpanStart((Object)this.mImageSpanToRemove) >= 0 ? "true" : "false"));
        }
        if (this.mTextToRemove != null) {
            if (text.subSequence(start, start + count).toString().equalsIgnoreCase(this.mTextToRemove.toString())) {
                this.mTextToRemove = this.mTextToRemove.subSequence(0, this.mTextToRemove.length() - 1);
            } else {
                this.mTextToRemoveStart = -1;
                this.mTextToRemove = null;
            }
        }
        this.mNewTextStart = start;
        this.mNewTextEnd = start + count;
        this.mNewText = text.subSequence(start, start + count).toString();
        Log.d(TAG, "onTextChanged - End");
    }

    private void showTutorialPopupWindow() {
        Display display = ((WindowManager)this.mMessageEditor.getContext().getSystemService("window")).getDefaultDisplay();
        Rect screenRect = new Rect();
        Window window = ((Activity)this.mMessageEditor.getContext()).getWindow();
        window.getDecorView().getWindowVisibleDisplayFrame(screenRect);
        int statusBarHeight = screenRect.top;
        this.mMarkedWordRect = this.calculateMarkedWordRect();
        if (this.mMarkedWordRect == null) {
            Log.w(true, TAG, "mMarkedWordRect is null, so not showing tutorial");
            return;
        }
        this.mTutorialView.setHighlightEllipseValues(this.mMarkedWordRect);
        ImageView tapInstructionsImage = (ImageView)this.mTutorialView.findViewById(R.id.aniways_tutorial_instructions_image);
        DisplayMetrics displaymetrics = new DisplayMetrics();
        ((Activity)this.mMessageEditor.getContext()).getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
        int[] imageAndMargin = this.getTapInstructionsImageAndMargin(displaymetrics.widthPixels, displaymetrics.heightPixels - statusBarHeight, this.mMarkedWordRect);
        tapInstructionsImage.setImageResource(imageAndMargin[0]);
        RelativeLayout.LayoutParams tapInstructionsLayoutParams = (RelativeLayout.LayoutParams)tapInstructionsImage.getLayoutParams();
        tapInstructionsLayoutParams.leftMargin = imageAndMargin[1];
        tapInstructionsLayoutParams.topMargin = imageAndMargin[2];
        tapInstructionsImage.setLayoutParams((ViewGroup.LayoutParams)tapInstructionsLayoutParams);
        if (this.mTutorialWindow == null) {
            this.mTutorialWindow = new AniwaysTutorialPopupWindow((View)this.mTutorialView, display.getWidth(), display.getHeight(), true);
        } else {
            this.mTutorialWindow.setWidth(display.getWidth());
            this.mTutorialWindow.setHeight(display.getHeight());
        }
        this.mTutorialWindow.setInputMethodMode(2);
        this.mTutorialWindow.showAtLocation((View)this.mMessageEditor, 17, 0, 0);
    }

    private int[] getTapInstructionsImageAndMargin(int screenWidth, int screenHeight, Rect markedWordRect) {
        if (screenWidth / 2 >= markedWordRect.centerX()) {
            if (screenHeight / 2 >= markedWordRect.centerY()) {
                return new int[]{R.drawable.aniways_tutorial_bottom_left, markedWordRect.centerX(), markedWordRect.bottom};
            }
            BitmapDrawable bd = (BitmapDrawable)this.mMessageEditor.getContext().getResources().getDrawable(R.drawable.aniways_tutorial_top_left);
            return new int[]{R.drawable.aniways_tutorial_top_left, markedWordRect.centerX(), markedWordRect.top - bd.getBitmap().getHeight()};
        }
        if (screenHeight / 2 >= markedWordRect.centerY()) {
            BitmapDrawable bd = (BitmapDrawable)this.mMessageEditor.getContext().getResources().getDrawable(R.drawable.aniways_tutorial_bottom_right);
            return new int[]{R.drawable.aniways_tutorial_bottom_right, markedWordRect.centerX() - bd.getBitmap().getWidth(), markedWordRect.bottom};
        }
        BitmapDrawable bd = (BitmapDrawable)this.mMessageEditor.getContext().getResources().getDrawable(R.drawable.aniways_tutorial_top_right);
        return new int[]{R.drawable.aniways_tutorial_top_right, markedWordRect.centerX() - bd.getBitmap().getWidth(), markedWordRect.top - bd.getBitmap().getHeight()};
    }

    private Rect calculateMarkedWordRect() {
        Rect screenRect = new Rect();
        Window window = ((Activity)this.mMessageEditor.getContext()).getWindow();
        window.getDecorView().getWindowVisibleDisplayFrame(screenRect);
        int statusBarHeight = screenRect.top;
        int start = this.mEditable.getSpanStart((Object)this.mAniwaysSuggestionSpanForTutorial);
        int end = this.mEditable.getSpanEnd((Object)this.mAniwaysSuggestionSpanForTutorial);
        Point upperLeftCorner = this.mMessageEditor.getPointOfPositionInText(start, true);
        Point lowerRightCorner = this.mMessageEditor.getPointOfPositionInText(end, false);
        if (upperLeftCorner == null || lowerRightCorner == null) {
            return null;
        }
        int[] location = new int[2];
        this.mMessageEditor.getLocationOnScreen(location);
        Log.v(TAG, String.valueOf(location[0] + upperLeftCorner.x) + ", " + String.valueOf(location[1] + upperLeftCorner.y) + ", " + String.valueOf(location[0] + lowerRightCorner.x) + ", " + String.valueOf(location[1] + lowerRightCorner.y));
        int ellipseMargin = (int)TypedValue.applyDimension((int)1, (float)7.0f, (DisplayMetrics)this.mMessageEditor.getContext().getResources().getDisplayMetrics());
        return new Rect(location[0] + upperLeftCorner.x - ellipseMargin, location[1] + upperLeftCorner.y - statusBarHeight - ellipseMargin, location[0] + lowerRightCorner.x + ellipseMargin, location[1] + upperLeftCorner.y + ellipseMargin);
    }

    private void assertWatcherIsThis(IAniwaysTextWatcher watcher) {
        if (!this.equals(watcher)) {
            Log.e(true, TAG, "Removed or added a text watcher which is not this");
        }
    }

    private void cancelTutorial() {
        this.mTutorialWindow.dismiss();
        Phrase phrase = null;
        String phraseString = "";
        if (this.mAniwaysSuggestionSpanForTutorial != null && this.mAniwaysSuggestionSpanForTutorial.phrase != null) {
            phrase = this.mAniwaysSuggestionSpanForTutorial.phrase;
            phraseString = phrase.getPhraseSubPhraseString();
        }
        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Tutorial Canceled", "tutorial display number: " + AppData.getInt("edit_text_tutorial_showed_times") + ", phrase: " + phraseString, 0L);
        AnalyticsReporter.reportEditTextTutorialEvent(AnalyticsReporter.EditTextTutorialAction.cancelled, this.mMessageEditor.getMessageId(), phrase, AppData.getInt("edit_text_tutorial_showed_times"));
    }
}

