/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.text.Editable;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.aniways.AniwaysEditText;
import com.aniways.AniwaysIconConverter;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.IIconInfoDisplayer;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.billing.IAniwaysPaymentCallback;
import com.aniways.data.AniwaysBackendSyncChecker;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStatics;
import com.aniways.data.AppData;
import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker;
import com.aniways.ui.AniwaysUiUtil;
import com.aniways.ui.views.AniwaysPopupWindow;
import java.security.InvalidParameterException;

public class Aniways {
    private static final String TAG = "Aniways";
    private static boolean isInit = false;
    private static Context sApplicationContext;
    private static Configuration sConfiguration;
    private static Context sContext;
    public static IAniwaysPaymentCallback mPaymentCallback;

    public static synchronized void init(Context context) {
        if (Aniways.isInit()) {
            Log.i(TAG, "Not initializing Aniways because it is already initialized");
            return;
        }
        String currentProcName = "";
        try {
            int pid = Process.myPid();
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (processInfo.pid != pid) continue;
                currentProcName = processInfo.processName;
            }
        }
        catch (Throwable ex) {
            android.util.Log.e((String)TAG, (String)"Caught an Exception in closeAllOpenedPopups", (Throwable)ex);
            ex.printStackTrace();
        }
        if (currentProcName != null && currentProcName.endsWith(":AniwaysService")) {
            Log.i(TAG, "Not initializing Aniways because it is called from the Aniways Service");
            return;
        }
        android.util.Log.i((String)TAG, (String)"Initializing Aniways version 2.3.08");
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        sContext = context;
        sApplicationContext = context.getApplicationContext();
        AniwaysStatics.init(sApplicationContext, sContext, false);
        isInit = true;
    }

    public static boolean isInit() {
        return isInit;
    }

    public static boolean closeAllOpenedPopups() {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            return AniwaysPopupWindow.dismissAllOpenPopups() | AniwaysEmoticonsButtonMaker.dismissAllOpenedButtonPopups();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in closeAllOpenedPopups", ex);
            return false;
        }
    }

    public static String getOriginalString(Context context, Spannable source) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        if (source == null) {
            source = Editable.Factory.getInstance().newEditable((CharSequence)"");
        }
        try {
            return AniwaysIconConverter.getOriginalString(source, true, true);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in getOriginalString", ex);
            return source.toString();
        }
    }

    public static String removeAniwaysUnicodes(String text) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            Log.i(TAG, "removeAniwaysUnicodes called on text: " + text + ". Length: " + (TextUtils.isEmpty((CharSequence)text) ? 0 : text.length()));
            if (TextUtils.isEmpty((CharSequence)text)) {
                return "";
            }
            String result = AniwaysPrivateConfig.getInstance().decoderCodepointsPattern.matcher(text).replaceAll("");
            Log.i(TAG, "removeAniwaysUnicodes returns result: " + result + ". Length: " + (TextUtils.isEmpty((CharSequence)result) ? 0 : result.length()));
            return result;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in removeAniwaysUnicodes, returning original text", ex);
            return text;
        }
    }

    public static String encodeMessage(Spannable textWithIcons) {
        if (textWithIcons == null) {
            Log.w(false, TAG, "Trying to encode a null message. Returning null");
            return null;
        }
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            return AniwaysIconConverter.encodeMessage(textWithIcons, sApplicationContext, true, null, false);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught exception while encoding message. Returning original message", ex);
            return textWithIcons.toString();
        }
    }

    public static CharSequence getDecodedMessageWithEmojiFallbacksForIcons(CharSequence text) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        if (text == null) {
            text = "";
        }
        Editable editable = Editable.Factory.getInstance().newEditable(text);
        try {
            AniwaysIconConverter.decodeMessage(sApplicationContext, editable, null, null, null, AniwaysPhraseReplacementData.getDataParser(), null, true, false, true, false);
            return AniwaysIconConverter.getOriginalString((Spannable)editable, true, false);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in decodeMessage", ex);
            return editable;
        }
    }

    public static Editable decodeMessage(CharSequence text, IIconInfoDisplayer infoDisplayer, IAniwaysTextContainer textContainer, boolean useSmallIcons) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        if (text == null) {
            text = "";
        }
        Editable editable = Editable.Factory.getInstance().newEditable((CharSequence)text.toString());
        try {
            AniwaysIconConverter.decodeMessage(sApplicationContext, editable, null, infoDisplayer, textContainer, AniwaysPhraseReplacementData.getDataParser(), null, useSmallIcons, false, false, false);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in decodeMessage", ex);
        }
        return editable;
    }

    public static String getAniwaysStickerUrl(CharSequence text) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            return AniwaysIconConverter.getAniwaysStickerUrl(text);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in getAniwaysStickerUrl", ex);
            return null;
        }
    }

    public static boolean isMessageAniwaysSticker(CharSequence text) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            return AniwaysIconConverter.getAniwaysStickerUrl(text) != null;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in isMessageAniwaysSticker", ex);
            return false;
        }
    }

    public static boolean makeButtonAniwaysEmoticonsButton(View button, LinearLayout aniwaysEmoticonsButtonPlaceholder, ViewGroup parentLayout, AniwaysEditText editText, OnAniwaysEmoticonsKeyboardListener listener, boolean usePadding) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            return new AniwaysEmoticonsButtonMaker().makeButtonAniwaysEmoticonsButton(button, aniwaysEmoticonsButtonPlaceholder, parentLayout, editText, listener, usePadding);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in makeButtonAniwaysEmoticonsButton", ex);
            return false;
        }
    }

    public static boolean makeButtonAniwaysEmoticonsButton(View button, ViewGroup parentLayout, AniwaysEditText editText, OnAniwaysEmoticonsKeyboardListener listener, boolean usePadding) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        return Aniways.makeButtonAniwaysEmoticonsButton(button, null, parentLayout, editText, listener, usePadding);
    }

    public static void registerPaymentCallback(IAniwaysPaymentCallback callback) {
        mPaymentCallback = callback;
    }

    public static IAniwaysPaymentCallback getPaymentCallback() {
        return mPaymentCallback;
    }

    public static Configuration getConfiguration(Context ctx) {
        if (ctx == null) {
            throw new InvalidParameterException("ctx must not be null");
        }
        if (sConfiguration == null) {
            sConfiguration = new Configuration(ctx);
        }
        return sConfiguration;
    }

    public static String serializeMessage(Editable text) {
        if (text == null) {
            Log.w(false, TAG, "Trying to serialize a null message. Returning null");
            return null;
        }
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        try {
            return AniwaysIconConverter.encodeMessage((Spannable)text, sApplicationContext, false, null, true);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught exception while serializing message. Returning original message", ex);
            return text.toString();
        }
    }

    public static class Configuration {
        private static final String KEY_CONTEXTUAL_ANIMATIONS_SUGGESTIONS = "com.aniways.CONTEXTUAL_ANIMATIONS_SUGGESTIONS";
        private static final String KEY_CONTEXTUAL_MUSIC_SUGGESTIONS = "com.aniways.CONTEXTUAL_MUSIC_SUGGESTIONS";
        private static final String KEY_CONTEXTUAL_LOCATION_BASED_SUGGESTIONS = "com.aniways.CONTEXTUAL_LOCATION_BASED_SUGGESTIONS";
        private static final String KEY_CONTEXTUAL_CONTENT_SUGGESTIONS = "com.aniways.CONTEXTUAL_CONTENT_SUGGESTIONS";
        private static final String KEY_CONTEXTUAL_SUGGESTIONS = "com.aniways.CONTEXTUAL_SUGGESTIONS";
        private Context mContext;
        private boolean mPerformUpdate = true;
        private boolean mValueUpdated = false;

        public Configuration(Context ctx) {
            this.mContext = ctx.getApplicationContext();
            AniwaysStatics.init(this.mContext, ctx, true);
        }

        public void enableContextualIconSuggestions(boolean enable) {
            Log.i(Aniways.TAG, "enableContextualIconSuggestions called with param: " + enable);
            try {
                this.setConfigProperty("com.aniways.CONTEXTUAL_ICON_SUGGESTIONS", enable, null);
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in enableContextualIconSuggestions. Value: " + enable, tr);
            }
        }

        public void enableContextualAnimationsSuggestions(boolean enable) {
            Log.i(Aniways.TAG, "enableContextualAnimationsSuggestions called with param: " + enable);
            this.setConfigProperty(KEY_CONTEXTUAL_ANIMATIONS_SUGGESTIONS, enable, null);
        }

        public void enableContextualMusicSuggestions(boolean enable) {
            Log.i(Aniways.TAG, "enableContextualMusicSuggestions called with param: " + enable);
            this.setConfigProperty(KEY_CONTEXTUAL_MUSIC_SUGGESTIONS, enable, null);
        }

        public void enableContextualLocationBasedSuggestions(boolean enable) {
            Log.i(Aniways.TAG, "enableContextualLocationBasedSuggestions called with param: " + enable);
            this.setConfigProperty(KEY_CONTEXTUAL_LOCATION_BASED_SUGGESTIONS, enable, null);
        }

        public void enableContextualContentSuggestions(final boolean enable) {
            Log.i(Aniways.TAG, "enableContextualContentSuggestions called with param: " + enable);
            this.setConfigProperty(KEY_CONTEXTUAL_CONTENT_SUGGESTIONS, enable, new Runnable(){

                @Override
                public void run() {
                    Configuration.this.enableContextualIconSuggestions(enable);
                    Configuration.this.enableContextualAnimationsSuggestions(enable);
                    Configuration.this.enableContextualMusicSuggestions(enable);
                }
            });
        }

        public void enableContextualSuggestions(final boolean enable) {
            Log.i(Aniways.TAG, "enableContextualSuggestions called with param: " + enable);
            this.setConfigProperty(KEY_CONTEXTUAL_SUGGESTIONS, enable, new Runnable(){

                @Override
                public void run() {
                    Configuration.this.enableContextualContentSuggestions(enable);
                    Configuration.this.enableContextualLocationBasedSuggestions(enable);
                }
            });
        }

        public void setIconsInTextViewSize(int iconSizeInDp) {
            Log.i(Aniways.TAG, "setIconsInTextViewSize called with param: " + iconSizeInDp);
            this.setConfigProperty("com.aniways.KEY_ICON_IN_TEXT_VIEW_SIZE", iconSizeInDp, null);
        }

        public void enableAutoPopup(boolean enable) {
            Log.i(Aniways.TAG, "enableAutoPopup called with param: " + enable);
            this.setConfigProperty("com.aniways.KEY_AUTOMATIC_POPUP", enable, null);
        }

        public boolean isContextualIconSuggestionsEnabled() {
            try {
                boolean result = AniwaysPrivateConfig.getInstance().contextualIconSuggestionsEnabled;
                Log.i(Aniways.TAG, "isContextualIconSuggestionsEnabled called. Returning:  " + result);
                return result;
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in isContextualIconSuggestionsEnabled", tr);
                return true;
            }
        }

        public boolean isContextualAnimationSuggestionsEnabled() {
            try {
                boolean result = AniwaysPrivateConfig.getInstance().contextualAnimationsSuggestionsEnabled;
                Log.i(Aniways.TAG, "isContextualAnimationSuggestionsEnabled called. Returning:  " + result);
                return result;
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in isContextualAnimationSuggestionsEnabled", tr);
                return true;
            }
        }

        public boolean isContextualMusicSuggestionsEnabled() {
            try {
                boolean result = AniwaysPrivateConfig.getInstance().contextualMusicSuggestionsEnabled;
                Log.i(Aniways.TAG, "isContextualMusicSuggestionsEnabled called. Returning:  " + result);
                return result;
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in isContextualMusicSuggestionsEnabled", tr);
                return true;
            }
        }

        public boolean isContextualLocationBasedSuggestionsEnabled() {
            try {
                boolean result = AniwaysPrivateConfig.getInstance().contextualLocationBasedSuggestionsEnabled;
                Log.i(Aniways.TAG, "isContextualLocationBasedSuggestionsEnabled called. Returning:  " + result);
                return result;
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in isContextualLocationBasedSuggestionsEnabled", tr);
                return true;
            }
        }

        public boolean isContextualContentSuggestionsEnabled() {
            try {
                boolean result = AniwaysPrivateConfig.getInstance().contextualContentSuggestionsEnabled;
                Log.i(Aniways.TAG, "isContextualContentSuggestionsEnabled called. Returning:  " + result);
                return result;
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in isContextualContentSuggestionsEnabled", tr);
                return true;
            }
        }

        public boolean isContextualSuggestionsEnabled() {
            try {
                boolean result = AniwaysPrivateConfig.getInstance().contextualSuggestionsEnabled;
                Log.i(Aniways.TAG, "isContextualSuggestionsEnabled called. Returning:  " + result);
                return result;
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in isContextualSuggestionsEnabled", tr);
                return true;
            }
        }

        public float getIconsInTextViewSize() {
            try {
                float result = AniwaysPrivateConfig.getInstance().iconInTextViewWidth;
                result = AniwaysUiUtil.convertPixelsToDips(result);
                Log.i(Aniways.TAG, "getIconsInTextViewSize called. Returning:  " + result);
                return result;
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in getIconsInTextViewSize", tr);
                return 0.0f;
            }
        }

        public boolean isAutoPopupEnabled() {
            try {
                AniwaysPrivateConfig.SuggestionMode mode = AniwaysPrivateConfig.getInstance().suggestionMode;
                boolean result = mode == AniwaysPrivateConfig.SuggestionMode.AutoDisplaySuggestions;
                Log.i(Aniways.TAG, "isAutoPopupEnabled called. Returning:  " + result);
                return result;
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in isContextualContentSuggestionsEnabled", tr);
                return true;
            }
        }

        private void updatePrivateConfig() {
            Log.i(Aniways.TAG, "Updating private config");
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post((Runnable)new NonThrowingRunnable(Aniways.TAG, "Aniways config parsing", ""){

                @Override
                @SuppressLint(value={"NewApi"})
                public void innerRun() {
                    AniwaysBackendSyncChecker.parseConfingAndKeywordsIfNecessary(sContext, true, true);
                }
            });
        }

        private synchronized void setConfigProperty(String key, boolean value, Runnable postSet) {
            try {
                Log.i(Aniways.TAG, "Setting config property with key: " + key + ". To: " + value + ". Runnable: " + postSet + ". Should update: " + this.mPerformUpdate);
                boolean shouldUpdate = this.mPerformUpdate;
                this.mPerformUpdate = false;
                Boolean oldValue = this.getConfigProperty(key);
                Log.i(Aniways.TAG, "Old value is: " + oldValue);
                if (oldValue == null || value != oldValue) {
                    Log.i(Aniways.TAG, "Old value != new value");
                    SharedPreferences prefs = this.mContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
                    SharedPreferences.Editor edit = prefs.edit();
                    edit.putBoolean(key, value);
                    edit.commit();
                    this.mValueUpdated = true;
                    AnalyticsReporter.reportUserConfigChanged(key, oldValue, value);
                    if (postSet != null) {
                        Log.i(Aniways.TAG, "Calling post set");
                        postSet.run();
                    }
                }
                Log.i(Aniways.TAG, "Should update: " + shouldUpdate + ". Value updated: " + this.mValueUpdated);
                if (shouldUpdate) {
                    this.mPerformUpdate = true;
                    if (this.mValueUpdated) {
                        this.mValueUpdated = false;
                        this.updatePrivateConfig();
                    }
                }
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in setConfigProperty. Key: " + key + ". Value: " + value, tr);
                this.mPerformUpdate = true;
            }
        }

        private synchronized void setConfigProperty(String key, int value, Runnable postSet) {
            try {
                Log.i(Aniways.TAG, "Setting config property with key: " + key + ". To: " + value + ". Runnable: " + postSet + ". Should update: " + this.mPerformUpdate);
                boolean shouldUpdate = this.mPerformUpdate;
                this.mPerformUpdate = false;
                Integer oldValue = this.getIntConfigProperty(key);
                Log.i(Aniways.TAG, "Old value is: " + oldValue);
                if (oldValue == null || value != oldValue) {
                    Log.i(Aniways.TAG, "Old value != new value");
                    SharedPreferences prefs = this.mContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
                    SharedPreferences.Editor edit = prefs.edit();
                    edit.putInt(key, value);
                    edit.commit();
                    this.mValueUpdated = true;
                    AnalyticsReporter.reportUserConfigChanged(key, oldValue, value);
                    if (postSet != null) {
                        Log.i(Aniways.TAG, "Calling post set");
                        postSet.run();
                    }
                }
                Log.i(Aniways.TAG, "Should update: " + shouldUpdate + ". Value updated: " + this.mValueUpdated);
                if (shouldUpdate) {
                    this.mPerformUpdate = true;
                    if (this.mValueUpdated) {
                        this.mValueUpdated = false;
                        this.updatePrivateConfig();
                    }
                }
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception in setConfigProperty. Key: " + key + ". Value: " + value, tr);
                this.mPerformUpdate = true;
            }
        }

        private synchronized Boolean getConfigProperty(String key) {
            SharedPreferences prefs = this.mContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
            if (!prefs.contains(key)) {
                return null;
            }
            return prefs.getBoolean(key, true);
        }

        private synchronized Integer getIntConfigProperty(String key) {
            SharedPreferences prefs = this.mContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
            if (!prefs.contains(key)) {
                return null;
            }
            int result = prefs.getInt(key, -1);
            if (result == -1) {
                return null;
            }
            return result;
        }

        private static synchronized boolean getConfigProperty(Context ctx, String key, boolean defaultValue) {
            return AppData.getBoolean(key, defaultValue);
        }

        public static void setPrivateConfigProperties(Context ctx, AniwaysPrivateConfig config) {
            try {
                boolean isAutoPopupEnabled = Configuration.getConfigProperty(ctx, "com.aniways.KEY_AUTOMATIC_POPUP", config.suggestionMode == AniwaysPrivateConfig.SuggestionMode.AutoDisplaySuggestions);
                config.suggestionMode = isAutoPopupEnabled ? AniwaysPrivateConfig.SuggestionMode.AutoDisplaySuggestions : AniwaysPrivateConfig.SuggestionMode.Manual;
                config.contextualIconSuggestionsEnabled = Configuration.getConfigProperty(ctx, "com.aniways.CONTEXTUAL_ICON_SUGGESTIONS", config.contextualIconSuggestionsEnabled);
                config.contextualAnimationsSuggestionsEnabled = Configuration.getConfigProperty(ctx, KEY_CONTEXTUAL_ANIMATIONS_SUGGESTIONS, config.contextualAnimationsSuggestionsEnabled);
                config.contextualMusicSuggestionsEnabled = Configuration.getConfigProperty(ctx, KEY_CONTEXTUAL_MUSIC_SUGGESTIONS, config.contextualMusicSuggestionsEnabled);
                config.contextualLocationBasedSuggestionsEnabled = Configuration.getConfigProperty(ctx, KEY_CONTEXTUAL_LOCATION_BASED_SUGGESTIONS, config.contextualLocationBasedSuggestionsEnabled);
                config.contextualContentSuggestionsEnabled = Configuration.getConfigProperty(ctx, KEY_CONTEXTUAL_CONTENT_SUGGESTIONS, config.contextualContentSuggestionsEnabled);
                config.contextualSuggestionsEnabled = Configuration.getConfigProperty(ctx, KEY_CONTEXTUAL_SUGGESTIONS, config.contextualSuggestionsEnabled);
                config.iconInTextViewHeight = AppData.getInt("com.aniways.KEY_ICON_IN_TEXT_VIEW_SIZE", config.iconInTextViewHeight);
                config.iconInTextViewWidth = AppData.getInt("com.aniways.KEY_ICON_IN_TEXT_VIEW_SIZE", config.iconInTextViewWidth);
            }
            catch (Throwable tr) {
                Log.e(true, Aniways.TAG, "Caught exception while parsing user config", tr);
            }
        }

        public static void suspendNetworkUse() {
        }

        public static void resumeNetworkUse() {
        }

        public static boolean shouldDisplayDecodedMessageAsSticker(Spannable message) {
            if (message == null) {
                Log.e(true, Aniways.TAG, "Message is null");
                return false;
            }
            IAniwaysImageSpan[] spans = (IAniwaysImageSpan[])message.getSpans(0, message.length(), IAniwaysImageSpan.class);
            if (spans == null) {
                return false;
            }
            if (spans.length != 1) {
                return false;
            }
            IAniwaysImageSpan span = spans[0];
            if (message.getSpanStart((Object)span) != 0) {
                return false;
            }
            return message.getSpanEnd((Object)span) == message.length();
        }
    }

    public static interface OnAniwaysEmoticonsKeyboardListener {
        public void onShow();

        public void onHide();
    }
}

