package com.aniways.service;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;

/**
 * Interface to schedule and execute an IntentService.
 */
public interface AlarmListener {
	
	/**
	 * Schedule alarms and an operation to perform when the alarm goes off (i.e. updates)
	 * @param alarmManager AlarmManager that will be used to schedule the updates.
	 * @param pendingIntent pending intent operation to perform when the alarm goes off.
	 * @param context Application context.
	 */
	void scheduleAlarms(AlarmManager alarmManager, PendingIntent pendingIntent, long interval, long timeOfFirstalarmFromNow, Context context, String alarmName);

	/**
	 * Starts the service and make it execute the actual work.
	 * @param context Application context
	 */
	void sendWakefulWork(Context context, boolean fromAlarm);

}