package com.aniways.quick.action;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.aniways.AssetType;
import com.aniways.data.PhraseAssetInfoExtractor;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Phrase;

public class AniwaysContextualAnimatedGifGridView extends AniwaysContextualPopupGridView {

    private static PhraseAssetInfoExtractor animatedGifAssetInfoExtractor;

    public AniwaysContextualAnimatedGifGridView(Context context) {
        super(context);
    }

    public AniwaysContextualAnimatedGifGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AniwaysContextualAnimatedGifGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initializeGridDimensions(){
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();

        //Assuming the grid item is square
        setGridItemDimension(config.contextualGridRowHeight, config.contextualGridAnimatedItemMinMargin, config.animatedGifInSuggestionPopupHeight, config.animatedGifInSuggestionPopupHeight);
    }

    @Override
    protected int getMaxGridItemsNumber(Phrase phrase) {
        return AniwaysPrivateConfig.getInstance().animatedGifsRequestSize;
    }

    @Override
    protected ImageView.ScaleType getImageScaleType() {
        return ImageView.ScaleType.CENTER_CROP;
    }

    @Override
    protected PhraseAssetInfoExtractor getAssetInfoExtractor() {

        if (animatedGifAssetInfoExtractor == null)
        {
            animatedGifAssetInfoExtractor = new PhraseAssetInfoExtractor(AssetType.AnimatedGif);
        }

        return animatedGifAssetInfoExtractor;
    }
}
