package com.aniways.quick.action;

import com.aniways.IconData;

import android.graphics.Bitmap;

/**
 * Action item, displayed as menu with icon and text.
 * 
 * @author Lorensius. W. L. T <lorenz@londatiga.net>
 * 
 * Contributors:
 * - Kevin Peck <kevinwpeck@gmail.com>
 *
 */
public class ActionItem {
	private Bitmap thumb;
	private String title;
	private int actionId = -1;
    private boolean selected;
    private boolean sticky;
    private Object tag;
    private IconData iconData;
	
    /**
     * Constructor
     * 
     * @param actionId  Action id for case statements
     * @param title     Title
     * @param icon      Icon to use
     */
    public ActionItem(int actionId, String title, Object tag, IconData iconData) {
        this.title = title;
        this.iconData = iconData;
        this.actionId = actionId;
        this.tag = tag;
    }
    
//    /**
//     * Constructor
//     */
//    private ActionItem() {
//        this(-1, null, null, null, false, null);
//    }
//    
//    /**
//     * Constructor
//     * 
//     * @param actionId  Action id of the item
//     * @param title     Text to show for the item
//     */
//    private ActionItem(int actionId, String title) {
//        this(actionId, title, null, null, false, null);
//    }
//    
//    /**
//     * Constructor
//     * 
//     * @param icon {@link Drawable} action icon
//     */
//    private ActionItem(Drawable icon) {
//        this(-1, null, icon, null, false, null);
//    }
//    
//    /**
//     * Constructor
//     * 
//     * @param actionId  Action ID of item
//     * @param icon      {@link Drawable} action icon
//     */
//    private ActionItem(int actionId, Drawable icon) {
//        this(actionId, null, icon, null, false, null);
//    }
	
	/**
	 * Set action title
	 * 
	 * @param title action title
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	
	/**
	 * Get action title
	 * 
	 * @return action title
	 */
	public String getTitle() {
		return this.title;
	}
	
	public void setTag(Object tag) {
		this.tag = tag;
	}
	
	public Object getTag() {
		return this.tag;
	}
	
	 /**
     * Set action id
     * 
     * @param actionId  Action id for this action
     */
    public void setActionId(int actionId) {
        this.actionId = actionId;
    }
    
    /**
     * @return  Our action id
     */
    public int getActionId() {
        return actionId;
    }
    
    /**
     * @return  the id of the icon that is displayed
     */
    public IconData getIconData() {
        return this.iconData;
    }
    
    /**
     * Set sticky status of button
     * 
     * @param sticky  true for sticky, pop up sends event but does not disappear
     */
    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }
    
    /**
     * @return  true if button is sticky, menu stays visible after press
     */
    public boolean isSticky() {
        return sticky;
    }
    
	/**
	 * Set selected flag;
	 * 
	 * @param selected Flag to indicate the item is selected
	 */
	public void setSelected(boolean selected) {
		this.selected = selected;
	}
	
	/**
	 * Check if item is selected
	 * 
	 * @return true or false
	 */
	public boolean isSelected() {
		return this.selected;
	}

	/**
	 * Set thumb
	 * 
	 * @param thumb Thumb image
	 */
	public void setThumb(Bitmap thumb) {
		this.thumb = thumb;
	}
	
	/**
	 * Get thumb image
	 * 
	 * @return Thumb image
	 */
	public Bitmap getThumb() {
		return this.thumb;
	}
}