package com.aniways.emoticons.button;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.data.JsonParser;
import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker.LastPagesLocation;
import com.aniways.viewpagerindicator.CirclePageIndicator;
import com.aniways.viewpagerindicator.IconPagerAdapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.support.v4.view.AniwaysDirectionalViewPager.OnPageChangeListener;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;


public class EmoticonCategoriesPagerAdapter extends EmoticonsOnDemandPagerAdapterBase implements IconPagerAdapter {
	final static String RECENT = "Recent";

	private String TAG = "AniwaysEmoticonCategoriesPagerAdapter";

	private String[] mSuperCategoriesInOrder;
	private AniwaysLockedIconHelper mLockedIconHelper;
	private LastPagesLocation mLastPagesLocation;
	private static Drawable[] ICONS_FOR_TABS = null;
	private List<IconData> mIconsForGenious = null;
	private AssetType mAssetType;

	public EmoticonCategoriesPagerAdapter(AniwaysLockedIconHelper lockedIconHelper, LastPagesLocation lastPagesLocation, AssetType assetType, Context context, List<IconData> iconsForGenious, EmoticonsOnDemandPagerAdapterBase parent) {
		super("AniwaysEmoticonCategoriesPagerAdapter" + "-" + assetType.getAssetCode(), AdapterType.Category, assetType.getAssetCode(), 0, 0, parent, assetType.getAssetCode());
		
		try{
            TAG += "-" + assetType.getAssetCode();
			this.mAssetType = assetType;
			this.mLockedIconHelper = lockedIconHelper;
			this.mLastPagesLocation = lastPagesLocation;
			this.mIconsForGenious = iconsForGenious == null ? new ArrayList<IconData>() : iconsForGenious;
			this.mSuperCategoriesInOrder = mLockedIconHelper.getDataParser().getIconCategoriesInOrderByAssetType(mAssetType);
			if (mSuperCategoriesInOrder == null || mSuperCategoriesInOrder.length == 0){
				Log.e(true, TAG, "No Icon categories in parser for asset type '" + assetType.toString() + "'");
			}
			else{
				calculateIconsForTabs(lockedIconHelper, context);
			}
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in constructor", ex);
		}

	}

	@Override
	public int getCount() {
		if(mSuperCategoriesInOrder == null){
			return 0;
		}
		return mSuperCategoriesInOrder.length;
	}

	public String getCategoryName(int position){
		try{
			return mSuperCategoriesInOrder[position];
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in getCategoryName", ex);
			return "EMPTY";
		}
	}

	@Override 
	public Drawable getIconDrawable(int index) {
		if(index < 0){
			Log.e(true, TAG, "index < 0 - " + index);
			index = 0;
		}
		if(ICONS_FOR_TABS == null){
			Log.e(true, TAG, "ICONS_FOR_TABS is null. index is: " + index);
			return null;
		}
		//TODO: temps
		if(index >= ICONS_FOR_TABS.length){
			Log.e(true, TAG, "index >= ICONS_FOR_TABS.length. Index:" + index + " . Length: " + ICONS_FOR_TABS.length);
			index = 0;
		}
		return ICONS_FOR_TABS[index];
	}

	/*
	 * This is used by the getItemPosition to return None in order to re-create the 'recents' tab upon data set change
	 * (non-Javadoc)
	 * @see android.support.v4.view.PagerAdapter#getItemPosition(java.lang.Object)
	 */
	@Override
	public int getItemPosition(Object object) {
		try{
			InstantiatedViewHolder holder = (InstantiatedViewHolder) object; 
			String category = this.getCategoryName(holder.position);

			boolean isRecentsCategory = category.equalsIgnoreCase(RECENT);

			if (isRecentsCategory) {
				return POSITION_NONE;
			}

			return super.getItemPosition(holder);
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in getItemPosition", ex);
			return POSITION_NONE;
		}
	}

	@Override
	protected View instantiateItem(View collection) {
		try{
			LayoutInflater inflater = (LayoutInflater) collection.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			return inflater.inflate(R.layout.aniways_emoticons_button_popup_icon_families_pager, null);
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in instantiateItem", ex);
			return null;
		}
	}
	
	@Override
	protected void onHolderCreated(InstantiatedViewHolder holder){
		// Intentionally empty, in order not to create other tabs since it degrades performance
	}

	@SuppressLint("NewApi") @Override
	protected void instantiateItemInternal(InstantiatedViewHolder holder) {
		
		View layout = holder.view;
		
		final String category = this.getCategoryName(holder.position);
	
		AniwaysDirectionalViewPager pager = (AniwaysDirectionalViewPager) layout.findViewById(R.id.aniways_ebp_icon_families_pager);
		pager.setOffscreenPageLimit(1); //TODO: 1 is the minimum. 1. Make this value configurable. See if can somehow change this minimum
		holder.pager = pager;
		
		boolean isRecentsCategory = category.equalsIgnoreCase(RECENT);
		HashMap<String, List<IconData>> recentIcons = new HashMap<>();
		if(isRecentsCategory && (!AniwaysRecentIconsManager.isEmpty(mAssetType) || mIconsForGenious.size() > 0)){
			// Use the hashset in order not to have the same icon twice (from the recents and the genious).
			List<IconData> geniousAndRecentIcons = new ArrayList<>();
			geniousAndRecentIcons.addAll(mIconsForGenious);
			String[] recentIconIds = AniwaysRecentIconsManager.getRecentIcons(mAssetType);
			JsonParser parser = this.mLockedIconHelper.getDataParser();
			for (String id : recentIconIds){
				IconData icon = parser.getIconById(Integer.parseInt(id));
				if(icon == null){
					Log.w(false, TAG, "No icon for id even though it is in the recents list: " + id);
				}
				else{
					geniousAndRecentIcons.add(icon);
				}
			}

			List<IconData> filteredIcons = new ArrayList<>();

			for (IconData icon : geniousAndRecentIcons){
				if (icon.assetType == mAssetType){
					filteredIcons.add(icon);
				}
			}

			geniousAndRecentIcons = filteredIcons;

            int maxItems = EmoticonsPagerAdapterWithTable.getMaxItemsPerPage(mAssetCode);
            if (geniousAndRecentIcons.size() > maxItems) {
                geniousAndRecentIcons = geniousAndRecentIcons.subList(0, maxItems);
            }

			recentIcons.put("default", geniousAndRecentIcons);
		}

		HashMap<String, List<IconData>> categoryFamiliesAndIcons = isRecentsCategory ? recentIcons : mLockedIconHelper.getDataParser().getFamiliesToIconsByAssetTypeAndCategory(mAssetType, category);

		// If this is the 'recent' category then we put all the icons in one big happy family :)
		final EmoticonFamiliesPagerAdapter adapter = new EmoticonFamiliesPagerAdapter(
				categoryFamiliesAndIcons,
				mAssetCode,
				category,
				holder.position,
				mLockedIconHelper,
				isRecentsCategory,
				mIconsForGenious.size(),
				mLastPagesLocation,
				this);
		pager.setAdapter(adapter);
		pager.setOrientation(AniwaysDirectionalViewPager.HORIZONTAL);
	
		CirclePageIndicator indicator = (CirclePageIndicator)layout.findViewById(R.id.aniways_ebp_icon_families_pager_indicator);
		indicator.setViewPager(pager);

		indicator.setOrientation(LinearLayout.HORIZONTAL);

		// Hide the families indicator when there's only one family.

		// Hide the families indicator when there's only one family.
		if (categoryFamiliesAndIcons.size() == 1){

			String family = (String)categoryFamiliesAndIcons.keySet().toArray()[0];

			if (categoryFamiliesAndIcons.get(family).size() > EmoticonsPagerAdapterWithTable.getMaxItemsPerPage(mAssetCode) &&
                mAssetType == AssetType.Emoji) {
                indicator.setVisibility(View.GONE);
			}
			else {
                indicator.setVisibility(View.INVISIBLE);
            }
		}

		indicator.setOnPageChangeListener(new OnPageChangeListener(){
	
			@Override
			public void onPageScrollStateChanged(int arg0) {
				// TODO Auto-generated method stub
			}
	
			@Override
			public void onPageScrolled(int arg0, float arg1, int arg2) {
				// TODO Auto-generated method stub
			}
	
			@Override
			public void onPageSelected(int familyPage) {
				try{
					mLastPagesLocation.setFamilyPage(familyPage);
                    Log.i(TAG, "Selected family num: " + familyPage);
				}
				catch(Throwable ex){
					Log.e(true, TAG, "Caught Exception in onPageSelected", ex);
				}
			}
	
		});

		if(mLastPagesLocation.getSelectedAssetType().getAssetCode() == mAssetCode && mLastPagesLocation.getCategoryPage() == holder.position){
			indicator.setCurrentItem(mLastPagesLocation.getFamilyPage());
		}
		
		holder.instantiated = true;
	}

	private void calculateIconsForTabs(AniwaysLockedIconHelper lockedIconHelper, Context context) {
		//TODO: get drawables either from resources OR from server
		//TODO: do not calculate all the drawables here in advance, but on demand in a method in the adapter
		Drawable[] tabDrawables = new Drawable[mSuperCategoriesInOrder.length];
		int counter = 0;
		for (String category : mSuperCategoriesInOrder){
			String iconName = lockedIconHelper.getDataParser().getSuperCategoryTabIconName(category);
			if(iconName == null){
				Log.e(true, TAG, "No icon name defined for category: " + category + " Keywords version: " + lockedIconHelper.getDataParser().getKeywordsVersion());
				// TODO: find another default
				tabDrawables[counter] = context.getResources().getDrawable(R.drawable.aniways_ebp_food_and_drinks_button);
			}
			else{
				String packageName = context.getPackageName();
				if(packageName == null){
					Log.e(true, TAG, "package Name is null");
					// TODO: find another default
					tabDrawables[counter] = context.getResources().getDrawable(R.drawable.aniways_ebp_food_and_drinks_button);
				}
				else{
					int iconId = context.getResources().getIdentifier(iconName, "drawable", packageName);
					if(iconId == 0){
						Log.e(true, TAG, "Could not find resource with name: " + iconName + " for tab icon of category: " + category);
						// TODO: find another default
						tabDrawables[counter] = context.getResources().getDrawable(R.drawable.aniways_ebp_food_and_drinks_button);
					}
					else{
						tabDrawables[counter] = context.getResources().getDrawable(iconId);
					}
				}
			}
			counter++;
		}
		ICONS_FOR_TABS = tabDrawables;
	}
}