package com.aniways.emoticons.button;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.support.v4.view.AniwaysDirectionalViewPager.OnPageChangeListener;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.view.inputmethod.InputMethodManager;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.PopupWindow.OnDismissListener;
import android.widget.Toast;

import com.aniways.Aniways;
import com.aniways.Aniways.OnAniwaysEmoticonsKeyboardListener;
import com.aniways.AniwaysEditText;
import com.aniways.AssetType;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.AniwaysEditText.RecognizedPhrase;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.AnalyticsReporter.PhrasesEventAction;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysBackendSyncChecker;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.data.AniwaysLockedIconHelper.OnStoreAboutToLaunchListener;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.data.AniwaysConfiguration.Verbosity;
import com.aniways.data.AniwaysLockedIconHelper.OnItemContainingLockedIconClickListener;
import com.aniways.viewpagerindicator.PageIndicator;

public class AniwaysEmoticonsButtonMaker implements OnStoreAboutToLaunchListener {
	private static final String TAG = "AniwaysEmoticonsButtonMaker";

	// All opened popups - used to close properly on exit
	private static HashSet<PopupWindow> sOpenedPopups;

	// The emoticons button
	private View mButton;
	// The data parser
	private JsonParser mParser;
	// Records the last location the user navigated to in the last time the button was opened, to be able to return there..
	private LastPagesLocation mLastPagesLocation;
	// The view that's inside the popup
	private View popUpView;
	// A layout that takes space on the screen like a keyboard, in case the keyboard is not showing, in order to push the layout up..
	private LinearLayout emoticonsPlaceholder;
	// The popup containing the emoticons view
	private PopupWindow popupWindow;
    // The height of the keyboard
	private int keyboardHeightPortrait;
    private int keyboardHeightLandscape;
	// The Edit text which is being edited
	private AniwaysEditText mEditText;

	private EmoticonAssetsPagerAdapter mPagerAdapter;

	// Used for keyboard size cals
	private boolean isKeyBoardVisible;
	private int previousHeightDiffrence = 0;

    private int mNumberOfEmoticonsPicked = 0;

	private Context mContext;

	// To make sure that click on button that closed the popup will also re-open it
	private long mTimeOfLastEventThatClosedThePopup = -3;
	private long mTimeOfLastDownEventOnEmoticonsButton = -4;
	protected long mStartUserInPopupTime;
	private ViewGroup mParentLayout;
	private OnAniwaysEmoticonsKeyboardListener mStateChangeListener;

    // If the placeholder is null then, if this var is true then add padding to the parent layout, if false then show the keyboard
    private boolean mUsePadding;

    // Defines the estimated height, in pixels, for identifying an open keyboard.
    int estimatedKeyboardHeight;
    // The delta between the actual keyboard size to the minimum we need to display the icons OK
    private int deltaFromOpenedKeyboardPortrait;
    private int deltaFromOpenedKeyboardLandscape;
    private int previousOrientation;


    @SuppressLint("InflateParams")
    public boolean makeButtonAniwaysEmoticonsButton(View button, LinearLayout aniwaysEmoticonsButtonPlaceholder, final ViewGroup parentLayout, AniwaysEditText editText, OnAniwaysEmoticonsKeyboardListener listener, boolean usePadding){
		try{
			Log.i(TAG, "Making Aniways Emoticons Button");

			// There is no button yet, so nothing to setup
			if(button == null){
				Log.w(false, TAG, "There is no button yet in the parent layout, so not setting up anything");
				return false;
			}

			if(editText == null){
				Log.w(false, TAG, "There is no AniwaysEditText yet to attach to the emoticons on demand button, so icons that are picked will not go anywere..");
			}

			// Set up fields
			mEditText = editText;
			mParentLayout = parentLayout;
			mContext = mParentLayout.getContext();
			mButton = button;
			mStateChangeListener = listener;
            this.mUsePadding = usePadding;

			emoticonsPlaceholder = aniwaysEmoticonsButtonPlaceholder;
			popUpView = ((LayoutInflater)mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE)).inflate(R.layout.aniways_emoticons_button_popup, null);

            DisplayMetrics metrics = mContext.getResources().getDisplayMetrics();
            estimatedKeyboardHeight = (int)TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 100, metrics);

            // Setup click on the button
			setupEmoticonsButton(button, mParentLayout);

			// Defining default height in both orientations
			// Must be defined after the placeholder, since call to changeKeyboardHeight uses it
			changeKeyboardHeight(Configuration.ORIENTATION_LANDSCAPE, (int) mContext.getResources().getDimension(R.dimen.aniways_keyboard_height_landscape));
            changeKeyboardHeight(Configuration.ORIENTATION_PORTRAIT, (int) mContext.getResources().getDimension(R.dimen.aniways_keyboard_height_portrait));

			// Setup updating of keyboard height if it changes
			setupKeyboardHeightUpdater(mParentLayout);

			return aniwaysEmoticonsButtonPlaceholder != null && editText != null;
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caought Exception which making an Aniways Emoticons Button", ex);
			return false;
		}
	}

	private void setupEmoticonsButton(View button, final ViewGroup parentLayout) {

		setButtonImage(EmoticonsButtonImageType.Smiley);

		button.setOnTouchListener(new OnTouchListener(){

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				try{
					if(event.getAction() == MotionEvent.ACTION_DOWN){
						Log.i(TAG, "Time of last event on emoticons button: " + mTimeOfLastDownEventOnEmoticonsButton);
						mTimeOfLastDownEventOnEmoticonsButton = event.getEventTime();
					}
				}
				catch(Throwable ex){
					Log.e(true, TAG, "Caught Exception in onTouch of Emoticons button", ex);
				}
				return false;
			}

		});

		button.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				// TODO: deal with click before the mapping is ready
				// TODO: how to make sure the app doesn;t set onClick after this
				try{

					// Check if need to sync with the server
					AniwaysBackendSyncChecker.requestSyncWithServerIfNecessary();

					// TODO: If the button is clicked then the popup cannot be showing as the popup is dismissed on any touch outside. Make the code below reflect that

					// Dismiss the popup if it is showing
					if(popupWindow != null && popupWindow.isShowing()){
						// This will also change the button image
						popupWindow.dismiss();
					}

					// Show the popup if it is not showing, and this click was not the click that closed the popup
					else {
						Log.i(TAG, "(Time of event that closed popup" + mTimeOfLastEventThatClosedThePopup + ". Time of last event on emoticons button: " + mTimeOfLastDownEventOnEmoticonsButton); 
						if(mTimeOfLastEventThatClosedThePopup == mTimeOfLastDownEventOnEmoticonsButton){
							Log.i(TAG, "detected click on emoticons button that was the click that closed the popup, so not opening the popup again");
							return;
						}

                        previousOrientation = mContext.getResources().getConfiguration().orientation;

						mParser = AniwaysPhraseReplacementData.getDataParser();
						if (mLastPagesLocation == null || !mLastPagesLocation.isInstanceRelevantForParser(mParser)) {
							mLastPagesLocation = new LastPagesLocation(mParser);
						}

						// Do not show the contents of the button if the keywords version is < 2.6
						if(Utils.compareVersionStrings(mParser.getKeywordsVersion(), "2.6").result < 0){		
							Log.i(TAG, "Not showing Emoticons button content because the keywords version is not 2.6 or above. Version is: " + mParser.getKeywordsVersion());
							// TODO: Make the behavior of not showing button contents because keywords version is too low configurable - configure the toast text, or receive a callback from the user
							Toast.makeText(mContext, "The button will be available in a few seconds", Toast.LENGTH_LONG).show();
							return;
						}

						long startTime = System.currentTimeMillis();

						// Get icons that are related to what is written in the text (for the genious mode)
						List<IconData> iconsForGenious = getIconsForGeniousMode();
						
						//if(emoticonsPlaceholder == null){
						//	showSoftKeyboard();
						//}
						
						// Setup the popup view
						setupPopUpView(iconsForGenious);

						// Reset number of emoticons picked in this showing and start to count time of user in popup
						mNumberOfEmoticonsPicked = 0;
						mStartUserInPopupTime = System.currentTimeMillis();

						// Show the popup window
						if (sOpenedPopups == null){
							sOpenedPopups = new HashSet<>();
						}
						sOpenedPopups.add(popupWindow);

                        popupWindow.showAtLocation(parentLayout, Gravity.BOTTOM, 0, 0);
						if(mStateChangeListener != null){
							mStateChangeListener.onShow();
						}
						AnalyticsReporter.ReportTiming(Verbosity.Verbose, startTime, "Performance", "Display Emoticons Button", "", TAG, "");
					}
				}
				catch(Throwable ex){
					Log.e(true, TAG, "Caught Exception in onClick of Emoticons button", ex);
				}
			}
		});
	}

	/**
	 * Checking keyboard height and keyboard visibility
	 */
	private void setupKeyboardHeightUpdater(final View parentLayout) {

        final Rect r = new Rect();

        parentLayout.getViewTreeObserver().addOnGlobalLayoutListener(
				new ViewTreeObserver.OnGlobalLayoutListener() {

					@Override
					public void onGlobalLayout() {
						try{
                            parentLayout.getWindowVisibleDisplayFrame(r);
                            Log.d(TAG, "On Global layout");

							int screenHeight = mContext.getResources().getDisplayMetrics().heightPixels;
                            int heightDifference = screenHeight - r.bottom;
                            int orientation = mContext.getResources().getConfiguration().orientation;

                            if(previousOrientation != orientation && popupWindow != null && popupWindow.isShowing()) {
                                popupWindow.dismiss();
                                // The delay is necessary to register the new height of the keyboard
                                mButton.postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        mButton.performClick();
                                    }
                                }, 100);
                                return;
                            }

							if(previousHeightDiffrence != heightDifference){

								previousHeightDiffrence = heightDifference;
								if (heightDifference > estimatedKeyboardHeight) {

									isKeyBoardVisible = true;
                                    changeKeyboardHeight(mButton.getResources().getConfiguration().orientation, heightDifference);
									makePlaceholderInvisible(popupWindow != null && popupWindow.isShowing());

								} else {
									isKeyBoardVisible = false;
									if(popupWindow != null && popupWindow.isShowing()){
										makePlaceholderVisible();
									}
								}
							}
						}
						catch(Throwable ex){
							Log.e(true, TAG, "Caught Exception in OnGlobalLayoutListener", ex);
						}

					}
				});
	}

	/**
	 * change height of emoticons keyboard according to height of actual
	 * keyboard
	 * 
	 * @param height
	 *            minimum height by which we can make sure actual keyboard is
	 *            open or not
	 */
	private void changeKeyboardHeight(int orientation, int height) {

		if (height > 100) {
			Log.i(TAG, "Changing keyboard height to: " + height + " . Orientation: " + orientation);
            int delta= 0;
            if(orientation == Configuration.ORIENTATION_LANDSCAPE) {
                keyboardHeightLandscape = height;
                int minHeight = (int) mContext.getResources().getDimension(R.dimen.aniways_keyboard_height_landscape);
                // If the default size is smaller than the actual keyboard size then we take the keyboard size
                deltaFromOpenedKeyboardLandscape = Math.max(0, minHeight - height);
                delta = deltaFromOpenedKeyboardLandscape;
                Log.d(TAG, "Keyboard height is: " + height + ". Min height is: " + minHeight + ". Delta from keyboard height is: " + deltaFromOpenedKeyboardLandscape + ". Orientation: Landscape");
            }
            else if(orientation == Configuration.ORIENTATION_PORTRAIT){
                keyboardHeightPortrait = height;
                int minHeight = (int) mContext.getResources().getDimension(R.dimen.aniways_keyboard_height_portrait);
                // If the default size is smaller than the actual keyboard size then we take the keyboard size
                deltaFromOpenedKeyboardPortrait = Math.max(0, minHeight - height);
                delta = deltaFromOpenedKeyboardPortrait;
                Log.d(TAG, "Keyboard height is: " + height + ". Min height is: " + minHeight + ". Delta from keyboard height is: " + deltaFromOpenedKeyboardPortrait + ". Orientation: Portrait");
            }
            else{
                Log.e(true, TAG, "Illegal orientation, treating like portrait: " + orientation);
                orientation = Configuration.ORIENTATION_PORTRAIT;
                changeKeyboardHeight(orientation, height);
                return;
            }

			LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LayoutParams.MATCH_PARENT, height + delta);
			if(emoticonsPlaceholder != null){
				emoticonsPlaceholder.setLayoutParams(params);
			}
		}

	}

	/**
	 * Defining all components of emoticons keyboard
	 */
	private void setupPopUpView(List<IconData> iconsForGenious) {	
		if(iconsForGenious == null){
			iconsForGenious = new ArrayList<>();
		}
		
		// Create and configure the popup window
		//
        int popupHeight = getKeyboardHeight() + getDelataFromKeyboard();
        Log.d(TAG, "Setting up popup with height: " + popupHeight);
		popupWindow = new PopupWindow(popUpView, LayoutParams.MATCH_PARENT,	popupHeight, false);
		popupWindow.setBackgroundDrawable(new BitmapDrawable(this.mContext.getResources()));
		popupWindow.setOutsideTouchable(true);
		// If it is focusable then the first touch out of the popup is not handled by other views and will not trigger and action
		//popupWindow.setFocusable(true);

		popupWindow.setTouchInterceptor(new OnTouchListener(){

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				try{
					mTimeOfLastEventThatClosedThePopup = event.getEventTime();
					Log.i(TAG, "(Time of event that closed popup (in touch interceptor): " + mTimeOfLastEventThatClosedThePopup);
				}
				catch(Throwable ex){
					Log.e(true, TAG, "Caught Exception in onTouch of popup window touch interceptor", ex);
				}
				return false;
			}

		});

		popupWindow.setOnDismissListener(new OnDismissListener() {

			@Override
			public void onDismiss() {
				try{
					// Convert the icon on the button to 'emoticons' (in case it is showing 'keyboard')
					// and remove the placeholder
					Log.i(TAG, "Dismissing Aniways Emoticons button popup");
					makePlaceholderInvisible(false);

					// Remove this popup from the set of opened popups
					if (sOpenedPopups != null){
						sOpenedPopups.remove(popupWindow);
					}

					// Recycle all bitmaps if necessary
					if(mPagerAdapter != null){
						// In these cases there is no cache, so its safe to recycle
						if(AniwaysPrivateConfig.getInstance().isLowMemoryDevice()){
							mPagerAdapter.recycleAllBitmaps();
						}
					}
					
					if(mStateChangeListener != null){
						mStateChangeListener.onHide();
					}

					// Report user time spent in Emoticons Button
					AnalyticsReporter.ReportTiming(Verbosity.Info, mStartUserInPopupTime, "User Action", "Time User Spent In Emoticons Button", Integer.toString(mNumberOfEmoticonsPicked), TAG, "Number of emoticons picked");
				}
				catch(Throwable ex){
					Log.e(true, TAG, "Caught Exception in onDismiss of popup window", ex);
				}
			}
		});

		// Prepare the locked icon helper
		//
        OnItemContainingLockedIconClickListener onItemContainingLockedIconClickListener = new OnItemContainingLockedIconClickListener() {
            @Override
            public void onItemClick(Object iconClickContext) {
                EmoticonsButtonIconClickContext context = (EmoticonsButtonIconClickContext) iconClickContext;
                onEmoticonClicked(context);
            }
        };
		Button creditsBalanceButton = (Button) popUpView.findViewById(R.id.aniways_ebp_credits_balance);
		AniwaysLockedIconHelper lockedIconHelper = new AniwaysLockedIconHelper(mParser, onItemContainingLockedIconClickListener, null, creditsBalanceButton, popupWindow, mParentLayout, false, this.mContext, "IOD");

		// Prepare the ViewPager and the adapter
		//

		AniwaysDirectionalViewPager pager = (AniwaysDirectionalViewPager) popUpView.findViewById(R.id.aniways_ebp_icon_assets_pager);
		//TODO: make configurable  (also for other places where this limit is set in other places and other page viewers)
		pager.setOffscreenPageLimit(1); //TODO: 1 is the minimum. 1. Make this value configurable. See if can somehow change this minimum

		mPagerAdapter = new EmoticonAssetsPagerAdapter(lockedIconHelper, mLastPagesLocation, pager.getContext(), iconsForGenious, mEditText);

		pager.setAdapter(mPagerAdapter);

        PageIndicator indicator = (PageIndicator) popUpView.findViewById(R.id.aniways_ebp_icon_assets_pager_indicator);
		//LinearLayout indicatorHolder = (LinearLayout)popUpView.findViewById(R.id.aniways_ebp_icon_categories_pager_indicator_holder);

		// If the indicator Tab is not defined a background then set it to the window background.
		// Find the background of the window, and if there is one then set it to the tab indicator.
		// Do it only if its a color cause otherwise there is an unexpected behavior..

		// !!This is commented out cause only supported in later android versions, so the lower ones will have no background.. 
		/*
		if(((View)mIndicator).getBackground() == null){
			Log.i(TAG, "Setting Tabs background to window background");
			Drawable background = ((Activity)pager.getContext()).getWindow().getDecorView().getBackground();
			if(background instanceof ColorDrawable){
				ColorDrawable backgroundColor = (ColorDrawable)background;
				int color = backgroundColor.getColor();
				if(background != null){
					((View)mIndicator).setBackgroundColor(color);
				}
			}
		}
		 */

		indicator.setViewPager(pager);
		indicator.setOnPageChangeListener(new OnPageChangeListener() {

            @Override
            public void onPageScrollStateChanged(int arg0) {
                // TODO Auto-generated method stub
            }

            @Override
            public void onPageScrolled(int arg0, float arg1, int arg2) {
                // TODO Auto-generated method stub
            }

            @Override
            public void onPageSelected(int assetCode) {
                try {
                    mLastPagesLocation.setSelectedAssetType(AssetType.getAssetType(assetCode));
                } catch (Throwable ex) {
                    Log.e(true, TAG, "Caught Exception in onPageSelected", ex);
                }
            }
        });

		// Make sure the assets pager shows the asset type previously shown.
		indicator.setCurrentItem(mLastPagesLocation.getSelectedAssetType().getAssetCode());
		mLastPagesLocation.reportScreenViewEvent();

		// Setup the popup height
		popupWindow.setHeight(getKeyboardHeight() + getDelataFromKeyboard());

		// Setup the placeholder and the emoticons button image
		if (isKeyBoardVisible) {
			makePlaceholderInvisible(true);
		} else {
			makePlaceholderVisible();
		}
	}

	class LastPagesLocation{
		private int NO_RECENTS_CATEGORY_EXISTS = -1;
		private JsonParser parser;
		private int categoryPage;
		private int familyPage;
		private int tableNumber;
		private AssetType selectedAssetType;

		LastPagesLocation(JsonParser parser){
			this.parser = parser;

			selectedAssetType = AssetType.Emoticons;
			categoryPage = getRecentCategoryPageByAssetType(selectedAssetType);
			familyPage = 0;
			tableNumber = 0;
		}

		boolean isInstanceRelevantForParser(JsonParser parser){
			return this.parser.getKeywordsVersion().equalsIgnoreCase(parser.getKeywordsVersion());
		}

		boolean isCurrentCategoryTheRecentsCategory(){
			return getCategoryPage() == getRecentCategoryPageByAssetType(selectedAssetType);
		}

		AssetType getSelectedAssetType() { return selectedAssetType; }

		void setSelectedAssetType(AssetType assetType){
			if (this.selectedAssetType != assetType){
				this.selectedAssetType = assetType;
				categoryPage = getRecentCategoryPageByAssetType(selectedAssetType);
				familyPage = 0;
				tableNumber = 0;
				reportScreenViewEvent();
			}
		}

		int getCategoryPage() {
			return categoryPage;
		}

		void setCategoryPage(int categoryPage) {
			if(this.categoryPage != categoryPage){
				this.categoryPage = categoryPage;
				this.familyPage = 0;
				this.tableNumber = 0;
				reportScreenViewEvent();
			}
		}

		public void reportScreenViewEvent() {
			AnalyticsReporter.reportIconsOnDemandScreenView(selectedAssetType, getCurrentCategoryName(), getCategoryPage(), getCurrentFamilyName(), getFamilyPage(), getTableNumber());
		}

		private String getCurrentFamilyName() {
			if(isCurrentCategoryTheRecentsCategory()){
				return "default";
			}
			
			ArrayList<String> families = mParser.getFamiliesInOrderForSuperCategory(getSelectedAssetType(), getCurrentCategoryName());
			if(families.size() < 1){
				return "Empty";
			}
			return families.get(getFamilyPage());
		}

		private String getCurrentCategoryName() {
			return mParser.getIconCategoriesInOrderByAssetType(this.selectedAssetType)[getCategoryPage()];
		}

		int getFamilyPage() {
			return familyPage;
		}

		void setFamilyPage(int familyPage) {
			if(getFamilyPage() != familyPage){
				this.familyPage = familyPage;
				this.tableNumber = 0;
				reportScreenViewEvent();
			}
		}

		int getTableNumber() {
			return tableNumber;
		}

		void setTableNumber(int tableNumber) {
			if(getTableNumber() != tableNumber){
				this.tableNumber = tableNumber;
				reportScreenViewEvent();
			}
		}

		private int getRecentCategoryPageByAssetType(AssetType assetType){
			int retRecentsCategoryPageNum = NO_RECENTS_CATEGORY_EXISTS;
			String[] categories = parser.getIconCategoriesInOrderByAssetType(assetType);

			if (categories != null) {
				for (int i = 0; i < categories.length; i++) {
					String category = categories[i];
					if (category.equalsIgnoreCase(EmoticonCategoriesPagerAdapter.RECENT)) {
						retRecentsCategoryPageNum = i;
						break;
					}
				}
			}

			return retRecentsCategoryPageNum;
		}
	}

	/*
	 * Closes all Aniways Emoticons button popups if any are showing. 
	 * Returns true if it actually closed something and false if not. 
	 */
	public static boolean dismissAllOpenedButtonPopups(){
		// Because view detached exception might be thrown
		boolean closedSomething = false;
		try{
			Log.d(TAG, "dismissing all Emoticon Button popups");

			if(sOpenedPopups != null){
				Log.d(TAG, "Closing opened popups");
				// Need this secondary since the dismiss will also remove from the collection on which we iterate
				HashSet<PopupWindow> secondary = new HashSet<>(sOpenedPopups);
				for(PopupWindow popup: secondary){
					if (popup.isShowing()){
						try{
							popup.dismiss();
						}
						catch(IllegalArgumentException ex){
							// This Exeption is thron in case the view is no longer attached to a window
							// manager. The correct course of action here is to dismiss in onDestroy of the 
							// activity. But since we are an SDK and we do not have access to this, then
							// we settle for swallowing :)
						}
						closedSomething = true;
					}
					else{
						Log.w(true, TAG, "An opened emoticons button popup is not showing");
					}
				}
			}
		}
		catch (Exception e){
			Log.w(true, TAG, "caught Exception while dismissing all opened emoticons button popups", e);
		}
		return closedSomething;
	}

	/*
	 * Used to know not to display the tutorial when inserting icons from button, 
	 * or if deleting from button and replacing icon with text 
	 */
	public static boolean isEmoticonsButtonShowing(){
		try{
			if(sOpenedPopups != null){
				for(PopupWindow popup: sOpenedPopups){
					if (popup.isShowing()){
						return true;
					}
					else{
						Log.w(true, TAG, "An opened emoticons button popup is not showing");
					}
				}
			}
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in isEmoticonsButtonShowing", ex);
		}

		return false;
	}

	private void onEmoticonClicked(EmoticonsButtonIconClickContext context) {

		Phrase phrase = context.icon.primaryPhrase;
		if(phrase == null){
			Log.e(true, TAG, "There is no primary phrase for icon path: " + context.icon.getFileName());
			return;
		}

		// Add the icon to the text
		if(mEditText != null){
			int selectionStart = mEditText.getSelectionStart();
			int selectionEnd = mEditText.getSelectionEnd();
			mEditText.insetTextCoveredWithIcon(context.icon, selectionStart, selectionEnd, phrase, new IAniwaysImageSpan.ImageSpanMetadata(context.icon, IAniwaysImageSpan.IconSelectionOrigin.AniwaysKeyboard), true);
		}
		
		String fileName = context.icon.getFileName();
		
		// Report event of picked icon
		if(context.isGeniousIcon){
			GoogleAnalyticsReporter.reportEvent(Verbosity.Info, "Picked Icon in Emoticons button - genious - android", phrase.getPhraseSubPhraseString(), fileName, 0);
		}
		else{
			GoogleAnalyticsReporter.reportEvent(Verbosity.Info, "Picked Icon in Emoticons button - android", context.tabName + "--" + context.familyName + "--" + context.pageNumber, fileName, 0);
		}
		AnalyticsReporter.reportPhrasesEvent(
				PhrasesEventAction.selected, 
				mEditText == null ? null : mEditText.getMessageId(), 
						phrase,
						new IconData[] { context.icon },
						AniwaysStoreManager.isIconUnlocked(context.icon),
						null,
						context.isGeniousIcon,
						context.tabName,
						context.tabNumber,
						context.tabNumber == 0 ? context.icon.family : context.familyName,
						context.familyNumber,
						context.pageNumber,
						context.position,
						context.outOf,
						context.row,
						context.column,
						context.numRows,
						context.numColumns,
						0, null, null, new IAniwaysImageSpan.ImageSpanMetadata(context.icon, IAniwaysImageSpan.IconSelectionOrigin.AniwaysKeyboard));

		// Add icon to the top of the 'recents' stack
		AniwaysRecentIconsManager.addRecentIcon(context.icon.id, context.icon.assetType);

		// This will make sure that the 'recents' tab is updated with this icon 
		// (but only if we are not in the recents tab now, because we dont want the icon location to change for the use while he is clicking on icons there - for example, if he wants to add the same icon more than one time..)
		// If the user is in the recents tab, then there is no need to notify of dataset change since the icon positions there
		// will be refreshed the next time the tab is opened, or even if the user browses between tabs and that tab is removed from the cache..
		if(!context.isFromRecentsTab){
			mPagerAdapter.notifyDataSetChanged();
		}

		// Increment number of emoticons picked in this showing of the button
		mNumberOfEmoticonsPicked++;
	}

	@Override
	public void onStoreAboutToLaunch() {}

	@Override
	public void onStoreClosing() {

	}

	private void makePlaceholderVisible() {
		setButtonImage(EmoticonsButtonImageType.Collapse);
		if(emoticonsPlaceholder != null){
			emoticonsPlaceholder.setVisibility(LinearLayout.VISIBLE);
		}
        else{
            if(mUsePadding){
                mParentLayout.setPadding(0,0,0, getKeyboardHeight() + getDelataFromKeyboard());
            }
            else{
                showSoftKeyboard();
            }
        }
	}

	private void makePlaceholderInvisible(boolean isButtonOpened) {
		if(isButtonOpened){
			setButtonImage(EmoticonsButtonImageType.Keyboard);
		}
		else{
			setButtonImage(EmoticonsButtonImageType.Smiley);
		}
		if(emoticonsPlaceholder != null){
			emoticonsPlaceholder.setVisibility(LinearLayout.GONE);
		}
        else if(mUsePadding){
            mParentLayout.setPadding(0,0,0, isButtonOpened ? getDelataFromKeyboard() : 0);
        }
	}

    private int getOrientation(){
        int orientation = mButton.getResources().getConfiguration().orientation;
        if(orientation != Configuration.ORIENTATION_LANDSCAPE && orientation != Configuration.ORIENTATION_PORTRAIT) {
            orientation = Configuration.ORIENTATION_PORTRAIT;
            Log.e(true, TAG, "Illegal orientation, treating like portrait: " + orientation);
        }

        return orientation;
    }

    private int getDelataFromKeyboard(){
        return getOrientation() == Configuration.ORIENTATION_LANDSCAPE ? deltaFromOpenedKeyboardLandscape : deltaFromOpenedKeyboardPortrait;
    }

    private int getKeyboardHeight(){
        return getOrientation() == Configuration.ORIENTATION_LANDSCAPE ? keyboardHeightLandscape : keyboardHeightPortrait;
    }

	private void setButtonImage(EmoticonsButtonImageType type) {
		switch(type){
		case Collapse:
			setButtonResource(R.drawable.aniways_ebp_collapse_button);
			break;
		case Keyboard:
			setButtonResource(R.drawable.aniways_ebp_keyboard_button);
			break;
		case Smiley:
			setButtonResource(R.drawable.aniways_ebp_icons_button);
			break;
		default:
			Log.e(true, TAG, "Illegal button image type: " + type);
			break;
		}
	}

	private void setButtonResource(int resource) {
		if(mButton instanceof ImageView){
			((ImageView) mButton).setImageResource(resource);
			((ImageView) mButton).setScaleType(ImageView.ScaleType.FIT_CENTER);
		}
	}

	private List<IconData> getIconsForGeniousMode() {
		List<IconData> iconsForGenious = new ArrayList<>();

		if(mEditText == null){
			return iconsForGenious;
		}

		ArrayList<AniwaysEditText.RecognizedPhrase> recognizedPhrases = mEditText.getRecognizedPhrases(false);
		if(recognizedPhrases != null && recognizedPhrases.size() > 0){
			for(RecognizedPhrase rp : recognizedPhrases){
				IconData[] newIcons = rp.phrase.emoticonsPhraseAssetBuilder.icons;
				if(newIcons != null && newIcons.length > 0){
					iconsForGenious.addAll(Arrays.asList(newIcons));
				}
			}
		}
		return iconsForGenious;
	}
	
	private void showSoftKeyboard(){
        InputMethodManager imm = (InputMethodManager)mContext.getSystemService(Service.INPUT_METHOD_SERVICE);
        imm.showSoftInput(this.mEditText, 0);
    }

	// The type of image that is displayed on the button itself.
	// Indicating whether the button would open the popup, collapse the popup, or uncover the keyboard below the popup
	private enum EmoticonsButtonImageType{
		Smiley,
		Keyboard,
		Collapse
	}

	//public interface OnKeyboardVisibilityListener {
	//	void onVisibilityChanged(boolean visible);
	//}

	/*
	@Override
	public void keyClickedIndex(String index) {
		Log.e(false, TAG, "Clicked key: " + index);

	}
	 */

	//TODO: decide if want to use this instead of the button placeholder trick
	/*
	// Use code from here to get the top view and add the cover place for the popup
	public final void setKeyboardListener(final OnKeyboardVisibilityListener listener) {
		final View activityRootView = ((ViewGroup) getActivity().findViewById(android.R.id.content)).getChildAt(0);
		activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(new OnGlobalLayoutListener() {

			private boolean wasOpened;

			private final Rect r = new Rect();

			@Override
			public void onGlobalLayout() {
				activityRootView.getWindowVisibleDisplayFrame(r);

				int heightDiff = activityRootView.getRootView().getHeight() - (r.bottom - r.top);
				if (heightDiff == 0 && !wasOpened) {
					logDebug("Ignoring...");
					return;
				}
				if (heightDiff > 100) {
					wasOpened = true;
					listener.onVisibilityChanged(wasOpened);
				} else {
					wasOpened = false;
					listener.onVisibilityChanged(wasOpened);
				}
			}
		});
	}
	 */

}
