package com.aniways.data;

import com.aniways.service.utils.AniwaysAction;

import java.util.List;

/**
 * Fetches the required information and builds instances of IAniwaysAssetInfo.
 */
public interface IAssetInfoBuilder {

    /**
     * Checks whether this builder is associated with the specified providerName.
     *
     * @param providerName The provider to be verified.
     * @return A value indicating whether this instance is associated with the specified providerName.
     */
    boolean canBuild(String providerName);

    /**
     * Cancels pending pending requests this instance may have.
     */
    void cancelPendingRequests();

    /**
     * Constructs assets associated with the specified resource ids and calls the specified completion callback when done.
     * @param resourceIds The ids of the resources to be built by this instance.
     * @param completionCallback A callback to be called when all of the requested items have been constructed.
     */
    void buildAssets(String[] resourceIds, AniwaysAction<List<IAniwaysAssetInfo>> completionCallback);
}