package com.aniways.data;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;

import com.aniways.AssetType;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.volley.toolbox.Volley;

/**
 * Created by Shai on 18/01/2015.
 */
public class GiphyIconData extends IconData {
    private static final String GIPHY_FAMILY = "Giphy";
    private static final String TAG = "AniwaysGiphyIconData";
    public final String idInGiphy;
    private final String stillUrl;
    private final String animationUrlLowQuality;
    private final String animationUrlHighQuality;

    public GiphyIconData(String id, String stillUrl, String animationUrlLowQuality, String animationUrlHighQuality, Phrase primaryPhrase) {
        super(AniwaysPrivateConfig.getInstance().animatedGifImageId, GIPHY_FAMILY, false, primaryPhrase, null, AssetType.AnimatedGif, IAniwaysImageSpan.AssetProvider.Giphy, true);
        this.idInGiphy = id;
        this.stillUrl = stillUrl;
        this.animationUrlLowQuality = animationUrlLowQuality;
        this.animationUrlHighQuality = animationUrlHighQuality;
    }
    
    @Override
    public String getUrl(boolean useSmallEmoji, boolean displayBig, boolean displayBanner) {
        // If the Still URL in cahce then return it, if not then check the animation url. If both not present then return image.
        // When we take the animation URL we will only present the 1st frame
        AniwaysPrivateConfig cfg = AniwaysPrivateConfig.getInstance();
        Object data = Volley.getImageLoader().getCached(stillUrl, cfg.getMaxWidthForCache(this), cfg.getMaxHeightForCache(this), this.getFileName());
        if(data == null){
            // Check the animation url
            data = Volley.getImageLoader().getCached(animationUrlLowQuality, cfg.getMaxWidthForCache(this), cfg.getMaxHeightForCache(this), this.getFileName());
            if(data == null){
                data = Volley.getImageLoader().getCached(animationUrlHighQuality, cfg.getMaxWidthForCache(this), cfg.getMaxHeightForCache(this), this.getFileName());
                if(data == null) {
                    Log.d(TAG, "Returning still url since nothing is cached");
                    return stillUrl;
                }
                else{
                    Log.d(TAG, "Returning high quality animation url");
                    return animationUrlHighQuality;
                }
            }
            else{
                Log.d(TAG, "Returning low quality animation url");
                return animationUrlLowQuality;
            }
        }
        else{
            Log.d(TAG, "Returning still url since it is cached");
            return stillUrl;
        }
    }

    @Override
    public Drawable generateDrawable(Bitmap image, Context ctx) {

        if(ctx == null){
            Log.e(true, TAG, "context is null");
            return null;
        }
        if(image == null){
            Log.e(true, TAG, "image is null");
            return null;
        }

        return RoundedBitmapDrawableFactory.create(ctx.getResources(), image);
    }

    //TODO: there should be a common base for all icons that represent data that is not sent inline int the message (placesm, gifs, etc)
    //      this method should be there..
    @Override
    public Drawable setDrawableBounds(Drawable drawable, int maxWidth, int maxHeight){
        if(drawable == null){
            return null;
        }

        if(drawable instanceof RoundedBitmapDrawable){
            drawable.setBounds(0,0,maxWidth,maxHeight);
            // TODO: Assuming that we have a square..
            ((RoundedBitmapDrawable)drawable).setCornerRadius(maxHeight / 2);
            return drawable;
        }
        else {
            // This can be when it is not used in the EditText, but from the ImageView
            return super.setDrawableBounds(drawable, maxWidth, maxHeight);
        }
    }
}
