package com.aniways.data;

import com.aniways.service.utils.AniwaysAction;

import java.util.List;

/**
 * Constructs details regarding a place obtained from FourSquare.
 */
public class FourSquareAssetInfoBuilder implements IAssetInfoBuilder {

    private static final String TAG = "FourSquareAssetInfoBuilder";


    // https://api.foursquare.com/v2/venues/search?near=Tel%20Aviv&query=gooc&oauth_token=JACOZL4GRJ5AFK2NWYN2T5CVNLSDQSYNLL3JNFXCS1GJNGKS&v=20150204

    /**
     * Holds the max number of items to query.
     */
    private int maxItemsPerQuery;

    public FourSquareAssetInfoBuilder() {

    }

    /**
     * Checks whether this builder is associated with the specified providerName.
     *
     * @param providerName The provider to be verified.
     * @return A value indicating whether this instance is associated with the specified providerName.
     */
    @Override
    public boolean canBuild(String providerName) {
        return false;
    }

    /**
     * Cancels pending pending requests this instance may have.
     */
    @Override
    public void cancelPendingRequests() {

    }

    /**
     * Constructs assets associated with the specified resource ids and calls the specified completion callback when done.
     *
     * @param resourceIds        The ids of the resources to be built by this instance.
     * @param completionCallback A callback to be called when all of the requested items have been constructed.
     */
    @Override
    public void buildAssets(String[] resourceIds, AniwaysAction<List<IAniwaysAssetInfo>> completionCallback) {

    }
}