package com.aniways.data;

import com.aniways.IconData;
import com.aniways.service.utils.AniwaysAction;

import java.util.ArrayList;
import java.util.List;

/**
 * Builds IAniwaysAssetInfo instances for a given Phrase.
 */
public class EmoticonsPhraseAssetBuilder extends PhraseAssetInfoBuilderBase {

    public IconData[] icons;

    public EmoticonsPhraseAssetBuilder(IconData[] icons) {
        this.icons = icons;
    }

    @Override
    public Phrase getReferencePhrase(JsonParser parser, Phrase phrase) {
        return phrase;
    }

    @Override
    public boolean isEmpty() {
        return icons == null || icons.length == 0;
    }

    @Override
    public int buildAssets(AniwaysAction<List<IAniwaysAssetInfo>> callback, Phrase phrase) {
        // If there are no content providers, return null
        if (this.isEmpty()) {
            callback.call(null);
            return -1;
        }

        final int requestId = getNewRequestId();
        List<IAniwaysAssetInfo> assetInfoItems = new ArrayList<>();
        for (IconData icon : this.icons) {
            assetInfoItems.add(new AniwaysEmoticonAssetInfo(icon));
        }
        callback.call(assetInfoItems);
        return requestId;
    }
}