/**
 * 
 */
package com.aniways.data;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.analytics.utils.LooperThreadWithHandler;
import android.content.Context;

/**
 * @author Shai
 *
 */
public class AniwaysNetworkStateChecker extends NonThrowingRunnable {

	private static final String TAG = "AniwaysNetworkStateChecker";
	private static final String THREAD_NAME = "AniwaysNetworkStateChecker";

	private static AniwaysNetworkStateChecker sInstance;

	private Context mContext;
	private LooperThreadWithHandler mThread;
	Queue<AniwaysNetworkSateCheckCallback> mCallbacks = new ConcurrentLinkedQueue<AniwaysNetworkSateCheckCallback>();

	public static void forceInit(Context applicationContext) {
		if(sInstance != null){
			Log.e(true, TAG, "Calling init of AniwaysNetworkStateChecker more than once");
		}

		AniwaysNetworkStateChecker instance = new AniwaysNetworkStateChecker(applicationContext);
		LooperThreadWithHandler thread = new LooperThreadWithHandler(THREAD_NAME);
		instance.setThread(thread);

		if(sInstance != null){
			Log.i(TAG, "There is already a AniwaysNetworkStateChecker thread running, so interrupting it");
			Thread oldThread = sInstance.getThread();
			oldThread.interrupt();
		}

		Log.i(TAG, "Starting the AniwaysNetworkStateChecker..");
		thread.start();
		sInstance = instance;
	}

	private LooperThreadWithHandler getThread() {
		return this.mThread;

	}

	private void setThread(LooperThreadWithHandler thread) {
		this.mThread =thread;

	}

	/**
	 *
	 */
	public AniwaysNetworkStateChecker(Context context) {
		super(TAG, "run", "");
		mContext = context;
	}

	/**
	 * 
	 */
	@Override
	public void innerRun() {

		if(mCallbacks.size() < 1){
			return;
		}

		boolean available = Utils.isInternetAvailable(mContext) != null; 

		AniwaysNetworkSateCheckCallback callback = mCallbacks.poll();
		while(callback != null){
			try{
				callback.run(available);
			}
			catch(Throwable tr){
				Log.e(true, TAG, "Caught Exception in callback", tr);
			}
			callback = mCallbacks.poll();
		}

	}

	public static void checkInternet(AniwaysNetworkSateCheckCallback callback){
		sInstance.mCallbacks.offer(callback);
		sInstance.getThread().handler().post(sInstance);
	}

	public interface AniwaysNetworkSateCheckCallback{
		public void run(boolean connectionAvailable);
	}

}
