package com.aniways.data;

import android.content.Context;
import android.content.res.Resources;
import android.util.Pair;

import com.aniways.Log;

/**
 * Created by moran on 12/17/2014.
 */

/*
This class will search for resources first with
the prefix 'AW_Client_*' then in our R.
This will allow clients to override predefined resources.
*/

public class AniwaysClientConfig {
    private static final String TAG = "AniwaysClientConfig";
    private static final String PREFIX = "AW_Client_";

    private static AniwaysClientConfig instance;

    private AniwaysClientConfig() {
    }

    public static AniwaysClientConfig getInstance()
    {
        if (instance == null)
            instance = new AniwaysClientConfig();

        return instance;
    }

    public String getResourceString(String name){
        int clientResId = getResourceId(PREFIX + name, "string");
        int resId = getResourceId(name, "string");

        Resources resources = AniwaysStatics.getApplicationContext().getResources();

        if (clientResId != 0){
            String result = resources.getString(clientResId);
            return result;
        }

        if(resId != 0){
            String result = resources.getString(resId);
            return result;
        }

        return "";
    }

    public  int getResourceInt(String name){
        int clientResId = getResourceId(PREFIX + name, "integer");
        int resId = getResourceId(name, "integer");

        Resources resources = AniwaysStatics.getApplicationContext().getResources();

        if(clientResId != 0){
            int result = resources.getInteger(clientResId);
            return result;
        }

        if(resId != 0){
            int result = resources.getInteger(resId);
            return result;
        }

        return -1;
    }

    public  Pair<Boolean,Boolean> getResourceBoolean(String name){
        int resId = getResourceId(name, "bool");
        int clientResId = getResourceId(PREFIX + name, "bool");

        Resources resources = AniwaysStatics.getApplicationContext().getResources();

        if(clientResId != 0){
            boolean result = resources.getBoolean(clientResId);
            return new Pair<Boolean,Boolean>(true, result);
        }

        if(resId != 0){
            boolean result = resources.getBoolean(resId);
            return new Pair<Boolean,Boolean>(true, result);
        }

        return new Pair<Boolean,Boolean>(false,false);
    }

    private int getResourceId(String name, String type){
        Context applicationContext = AniwaysStatics.getApplicationContext();
        String packageName = applicationContext.getPackageName();

        return applicationContext.getResources().getIdentifier(name, type, packageName);
    }
}
