package com.aniways.data;

import android.support.annotation.NonNull;

import com.aniways.IconData;
import com.aniways.service.utils.AniwaysAction;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AnimatedGifPhraseAssetInfoBuilder extends PhraseAssetInfoBuilderBase {

    public static final AnimatedGifPhraseAssetInfoBuilder DEFAULT;
    private static final List<IAssetInfoBuilder> assetInfoBuilders;
    private final HashMap<String, String[]> providerNameToResourceIdsMap;
    private final boolean searchAllProviders;

    static {
        DEFAULT = new AnimatedGifPhraseAssetInfoBuilder();

        //Todo: all this initialisation should be done using dependency injection via IOC
        assetInfoBuilders = new LinkedList<>();

        assetInfoBuilders.add(new GiphyAssetInfoBuilder());
        //add Aniways builder
        //add other providers here
    }

    public AnimatedGifPhraseAssetInfoBuilder(@NonNull HashMap<String, String[]> providerNameToResourceIds) {
        this.searchAllProviders = false;

        // TODO: this should be in the base class since in V3 all asset data will look like this
        //       then inheritors could have methods to parse this in whatever way they want
        this.providerNameToResourceIdsMap = providerNameToResourceIds;
    }

    private AnimatedGifPhraseAssetInfoBuilder() {
        this.searchAllProviders = true;

        this.providerNameToResourceIdsMap = new HashMap<>();
        this.providerNameToResourceIdsMap.put(AnimatedGifsProviders.GIPHY.getStringRepresentation(), null);
    }

    @Override
    public Phrase getReferencePhrase(JsonParser parser, Phrase phrase) {
        //Todo: uncomment this once the new json with the translation is available and also remove the phrase param:
        //return parser.getPhraseByName(get(AnimatedGifsProviders.INTERNAL_REFERENCE.getStringRepresentation())[0]);

        //Todo: this is a hack for supporting other languages than english using the primary phrase, this will be removed once the new json is available:
        return extractPrimaryPhrase(phrase);
    }

    @Override
    public boolean isEmpty() {
        return providerNameToResourceIdsMap.isEmpty();
    }

    @Override
    public int buildAssets(final AniwaysAction<List<IAniwaysAssetInfo>> callback, Phrase phrase) {
        //TODO: Right now the caller of this method calls the getReferencePhrase method - this logic should be here instead

        // If there are no content providers, return null
        if (this.isEmpty()) {
            callback.call(null);
            return -1;
        }

        HashMap<IAssetInfoBuilder, String[]> matchedBuilders = new HashMap<>();

        for (Map.Entry<String, String[]> entry : this.providerNameToResourceIdsMap.entrySet()) {
            String providerName = entry.getKey();
            String[] resourceIds;
            if (searchAllProviders) {
                resourceIds = new String[] { "search:" + phrase.getName() };
            }
            else {
                resourceIds = entry.getValue();
            }

            for (IAssetInfoBuilder candidate : assetInfoBuilders) {
                if (candidate.canBuild(providerName)) {
                    matchedBuilders.put(candidate, resourceIds);
                    break;
                }
            }
        }

        // No matching builders found call back with null
        if (matchedBuilders.isEmpty()) {
            callback.call(null);
            return -1;
        }

        final AssetInfoBuilderRequestContext ctx = new AssetInfoBuilderRequestContext(matchedBuilders
                                                                                              .keySet(), callback);
        final int requestId = getNewRequestId();
        requests.put(requestId, ctx);

        for (Map.Entry<IAssetInfoBuilder, String[]> entry : matchedBuilders.entrySet()) {
            IAssetInfoBuilder builder = entry.getKey();
            String[] data = entry.getValue();

            builder.buildAssets(data, getCompletionCallback(requestId, ctx));
        }

        return requestId;
    }

    private Phrase extractPrimaryPhrase(Phrase phrase) {
        if (phrase == null) {
            return null;
        }

        if (phrase.emoticonsPhraseAssetBuilder == null || phrase.emoticonsPhraseAssetBuilder.icons.length <= 0) {
            return null;
        }

        // Search for the first non-null primary phrase.
        for (IconData icon : phrase.emoticonsPhraseAssetBuilder.icons) {
            Phrase primaryPhrase = icon.primaryPhrase;

            if (primaryPhrase != null) {
                if (primaryPhrase.animatedGifsPhraseAssetBuilder == null) {
                    primaryPhrase.animatedGifsPhraseAssetBuilder = DEFAULT;
                }

                return primaryPhrase;
            }
        }

        // Try to use the original phrase.
        return phrase;
    }
}