package com.aniways.analytics.utils;

import com.aniways.Log;

import android.os.Handler;
import android.os.HandlerThread;

public class LooperThreadWithHandler extends HandlerThread {
	
	public LooperThreadWithHandler(String name) {
		super(name);
	}
	
	public LooperThreadWithHandler(String name, int priority) {
		super(name, priority);
	}

	private static final String TAG = "AniwaysLooperThreadWithHandler";
	private Handler handler;
	
	@Override
	public void run(){
		try{
			super.run();
		}
		catch(Throwable ex){
			// TODO: since the process is about to die here, make sure that the analytics service will indeed send the error to the
			// server, or at least save it for next time the app is running and send then..
			Log.eToGaOnly(true, TAG, "Uncaught error in thread: " + this.getName(), ex);
			
			// Kill this process since we had an unhandled error and the looper is no longer functioning.
			// We kill the process gracefully in order not to trigger uncaught exception handlers..
			android.os.Process.killProcess(android.os.Process.myPid());
		}
	}
	
	@Override
	protected void onLooperPrepared(){
		synchronized (this) {
			handler = new Handler();
			try{
				notifyAll();
			}
			catch(Throwable ex){
				Log.eToGaOnly(true, TAG, "Caught Exception while notifying all", ex);
			}
		}
	}
	
	private void waitForReady() {
		while (this.handler == null) {
			synchronized (this) {
				try {
					wait();
				} catch (InterruptedException e) {
					Log.eToGaOnly(true, TAG, "Failed while waiting for singleton thread ready. ", e);
				}
			}
		}
	}

	/**
	 * Gets this thread's handler
	 */
	public Handler handler() {
		waitForReady();
		return handler;
	}

}
