package com.aniways.analytics.request.azure;

/**
 * Represents the credentials used to sign a request against the storage services.
 */
 final class Credentials {
    /**
     * Stores the Account name for the credentials.
     */
     String accountName;

    /**
     * Stores the StorageKey for the credentials.
     */
     final StorageKey key;

    /**
     * Creates an instance of the <code>Credentials</code> class, using the specified storage account name and access
     * key; the specified access key is stored as a Base64-encoded <code>String</code>.
     * 
     * @param accountName
     *        A <code>String</code> that represents the name of the storage account.
     * 
     * @param key
     *        A <code>String</code> that represents the Base64-encoded account access key.
     * 
     */
     Credentials(final String accountName, final String key) {
    	
    	if (accountName == null || accountName.length() == 0) {
            throw new IllegalArgumentException(SR.INVALID_ACCOUNT_NAME);
        }

        if (key == null) {
            throw new IllegalArgumentException(SR.KEY_NULL);
        }

        byte[] byteKey = Base64.decode(key);
        
        this.accountName = accountName;
        this.key = new StorageKey(byteKey);
    }

}
