package com.aniways.analytics.request.azure;

/**
 * RESERVED FOR INTERNAL USE. Contains storage constants.
 */
final class Constants {

    /**
     * Defines constants for use with HTTP headers.
     */
     static class HeaderConstants {
        /**
         * The Accept header.
         */
         static final String ACCEPT = "Accept";

        /**
         * The Accept-Charset header.
         */
         static final String ACCEPT_CHARSET = "Accept-Charset";

        /**
         * The Accept-Encoding header.
         */
         static final String ACCEPT_ENCODING = "Accept-Encoding";

        /**
         * The Authorization header.
         */
         static final String AUTHORIZATION = "Authorization";

        /**
         * The ContentEncoding header.
         */
         static final String CONTENT_ENCODING = "Content-Encoding";

        /**
         * The ContentLangauge header.
         */
         static final String CONTENT_LANGUAGE = "Content-Language";

        /**
         * The ContentMD5 header.
         */
         static final String CONTENT_MD5 = "Content-MD5";

        /**
         * The ContentType header.
         */
         static final String CONTENT_TYPE = "Content-Type";

        /**
         * The header that specifies the date.
         */
         static final String DATE = PREFIX_FOR_STORAGE_HEADER + "date";

        /**
         * The IfMatch header.
         */
         static final String IF_MATCH = "If-Match";

        /**
         * The IfModifiedSince header.
         */
         static final String IF_MODIFIED_SINCE = "If-Modified-Since";

        /**
         * The IfNoneMatch header.
         */
         static final String IF_NONE_MATCH = "If-None-Match";

        /**
         * The IfUnmodifiedSince header.
         */
         static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";

        /**
         * The Range header.
         */
         static final String RANGE = "Range";

        /**
         * The header for storage version.
         */
         static final String STORAGE_VERSION_HEADER = PREFIX_FOR_STORAGE_HEADER + "version";

        /**
         * The current storage version header value.
         */
         static final String TARGET_STORAGE_VERSION = "2014-02-14";

        /**
         * The UserAgent header.
         */
         static final String USER_AGENT = "User-Agent";

        /**
         * Specifies the value to use for UserAgent header.
         */
         static final String USER_AGENT_PREFIX = "Azure-Storage";

        /**
         * Specifies the value to use for UserAgent header.
         */
         static final String USER_AGENT_VERSION = "0.1.0";

        /**
         * The default type for content-type and accept
         */
         static final String XML_TYPE = "application/xml";
    }

    /**
     * The master Microsoft Azure Storage header prefix.
     */
     static final String PREFIX_FOR_STORAGE_HEADER = "x-ms-";

    /**
     * An empty <code>String</code> to use for comparison.
     */
     static final String EMPTY_STRING = "";

    /**
     * The default type for content-type and accept
     */
     static final String UTF8_CHARSET = "UTF-8";
}
