package com.aniways.analytics.request.azure;

import java.net.HttpURLConnection;
import java.security.InvalidParameterException;

/**
 * RESERVED FOR INTERNAL USE. Provides an implementation of the Canonicalizer class for requests against Blob and Queue
 * Service under the Shared Key authentication scheme.
 */
final class BlobQueueFullCanonicalizer extends Canonicalizer {

	final static BlobQueueFullCanonicalizer insatnce = new BlobQueueFullCanonicalizer();
	
    /**
     * Constructs a canonicalized string for signing a request.
     * 
     * @param conn
     *            the HttpURLConnection to canonicalize
     * @param accountName
     *            the account name associated with the request
     * @param contentLength
     *            the length of the content written to the outputstream in bytes, -1 if unknown
     * @return a canonicalized string.
     */
    @Override
    protected String canonicalize(final HttpURLConnection conn, final String accountName, final Long contentLength) {

        if (contentLength < -1) {
            throw new InvalidParameterException(SR.INVALID_CONTENT_LENGTH);
        }

        return canonicalizeHttpRequest(conn.getURL(), accountName, conn.getRequestMethod(),
                Utility.getStandardHeaderValue(conn, Constants.HeaderConstants.CONTENT_TYPE), contentLength, null,
                conn);
    }
}
