package com.aniways.analytics.models;

import java.util.Calendar;

import org.json.JSONObject;

public class Timing extends Track {
	
	public final static String TYPE = "timing";
	
	private static final String TIMING_KEY = "time";
	
	public Timing (JSONObject obj) {
		super(obj);
	}
	
	public Timing(long time, 
				 EventProperties properties, 
				 Calendar timestamp,
				 Context context) {

		super(properties, timestamp, context);

		put("type", TYPE);
		
		setTime(time);
	}

	public String getTime() {
		return this.optString(TIMING_KEY, null);
	}

	public void setTime(long time) {
		this.put(TIMING_KEY, Long.toString(time));
	}
}
