package com.aniways.analytics;

import com.aniways.Log;

public abstract class NonThrowingRunnable implements Runnable{

	private String mTag;
	private String mMethodName;
	private String mErrorMessageSuffix;
	private boolean mReportToGaOnly;
	private OnCatchCallback mOnCatch;

	public interface OnCatchCallback{
		public void onCatch(Throwable e);
	}

	public NonThrowingRunnable(String tag, String methodName, String errorMessageSuffix){
		this(tag, methodName, errorMessageSuffix, false);
	}

	public NonThrowingRunnable(String tag, String methodName, String errorMessageSuffix, boolean reportToGaOnly){
		mTag = tag;
		mMethodName = methodName;
		mErrorMessageSuffix = errorMessageSuffix;
		mReportToGaOnly = reportToGaOnly;
	}

	public NonThrowingRunnable(String tag, String methodName, String errorMessageSuffix, OnCatchCallback onCatch){
		this(tag, methodName, errorMessageSuffix, false);
		this.mOnCatch = onCatch;
	}

	@Override
	public void run() {
		try{
			innerRun();
		}
		catch(Throwable ex){
			if(mOnCatch != null){
				try{
					mOnCatch.onCatch(ex);
				}
				catch(Throwable e){
					Log.eToGaOnly(true, mTag, "Caught Exception in onCatch", e);
				}
			}
			else{
				String message = "Caught Exception in runnable of " + mMethodName + (mErrorMessageSuffix == null ? "" : ". ") + mErrorMessageSuffix;
				if(mReportToGaOnly){
					Log.eToGaOnly(true, mTag, message, ex);
				}
				else{
					Log.e(true, mTag, message, ex);
				}
			}
		}

	}

	public abstract void innerRun();


}
