/**
 * 
 */
package com.aniways.analytics;

import java.util.Locale;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;

import com.aniways.Log;
import com.aniways.data.AniwaysConfiguration.Verbosity;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.service.utils.AniwaysServiceUtils;

import aniways.com.google.analytics.tracking.android.Fields;
import aniways.com.google.analytics.tracking.android.GAServiceManager;
import aniways.com.google.analytics.tracking.android.GoogleAnalytics;
import aniways.com.google.analytics.tracking.android.Logger;
import aniways.com.google.analytics.tracking.android.MapBuilder;
import aniways.com.google.analytics.tracking.android.Tracker;


/**
 * @author Shai
 *
 */
public class GoogleAnalyticsReporter {

	private static Tracker sGaTracker;
	private static final String TAG = "AniwaysGoogleAnalyticsReporter";

	static void ReportTiming(Verbosity verbosity, long measuredTime, String category, String name, String labelValueString){
		// Send performance analytics data to GA  
		if(AniwaysPrivateConfig.getInstance().gaTimingEventsVerbosity.ordinal() <= verbosity.ordinal()){
            sGaTracker.send(MapBuilder.createTiming(category, measuredTime, name, labelValueString).build());
		}
	}

	static void reportView(String viewName) {
		Verbosity verbosity = Verbosity.Info;

		if(AniwaysPrivateConfig.getInstance().gaScreenEventsVerbosity.ordinal() <= verbosity.ordinal()){
            sGaTracker.set(Fields.SCREEN_NAME, viewName);
            sGaTracker.send(MapBuilder
                    .createAppView()
                    .build());
		}
	}

	static void reportNewSession() {
		if(!AniwaysPrivateConfig.getInstance().isGoogleAnalyticsDisabled()){
			dispatchGaEvents();
            MapBuilder builder = MapBuilder.createAppView();
            builder.set(Fields.SESSION_CONTROL, "start");
            sGaTracker.set(Fields.SCREEN_NAME, "Unknown");
            sGaTracker.send(builder.build());
		}
	}

	static void reportException(String stack, Boolean isFatal) {
		if(AniwaysPrivateConfig.getInstance().googleAnalyticsEventsVerbosity.ordinal() <= Verbosity.Error.ordinal()){
			sGaTracker.send(MapBuilder
                    .createException(stack, isFatal).build());
		}
	}

	public static void reportEvent(Verbosity verbosity, String category, String action, String label, long value) {
		if(AniwaysPrivateConfig.getInstance().googleAnalyticsEventsVerbosity.ordinal() <= verbosity.ordinal()){
            sGaTracker.send(MapBuilder
                    .createEvent(category, action, label, value)
                    .build());
		}
	}

	static void dispatchGaEvents(){
		// Manually dispatch any queued hits.
		if(!AniwaysPrivateConfig.getInstance().isGoogleAnalyticsDisabled()){
			GAServiceManager.getInstance().dispatchLocalHits();
		}
	}

	public static void forceInit(Context applicationContext) {
		String googleAnalyticsId = AniwaysPrivateConfig.getInstance().googleAnalyticsId;
		
		Log.i(TAG, "Calling init of GoogleAnalyticsReporter. New google analytics id is: " + googleAnalyticsId);

		// Get the GoogleAnalytics singleton. Note that the SDK uses
		// the application context to avoid leaking the current context.
		GoogleAnalytics gaInstance = GoogleAnalytics.getInstance(applicationContext);
		// Set dispatch period to 10 seconds.
		GAServiceManager.getInstance().setLocalDispatchPeriod(AniwaysPrivateConfig.getInstance().gaDispatchPeriod);
		gaInstance.getLogger().setLogLevel(getLogLevel());

		// Use the GoogleAnalytics singleton to get a Tracker.
		sGaTracker = gaInstance.getTracker(googleAnalyticsId);

		// Set the SDK version and app version
		PackageManager manager = applicationContext.getPackageManager();
		PackageInfo info = null;
		try {
			info = manager.getPackageInfo(applicationContext.getPackageName(), 0);
		} catch (NameNotFoundException e) {
			Log.e(true, TAG, "Could not get package name", e);
		}

		reportNewSession();
		int versionCode = info == null ? 0 : info.versionCode;
		String versionName = info == null ? "Unknown" : info.versionName;
		reportCustomDimention(1, String.format(Locale.US, "%sX%sX%d", AniwaysServiceUtils.SDK_VERSION, versionName, versionCode));
		reportCustomDimention(2, String.format(Locale.US, "%s", AniwaysServiceUtils.SDK_VERSION));
		reportCustomDimention(3, String.format(Locale.US, "%d", versionCode));
		reportCustomDimention(6, AniwaysPrivateConfig.getInstance().version + "x" + AniwaysPrivateConfig.getInstance().versionName);
		reportCustomDimention(7, AniwaysPrivateConfig.getInstance().appId);

		dispatchGaEvents();
	}

    private static aniways.com.google.analytics.tracking.android.Logger.LogLevel getLogLevel() {
        return AniwaysPrivateConfig.getInstance().gaDebug
                ? Logger.LogLevel.VERBOSE
                : aniways.com.google.analytics.tracking.android.Logger.LogLevel.WARNING;
        //from some reason no DEBUG value is found in the enum
    }


    static boolean isInitialized(){
		return sGaTracker != null;
	}

	public static void reportCustomDimention(int index, String value) {
		if(AniwaysPrivateConfig.getInstance().isGoogleAnalyticsDisabled()){
			return;
		}
		sGaTracker.send(MapBuilder
                .createAppView()
                .set(Fields.customDimension(index), value).build());
	}

	public static void onConfigChange(AniwaysPrivateConfig newConfig, Context context) {
		forceInit(context);
	}

}
