package com.aniways.analytics;

import android.util.Log;



public class ErrorReporter {
	
	private static final String TAG = "AniwaysErrorReporter";
	private static Reporter internalReporter;

	public static void notify(String tag, String message, Throwable error) {
		if(internalReporter == null){
			Log.e(TAG, "Trying to send error report with no repoter defined");
		}else{
			internalReporter.notify(tag, message, error);
		}
	}
	
	public static Reporter getReporter(){
		return internalReporter;
	}

	public static void setReporter(Reporter reporter) {
		internalReporter = reporter; 
	}

}
