package com.aniways;

import java.util.ArrayList;
import java.util.List;

import android.view.View;
import android.view.ViewGroup;

import com.aniways.AniwaysVerticalLinearLayout.LayoutTraverser;

final public class ViewUtils {
	private ViewUtils() {}

	public static <T> List<T> find(ViewGroup root, Class<T> type) {
		FinderByType<T> finderByType = new FinderByType<T>(type);
		LayoutTraverser.build(finderByType).traverse(root, true);
		return finderByType.getViews();
	}

	private static class FinderByType<T> implements LayoutTraverser.Processor {
		private final Class<T> type;
		private final List<T> views;

		private FinderByType(Class<T> type) {
			this.type = type;
			views = new ArrayList<T>();
		}

		@Override
		@SuppressWarnings("unchecked")
		public void process(View view) {
			if (type.isInstance(view)) {
				views.add((T) view);
			}
		}

		public List<T> getViews() {
			return views;
		}
	}
	
	public static int getRelativeLeftToViewRoot(View myView) {
	    if (myView.getParent() == myView.getRootView())
	        return myView.getLeft();
	    else
	        return myView.getLeft() + getRelativeLeftToViewRoot((View) myView.getParent());
	}
	
	public static int getRelativeTopToViewRoot(View myView) {
	    if (myView.getParent() == myView.getRootView())
	        return myView.getTop();
	    else
	        return myView.getTop() + getRelativeTopToViewRoot((View) myView.getParent());
	}
}