/**
 * 
 */
package com.aniways;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;

/**
 * @author Shai
 *
 */
@SuppressLint("InlinedApi")
public class Utils {

	private static final String TAG = "AniwaysUtils";

	// returns true if current Android OS on device is >= verCode 
	public static boolean isAndroidVersionAtLeast(int verCode) {
		if (android.os.Build.VERSION.RELEASE.startsWith("1.0"))
			return verCode == 1;
		else if (android.os.Build.VERSION.RELEASE.startsWith("1.1")) {
			return verCode <= 2;
		} else if (android.os.Build.VERSION.RELEASE.startsWith("1.5")) {
			return verCode <= 3;
		} else {
			// TODO: in some phones this var is always 0 because they have a non standard android OS.
			// --> need to continue with the trick above of parsing the release string
			return android.os.Build.VERSION.SDK_INT >= verCode;
		}
	}

	/*
	public static String removeExtention(String name){
		final int lastPeriodPos = name.lastIndexOf('.');
		if (lastPeriodPos <= 0)
		{
			// No period after first character - return name as it was passed in
			return name;
		}
		else
		{
			// Remove the last period and everything after it
			return name.substring(0, lastPeriodPos);
		}
	}
	 */

	// Gets start and end and sets start to the minimum of the 2 and end to the maximum 
	// (if any value is less then zero then it is converted to zero)
	public static int setMaxMinStartEnd(int[] startEnd){
		if (startEnd.length != 2){
			throw new IllegalArgumentException("startEnd doesn't contain 2 ints");
		}
		int start = startEnd[0];
		int end = startEnd[1];
		int min = Math.max(0, Math.min(start, end));
		int max = Math.max(0, Math.max(start, end));
		start = min;
		end = max;
		startEnd[0] = start;
		startEnd[1] = end;
		int length = end - start;
		return length;
	}

	// TODO: use this across the application
	@SuppressLint("NewApi")
	public static boolean isStringEmpty(String string){
		if (Utils.isAndroidVersionAtLeast(9)){
			return string.isEmpty();
		}
		else{
			// TODO: not sure this is the best implementation. Consider: string.equalsIgnoreCase("");
			return string.length() == 0;
		}
	}

	//TODO: go over code and use it
	/**
	 * @param spannable
	 * @param start
	 * @param end
	 * @param span
	 * @return
	 */
	public static boolean isSpanAdjacentToRange(Spannable spannable, int start, int end, Object span) {
		boolean spanIsAdjacent;
		int spanStart = spannable.getSpanStart(span);
		int spanEnd = spannable.getSpanEnd(span);
		spanIsAdjacent = (spanEnd == start || spanStart == end);
		return spanIsAdjacent;
	}

	public static byte[] serializeObject(Object o) { 
		ByteArrayOutputStream bos = new ByteArrayOutputStream(); 

		try { 
			ObjectOutput out = new ObjectOutputStream(bos); 
			out.writeObject(o); 
			out.close(); 

			// Get the bytes of the serialized object 
			byte[] buf = bos.toByteArray(); 

			return buf; 
		} catch(IOException ioe) { 
			Log.e(true, TAG, "error", ioe); 

			return null; 
		} 
	} 

	public static Object deserializeObject(byte[] b) { 
		try { 
			ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(b)); 
			Object object = in.readObject(); 
			in.close(); 

			return object; 
		} catch(ClassNotFoundException cnfe) { 
			Log.e(true, TAG, "class not found error", cnfe); 

			return null; 
		} catch(IOException ioe) { 
			Log.e(true, TAG, "io error", ioe); 

			return null; 
		} 
	}

	public static int getScreenOrientation(Context context)
	{
		WindowManager windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
		Display getOrient = windowManager.getDefaultDisplay();
		int orientation = Configuration.ORIENTATION_UNDEFINED;
		if(getOrient.getWidth()==getOrient.getHeight()){
			orientation = Configuration.ORIENTATION_SQUARE;
		} else{ 
			if(getOrient.getWidth() < getOrient.getHeight()){
				orientation = Configuration.ORIENTATION_PORTRAIT;
			}else { 
				orientation = Configuration.ORIENTATION_LANDSCAPE;
			}
		}
		return orientation;
	}

	// Get the type of connection with Internet, or null
	public static String isInternetAvailable(Context context){
		if(PackageManager.PERMISSION_GRANTED != context.checkCallingOrSelfPermission(Manifest.permission.ACCESS_NETWORK_STATE)){
			Log.e(false, TAG, "ACCESS_NETWORK_STATE permission not granted");
			return null;
		}
		ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
		NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
		if (activeNetworkInfo != null && activeNetworkInfo.isConnected()){
			Log.i(TAG, "There is NW connectivity. Interface is: " + activeNetworkInfo.getTypeName());
			int responseCode = 0;
			try {
				HttpURLConnection urlc = (HttpURLConnection) (new URL("http://www.google.com").openConnection());
				urlc.setRequestProperty("User-Agent", "Test");
				urlc.setRequestProperty("Connection", "close");
				urlc.setConnectTimeout(1500); 
				urlc.connect();
				responseCode = urlc.getResponseCode();
				if (responseCode == 200){
					return activeNetworkInfo.getTypeName();
				}
				else{
					Log.i(TAG, "Error checking internet connection. Response from Google is: " + responseCode);
				}
			} catch (IOException e) {
				Log.i(TAG, "Error checking internet connection: " + e.getMessage());
			}
		}
		else{
			Log.i(TAG, "There is no Network connectivity");
		}
		return null;
	}

	/**
	 *Result is:
	 * 1 - A bigger than B
	 * 0 - Both are equal
	 * -1 B bigger than A
	 * 
	 * @param verA
	 * @param verB
	 * @return
	 */
	// Depth is where is the difference - 0 is the major version, and so on..
	public static VersionComparisonResult compareVersionStrings(String verA, String verB){
		if(verA == null || verB == null || Utils.isStringEmpty(verA) || Utils.isStringEmpty(verB)){
			IllegalArgumentException e = new IllegalArgumentException("One on the version strings is null or empty. verA: " + verA + " VerB: " + verB);
			Log.e(true, TAG, "Throwing Exception in compareVersionStrings: ", e);
			throw e;
		}
		
		try{
			double a = Double.parseDouble(verA);
			double b = Double.parseDouble(verB);
			if(a > b){
				return new VersionComparisonResult(1);
			}
			if(a < b){
				return new VersionComparisonResult(-1);
			}
			return new VersionComparisonResult(0);
		}
		catch(NumberFormatException ex){
			IllegalArgumentException newE = new IllegalArgumentException("One on the version strings cannot be converted to double. A: " + verA + ". B:" + verB);
			Log.e(true, TAG, "Throwing Exception in compareVersionStrings: ", newE);
			throw newE;
		}
		
		/*
		String[] verAParts = verA.split("\\.");
		String[] verBParts = verB.split("\\.");
		int maxLength = Math.max(verAParts.length, verBParts.length);
		int verAPartsLength = verAParts.length;
		int verBPartsLength = verBParts.length;

		for(int i = 0; i < maxLength; i++){
			long a = 0;
			long b = 0;
			if(i < verAPartsLength){
				a = getIntFromVersionPart(verAParts[i]);
			}
			if(i < verBPartsLength){
				b = getIntFromVersionPart(verBParts[i]);
			}

			if(a > b){
				return new VersionComparisonResult(1);
			}
			if(a < b){
				return new VersionComparisonResult(-1);
			}
		}


		return new VersionComparisonResult(0);
		*/
	}

	/**
	 * @param verA
	 * @param verB
	 * @param verParts
	 * @param i
	 */
	/*
	private static long getIntFromVersionPart(String part) {
		long result = 0;
		try{
			result = Long.parseLong(part);
		}
		catch(NumberFormatException e){
			IllegalArgumentException newE = new IllegalArgumentException("One on the version strings contains a part which cannot be converted to int " + part, e);
			Log.e(true, TAG, "Throwing Exception in compareVersionStrings: ", newE);
			throw newE;
		}
		return result;
	}
	*/

	// Returns the flags such that the shared preferences could be read across processes.
	public static int getSharedPreferencesFlags() {
		int flags = Context.MODE_PRIVATE;
		if (Utils.isAndroidVersionAtLeast(11)){
			flags |= Context.MODE_MULTI_PROCESS;
		}
		return flags;
	}

	public static boolean isGetter(Method method){
		if(!method.getName().startsWith("get"))      return false;
		if(method.getParameterTypes().length != 0)   return false;  
		if(void.class.equals(method.getReturnType())) return false;
		return true;
	}

	public static boolean isSetter(Method method){
		if(!method.getName().startsWith("set")) return false;
		if(method.getParameterTypes().length != 1) return false;
		return true;
	}

	public static String[] concatStringArrays(String[] A, String[] B) {
		int aLen = A.length;
		int bLen = B.length;
		String[] C= new String[aLen+bLen];
		System.arraycopy(A, 0, C, 0, aLen);
		System.arraycopy(B, 0, C, aLen, bLen);
		return C;
	}

	public static <T> T[] concatenateArrays (T[] A, T[] B) {
		int aLen = A.length;
		int bLen = B.length;

		@SuppressWarnings("unchecked")
		T[] C = (T[]) Array.newInstance(A.getClass().getComponentType(), aLen+bLen);
		System.arraycopy(A, 0, C, 0, aLen);
		System.arraycopy(B, 0, C, aLen, bLen);

		return C;
	}

	public static boolean isVersionLegal(String expectedVersion) {
		if(TextUtils.isEmpty(expectedVersion)){
			return false;
		}
		try{
			Double.parseDouble(expectedVersion);
		}
		catch(Throwable ex){
			return false;
		}
		return true;
	}

}



