/**
 * 
 */
package com.aniways;

import java.util.Comparator;

import android.text.Spannable;

/**
 * @author Shai
 *
 */
class SpanStartSorter<T> implements Comparator<T>
{
	private Spannable mHolder;
	public SpanStartSorter(Spannable holder){
		mHolder = holder;
	}

	@Override
	public int compare(T lhs, T rhs) {
		int lhsStart = mHolder.getSpanStart(lhs);
		int rhsStart = mHolder.getSpanStart(rhs);
		if(lhsStart > rhsStart) return 1;
		else if(lhsStart < rhsStart) return -1;
		else return 0;
	}
}
