package com.aniways;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.ui.AniwaysUiUtil;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.PorterDuff.Mode;
import android.graphics.PorterDuffXfermode;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.Window;
import android.view.GestureDetector.SimpleOnGestureListener;
import android.widget.RelativeLayout;

public class AniwaysTutorialView extends RelativeLayout {
	private static final String TAG = "AniwaysTutorialView";
	private Context mContext;
	private RectF mHighlightEllipse;
	private Paint mPaint;
	private PorterDuffXfermode mPorterDuffXfermode;
	private GestureDetector mGestureDetector;
	private onTutorialWindowSingleTapConfirmed mOnTutorialWindowSingleTapConfirmedCallback;
	private Rect mScreenRect;
	private RectF mDropDownRect;

	public AniwaysTutorialView(Context context) {
		super(context);
		mContext = context;
		init();
	}

	public AniwaysTutorialView(Context context, AttributeSet attrs) {
		super(context, attrs);
		mContext = context;
		init();
	}

	public AniwaysTutorialView(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		mContext = context;
		init();
	}
	
	public boolean isNimbuzz(){
		Context context = this.getContext();
		PackageManager pm = context.getPackageManager();
		String packageName = "";
		if(pm != null){
			packageName = context.getPackageName();
		}
		Log.d(TAG, "Package name: " + packageName);
		return packageName.startsWith("com.nimbuzz");
	}

	@Override
	protected void onDraw(Canvas canvas) {
		try{
			super.onDraw(canvas);

			mPaint.setAntiAlias(true);
			canvas.drawARGB(0, 0, 0, 0);
			mPaint.setColor(Color.TRANSPARENT);
			mPaint.setXfermode(mPorterDuffXfermode);

			canvas.drawOval(mHighlightEllipse, mPaint);

			// If Nimbuzz mode then make their dropdown menu button highlighted too
			if(isNimbuzz()){
				Log.d(TAG, "Highlighting dropdown menu");
				int highlightWidth = AniwaysUiUtil.convertDipsToPixels(40);
				int verticalMargin = AniwaysUiUtil.convertDipsToPixels(5);
				int horizontalMargin = AniwaysUiUtil.convertDipsToPixels(3);
				int highlightHeight = highlightWidth;
				Window window = ((Activity) getContext()).getWindow();
				window.getDecorView().getWindowVisibleDisplayFrame(mScreenRect);

				int screenWidth = mScreenRect.right;

				mDropDownRect.left = screenWidth - highlightWidth - horizontalMargin;
				mDropDownRect.top = verticalMargin;
				mDropDownRect.right = screenWidth - horizontalMargin;
				mDropDownRect.bottom = verticalMargin + highlightHeight;

				canvas.drawOval(mDropDownRect, mPaint);
			}

		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in onDraw", ex);
		}
	}

	private void init() {
		mPaint = new Paint();
		mPorterDuffXfermode = new PorterDuffXfermode(Mode.CLEAR);
		mHighlightEllipse = new RectF();
		mGestureDetector = new GestureDetector(mContext, new TutorialViewGestureListener());
		mScreenRect = new Rect();
		mDropDownRect = new RectF();
	}

	public void setHighlightEllipseValues(Rect rect) {
		mHighlightEllipse.set(rect);
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		try{
			return (mGestureDetector.onTouchEvent(event) || super.onTouchEvent(event));
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in onTouchEvent", ex);
			return true;
		}
	}

	public void setOnTutorialWindowSingleTapConfirmed(onTutorialWindowSingleTapConfirmed listener) {
		mOnTutorialWindowSingleTapConfirmedCallback = listener;
	}

	public interface onTutorialWindowSingleTapConfirmed {
		public boolean tutorialWindowSingleTapConfirmed(boolean onHighlightedArea);
	}

	class TutorialViewGestureListener extends SimpleOnGestureListener {
		@Override
		public boolean onSingleTapConfirmed(MotionEvent e) {
			try{
				if (null != mOnTutorialWindowSingleTapConfirmedCallback) {
					boolean inHighlightedArea = mHighlightEllipse.contains(e.getX(), e.getY());
					return mOnTutorialWindowSingleTapConfirmedCallback.tutorialWindowSingleTapConfirmed(inHighlightedArea);
				}
				else {
					return false;
				}
			}
			catch(Throwable ex){
				Log.e(true, TAG, "Caught Exception in onSingleTapConfirmed", ex);
				return true;
			}
		}
	}
}
