package com.aniways;

import android.text.Editable;

import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AppData;
import com.aniways.data.Phrase;
import com.aniways.data.SettingsKeys;

// not inheriting clickable span so it will not look like a link
public class AniwaysSuggestionSpan //extends ClickableSpan
{
	private static final String TAG = "AniwaysSuggestionSpan";
	public ISuggestionDisplayer suggestionDisplayer;
	public Phrase phrase;
	private long mDismissEventTIme = -2;
	public String originalText;
    public AniwaysSuggestionSpan spawninSpan;

    public AniwaysSuggestionSpan(Phrase phrase, ISuggestionDisplayer suggestionDisplayer, String originalText)
	{
		this.phrase = phrase;
		this.suggestionDisplayer = suggestionDisplayer;
		this.originalText = originalText;
	}
	
	public void onClick(long eventTime, Editable text) {
		try{
			if(mDismissEventTIme != eventTime){
                if(text.getSpanStart(this) < 0){
                    return;
                }

                if(spawninSpan != null){
                    spawninSpan.onClick(eventTime, text);
                    return;
                }

                // Update tutorial manager that a suggestion was clicked..
                AppData.incrementInt(SettingsKeys.MANUAL_TAPS_COUNT);

				suggestionDisplayer.displaySuggestions(this, AniwaysPhraseReplacementData.getDataParser(), IAniwaysImageSpan.IconSelectionOrigin.ContextualManual);
			}
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in onClick", ex);
		}
	}

	public void setDismissEventTime(long l) {
		mDismissEventTIme = l;
	}
}
