/**
 * 
 */
package com.aniways;

import java.util.List;

import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.analytics.AnalyticsReporter.ExternalDataType;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.Phrase;
import com.aniways.volley.toolbox.NetworkImageView;
import com.aniways.volley.toolbox.Volley;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

/**
 * @author Shai
 *
 */
public class AniwaysMessageListViewItemWrapperLayout extends LinearLayout {
	private static final String TAG = "AniwaysMessageListViewItemWrapperLayout";
	private ImageView mAdvertisement;
	private IAniwaysTextContainer mTextContainer;
	private OnSetTextListener mSetTextListener;
	//private long mDismissEventTime = -2;

	public AniwaysMessageListViewItemWrapperLayout(Context context)
	{
		this(context, null);
	}

	public AniwaysMessageListViewItemWrapperLayout(Context context, AttributeSet attributeSet)
	{
		super(context, attributeSet);
		if(!this.isInEditMode()){
		}
		init(context);
	}

	@SuppressLint("NewApi")
	public AniwaysMessageListViewItemWrapperLayout(Context context, AttributeSet attrs, int defStyle){
		super(context, attrs, defStyle);
		init(context);
	}

	private void init(Context context) {
		setOrientation(LinearLayout.VERTICAL);
		mSetTextListener = new OnSetTextListener(){

			@Override
			public void onSetText(CharSequence newText) {
				// Remove old advertisement if exists
				if(mAdvertisement != null){
					removeView(mAdvertisement);
					mAdvertisement = null;
					//TODO: recycle
				}
				
				// Find new phrase for advertisement (if exists)
				Phrase p = getAdvertisementPhrase(newText);
				if(p == null){
					return;
				}
				
				// Add the new advertisement
				addAdvertisement(p);
			}
		};
	}

	private void addAdvertisement(Phrase p){
		NetworkImageView advertisement = new NetworkImageView(getContext());
		
		// TODO: maybe need both to be WrapContent? and if so, then what happens if the advertisement is larger than the screen width?
		ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT); 
		// TODO: do this right, and with margin
		AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
		advertisement.setPadding(config.bannerPaddingLeft, config.bannerPaddingTop, config.bannerPaddingRight, config.bannerPaddingBottom);
		// Calling super intentionally to not get the logic in our overriden methods
		super.addView(advertisement, params);
		final IconData icon = p.emoticonsPhraseAssetBuilder.icons[0];
		//TODO: How to choose if there is more than 1 icon?
		advertisement.setImageUrl(config.getIconUrl(icon, false, true), icon, Volley.getImageLoader(), config.bannerHeight, config.bannerHeight, true);
		
		// Set up the icon to be clickable if needed
		if(icon.hasExternalData()){

			advertisement.setOnClickListener(new OnClickListener(){

				@Override
				public void onClick(View v) {
					try{
						// TODO: add commented out back
						if(true/*mDismissEventTime != clickEventTime*/){
							String externalActivityPackage = icon.getExternalActivityPackage();
							String externalWebsite = icon.getExternalWebsite();
							Context context = getContext();
							if(!TextUtils.isEmpty(externalActivityPackage)){
								Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(externalActivityPackage);
								if(launchIntent != null){
									Log.i(TAG, "Starting external application: " + externalActivityPackage);
									GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application", externalActivityPackage, icon.getFileName(), 0);
									AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{icon}, AniwaysStoreManager.isIconUnlocked(icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, externalActivityPackage, ExternalDataType.openApp, IAniwaysImageSpan.ImageSpanMetadata.Empty);
									context.startActivity(launchIntent);
								} else {
									try {
										Log.i(TAG, "External application package " + externalActivityPackage + " not found, trying to start google market");
										GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application on Google market", externalActivityPackage, icon.getFileName(), 0);
										AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{icon}, AniwaysStoreManager.isIconUnlocked(icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mExternalActivityPackage", ExternalDataType.openGooglePlay, IAniwaysImageSpan.ImageSpanMetadata.Empty);
										context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + externalActivityPackage)));
									} catch (android.content.ActivityNotFoundException anfe) {
										Log.i(TAG, "Google market not found on device starting browser, openApp: " + externalActivityPackage);
										GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application on browser", externalActivityPackage, icon.getFileName(), 0);
										AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{icon}, AniwaysStoreManager.isIconUnlocked(icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, "Browser:" + externalActivityPackage, ExternalDataType.openGooglePlayBrowser, IAniwaysImageSpan.ImageSpanMetadata.Empty);
										context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + externalActivityPackage)));
									}
								}
							} else if(!TextUtils.isEmpty(externalWebsite)){
								Intent i = new Intent(Intent.ACTION_VIEW);
								i.setData(Uri.parse(externalWebsite));
								Log.i(TAG, "Starting browser with url: " + externalWebsite);
								GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External link", externalWebsite, icon.getFileName(), 0);
								AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{icon}, AniwaysStoreManager.isIconUnlocked(icon), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, externalWebsite, ExternalDataType.openWebsiteInBrowser, IAniwaysImageSpan.ImageSpanMetadata.Empty);
								
								context.startActivity(i);

							}
						} 
					}
					catch(Throwable ex){
						// TODO: fix this!!
						Log.e(true, TAG, "Caught exception in onClick", ex);
					}
					
				}
				
			});
		}
		
		mAdvertisement = advertisement;
	}

	@Override
	public void addView(View child, int index, ViewGroup.LayoutParams params){
		//TODO: Are there other add view methods that need to be overridern?
		
		// If the child should go last, then put it last before the advertisement
		if(mAdvertisement != null){
			int numChildren = this.getChildCount();
			if(index == numChildren || index < 0){
				index = numChildren - 1;
			}
		}

		super.addView(child, index, params);

		if(child instanceof IAniwaysTextContainer){
			this.registerForTextChangeInTextView();
		}
	}

	@Override
	public void removeView(View view){
		// TODO: There are other methods that need to be overriden and unregister the text listener for
		super.removeView(view);

		onRemoveView(view);
	}

	//TODO: deal with remove view as well (if removing the textView then need to set the member null advertisement

	private void onRemoveView(View view) {
		if(view == this.mTextContainer.getView()){
			unregisterSetTextListener();
			
			// In case there is some other view that now takes precedence
			registerForTextChangeInTextView();
		}
	}

	IAniwaysTextContainer getAniwaysTextContainer(){
		if(mTextContainer != null){
			return mTextContainer;
		}

		List<IAniwaysTextContainer> textContainers = ViewUtils.find(this, IAniwaysTextContainer.class);

		if(textContainers == null || textContainers.isEmpty()){
			return null;
		}

		//TODO: What if we have more than 1?..
		mTextContainer = textContainers.get(0);

		return mTextContainer;
	}

	@Override
	protected void onFinishInflate() {
		super.onFinishInflate();

		//TODO: Maybe want to find the textView here..

		Log.i(TAG, "Finished inflating");

		if(this.isInEditMode()){
			return;
		}

	}

	@Override
	protected void onAttachedToWindow() {
		super.onAttachedToWindow();
		// Find the textView and listen to its onSetText (done here in case this layout was not inflated, but constructed by code, or
		// the call after the inflate finish did not succeed (if some elements were added by code after inflate)..

		if(this.isInEditMode()){
			return;
		}

		registerForTextChangeInTextView();
	}

	private void registerForTextChangeInTextView() {
		IAniwaysTextContainer textContainer = getAniwaysTextContainer();
		if(textContainer == null){
			return;
		}

		textContainer.registerSetTextListener(mSetTextListener);
	}

	private void unregisterSetTextListener(){
		if(this.mTextContainer == null){
			return;
		}
		mTextContainer.unregisterSetTextListener(this.mSetTextListener);
	}

	private Phrase getAdvertisementPhrase(CharSequence text){
		return AniwaysCommercialPhraseMatcher.getInstance().isMatch(text.toString());
	}

	public interface OnSetTextListener{
		void onSetText(CharSequence newText);
	}

}
