/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import pl.droidsonroids.gif.GifIOException;

final class GifInfoHandle {
    private volatile long gifInfoPtr;
    final int width;
    final int height;
    final int imageCount;

    GifInfoHandle(long gifInfoPtr, int width, int height, int imageCount) {
        this.gifInfoPtr = gifInfoPtr;
        this.width = width;
        this.height = height;
        this.imageCount = imageCount;
    }

    private static native long renderFrame(Bitmap var0, long var1);

    static native GifInfoHandle openFd(FileDescriptor var0, long var1, boolean var3) throws GifIOException;

    static native GifInfoHandle openByteArray(byte[] var0, boolean var1) throws GifIOException;

    static native GifInfoHandle openDirectByteBuffer(ByteBuffer var0, boolean var1) throws GifIOException;

    static native GifInfoHandle openStream(InputStream var0, boolean var1) throws GifIOException;

    static native GifInfoHandle openFile(String var0, boolean var1) throws GifIOException;

    private static native void free(long var0);

    private static native void reset(long var0);

    private static native void setSpeedFactor(long var0, float var2);

    private static native String getComment(long var0);

    private static native int getLoopCount(long var0);

    private static native int getDuration(long var0);

    private static native int getCurrentPosition(long var0);

    private static native void seekToTime(long var0, int var2, Bitmap var3);

    private static native void seekToFrame(long var0, int var2, Bitmap var3);

    private static native void saveRemainder(long var0);

    private static native void restoreRemainder(long var0);

    private static native long getAllocationByteCount(long var0);

    private static native int getNativeErrorCode(long var0);

    static GifInfoHandle openMarkableInputStream(InputStream stream, boolean justDecodeMetaData) throws GifIOException {
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("InputStream does not support marking");
        }
        return GifInfoHandle.openStream(stream, justDecodeMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GifInfoHandle openAssetFileDescriptor(AssetFileDescriptor afd, boolean justDecodeMetaData) throws IOException {
        try {
            GifInfoHandle gifInfoHandle = GifInfoHandle.openFd(afd.getFileDescriptor(), afd.getStartOffset(), justDecodeMetaData);
            return gifInfoHandle;
        }
        finally {
            afd.close();
        }
    }

    synchronized long renderFrame(Bitmap buffer) {
        return GifInfoHandle.renderFrame(buffer, this.gifInfoPtr);
    }

    synchronized void recycle() {
        GifInfoHandle.free(this.gifInfoPtr);
        this.gifInfoPtr = 0L;
    }

    synchronized void restoreRemainder() {
        GifInfoHandle.restoreRemainder(this.gifInfoPtr);
    }

    synchronized void reset() {
        GifInfoHandle.reset(this.gifInfoPtr);
    }

    synchronized void saveRemainder() {
        GifInfoHandle.saveRemainder(this.gifInfoPtr);
    }

    synchronized String getComment() {
        return GifInfoHandle.getComment(this.gifInfoPtr);
    }

    synchronized int getLoopCount() {
        return GifInfoHandle.getLoopCount(this.gifInfoPtr);
    }

    synchronized int getNativeErrorCode() {
        return GifInfoHandle.getNativeErrorCode(this.gifInfoPtr);
    }

    synchronized void setSpeedFactor(float factor) {
        GifInfoHandle.setSpeedFactor(this.gifInfoPtr, factor);
    }

    synchronized int getDuration() {
        return GifInfoHandle.getDuration(this.gifInfoPtr);
    }

    synchronized int getCurrentPosition() {
        return GifInfoHandle.getCurrentPosition(this.gifInfoPtr);
    }

    synchronized void seekToTime(int position, Bitmap buffer) {
        GifInfoHandle.seekToTime(this.gifInfoPtr, position, buffer);
    }

    synchronized void seekToFrame(int frameIndex, Bitmap buffer) {
        GifInfoHandle.seekToFrame(this.gifInfoPtr, frameIndex, buffer);
    }

    synchronized long getAllocationByteCount() {
        return GifInfoHandle.getAllocationByteCount(this.gifInfoPtr);
    }

    synchronized boolean isRecycled() {
        return this.gifInfoPtr == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.recycle();
        }
        finally {
            super.finalize();
        }
    }

    static {
        System.loadLibrary("gif");
    }
}

