/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.volley.toolbox;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import com.aniways.AniwaysBitmapDecodeUtils;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.volley.toolbox.AniwaysImageUtil;
import com.aniways.volley.toolbox.ImageLoader;
import java.io.InputStream;

public class AniwaysLruImageCache
extends LruCache<String, Object>
implements ImageLoader.ImageCache {
    private static final String ANIWAYS_ICON_NAME_PREFIX = "aniways_ic_id_";
    private static final String TAG = "AniwaysLruImageCache";
    private Context mContext;

    public static int getDefaultLruCacheSize() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 8;
        return cacheSize;
    }

    public AniwaysLruImageCache(Context context) {
        this(AniwaysLruImageCache.getDefaultLruCacheSize());
        this.mContext = context;
    }

    public AniwaysLruImageCache(int sizeInKiloBytes) {
        super(sizeInKiloBytes);
    }

    protected int sizeOf(String key, Object value) {
        if (AniwaysImageUtil.isGif(key)) {
            byte[] imageGif = (byte[])value;
            return imageGif.length / 1024;
        }
        Bitmap bitmapValue = (Bitmap)value;
        return bitmapValue.getRowBytes() * bitmapValue.getHeight() / 1024;
    }

    @Override
    public Object getBitmap(String url, int maxWidth, int maxHeight) {
        Object imageData = this.get(url);
        if (imageData == null && AniwaysPrivateConfig.getInstance().usePreInstalledIcons) {
            String imageName = url.substring(url.lastIndexOf(47) + 1);
            String packageName = this.mContext.getPackageName();
            if (packageName == null) {
                Log.e(true, TAG, "package Name is null");
            } else {
                int id2 = this.mContext.getResources().getIdentifier(ANIWAYS_ICON_NAME_PREFIX + imageName.replace(".png", ""), "raw", packageName);
                if (id2 > 0) {
                    Log.v(TAG, "Fetching image from preInstalled icons");
                    try {
                        InputStream stream = this.mContext.getResources().openRawResource(id2);
                        if (Utils.isAndroidVersionAtLeast(20)) {
                            InputStream stream2 = this.mContext.getResources().openRawResource(id2);
                            imageData = AniwaysBitmapDecodeUtils.decodeBitmapFromStream(stream, stream2, maxWidth, maxHeight, imageName, false);
                        } else {
                            imageData = AniwaysBitmapDecodeUtils.decodeBitmapFromStream(stream, maxWidth, maxHeight, imageName, false);
                        }
                        if (imageData == null) {
                            Log.w(false, TAG, "Bitmap is null: " + imageName);
                            return null;
                        }
                        Log.v(TAG, "Decoded pre-installed bitmap: " + imageName);
                        this.putBitmap(url, imageData);
                    }
                    catch (Resources.NotFoundException ex) {
                        Log.w(true, TAG, "Icon file doesn't exist in preInstalled images: " + imageName);
                        return null;
                    }
                    catch (OutOfMemoryError ex) {
                        System.gc();
                        Log.e(true, TAG, "Could not create bitmap because not enough memory: " + imageName);
                        return null;
                    }
                    catch (Throwable ex) {
                        Log.w(true, TAG, "Caught Exception while getting bitmap: " + ex);
                        return null;
                    }
                }
            }
        }
        return imageData;
    }

    @Override
    public void putBitmap(String url, Object bitmap) {
        if (AniwaysPrivateConfig.getInstance().isLowMemoryDevice()) {
            return;
        }
        this.put(url, bitmap);
    }
}

