/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.ui.views;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.aniways.R;
import com.aniways.contextual.ContextualPopup;
import com.aniways.data.AniwaysStatics;
import com.aniways.nineoldandroids.view.ViewHelper;
import com.aniways.settings.AniwaysSettingsActivity;

public class ContextualSettingsView
extends LinearLayout {
    private int parallaxMaxPadding;
    private int cardBaseColor;
    private int revealWidth;
    private View settingsCardContent;
    private View settingsCardHolder;

    public ContextualSettingsView(Context context) {
        super(context);
    }

    public ContextualSettingsView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        Resources res = this.getResources();
        this.cardBaseColor = res.getColor(R.color.aniways_contextual_asset_card_background_color);
        this.parallaxMaxPadding = (int)res.getDimension(R.dimen.aniways_contextual_card_setting_padding);
        this.settingsCardContent = this.findViewById(R.id.aniways_contextual_settings_view);
        this.settingsCardHolder = this.findViewById(R.id.aniways_contextual_settings_card_holder);
        this.revealWidth = (int)res.getDimension(R.dimen.aniways_contextual_card_reveal_width);
        View icon = this.findViewById(R.id.aniways_contextual_settings_card_icon);
        View text = this.findViewById(R.id.aniways_contextual_settings_card_title);
        ViewHelper.setAlpha(icon, 0.3f);
        ViewHelper.setAlpha(text, 0.3f);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ContextualPopup.dismissAllOpenPopups();
                Intent settingsIntent = new Intent(ContextualSettingsView.this.getContext(), AniwaysSettingsActivity.class);
                settingsIntent.setFlags(0x10000000);
                AniwaysStatics.getApplicationContext().startActivity(settingsIntent);
            }
        });
    }

    public void initContent(int pagerHeight) {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.settingsCardHolder.getLayoutParams();
        int cardHeight = (int)this.getResources().getDimension(R.dimen.aniways_contextual_card_min_height);
        lp.topMargin = pagerHeight - cardHeight;
        this.settingsCardHolder.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void updateByPosition(float position, int pageWidth) {
        int targetColor = ContextualSettingsView.getShadedColorByPosition(position, this.cardBaseColor);
        this.settingsCardContent.setBackgroundColor(targetColor);
        float oneOverRelativeWidth = 1.0f - (float)(this.settingsCardContent.getWidth() - this.revealWidth) / (float)pageWidth;
        if (position <= oneOverRelativeWidth) {
            this.settingsCardContent.setPadding(this.parallaxMaxPadding, 0, 0, 0);
        } else if (position < 1.0f) {
            float relativePadding = (position - oneOverRelativeWidth) / (1.0f - oneOverRelativeWidth);
            this.settingsCardContent.setPadding((int)((float)this.parallaxMaxPadding * (1.0f - relativePadding)), 0, 0, 0);
        } else {
            this.settingsCardContent.setPadding(0, 0, 0, 0);
        }
    }

    private static int getShadedColorByPosition(float position, int baseColor) {
        int retColor;
        float LightCutOff = 0.7f;
        float BrightnessStepSize = 0.12f;
        if (position <= 1.0f) {
            retColor = ContextualSettingsView.changeColorBrightness(baseColor, 0.88f);
        } else {
            int stepsDown = (int)position;
            float remainder = position % 1.0f;
            if (remainder > 0.7f) {
                remainder = 0.7f;
            }
            float ratio = 1.0f - (float)stepsDown * 0.12f - remainder / 0.7f * 0.12f;
            retColor = ContextualSettingsView.changeColorBrightness(baseColor, ratio);
        }
        return retColor;
    }

    private static int changeColorBrightness(int color2, float brightnessRatio) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = hsv[2] * brightnessRatio;
        return Color.HSVToColor((float[])hsv);
    }
}

