/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.ui.views;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.aniways.AssetType;
import com.aniways.R;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.nineoldandroids.animation.AnimatorSet;
import com.aniways.nineoldandroids.animation.ObjectAnimator;
import com.aniways.nineoldandroids.view.ViewHelper;
import com.aniways.quick.action.IAniwaysPopupView;
import com.aniways.quick.action.PhraseContextualContentViewProvider;
import com.aniways.ui.AniwaysUiUtil;
import com.aniways.ui.views.AniwaysSlidingLayer;

public class ContextualAssetView
extends LinearLayout {
    public static final float IconMaxAlpha = 0.3f;
    public int index;
    private AniwaysSlidingLayer slidingLayer;
    private View cardHolder;
    private View cardBackgroundView;
    private ImageView cardIcon;
    private RelativeLayout innerContentHolder;
    private int cardBaseColor;
    private boolean isContentOverSized;
    private int cardMinHeight;
    private int hintHeight;
    private int winkWidth;
    private View cardIconContainer;
    private int cardIconHolderWidth;
    private int cardIconHolderOverlapWidth;
    private IAniwaysPopupView content;

    public ContextualAssetView(Context context) {
        super(context);
    }

    public ContextualAssetView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        Resources res = this.getResources();
        this.cardBaseColor = res.getColor(R.color.aniways_contextual_asset_card_background_color);
        this.slidingLayer = (AniwaysSlidingLayer)this.findViewById(R.id.aniways_contextual_asset_view);
        this.cardBackgroundView = this.findViewById(R.id.aniways_contextual_card_background);
        this.cardIcon = (ImageView)this.findViewById(R.id.aniways_contextual_card_icon);
        this.cardIconContainer = this.findViewById(R.id.aniways_contextual_card_icon_container);
        this.innerContentHolder = (RelativeLayout)this.findViewById(R.id.aniways_contextual_card_content_holder);
        this.cardHolder = this.findViewById(R.id.aniways_contextual_card_holder);
        this.cardMinHeight = (int)this.getResources().getDimension(R.dimen.aniways_contextual_card_min_height);
        this.hintHeight = (int)res.getDimension(R.dimen.aniways_contextual_card_hint_height);
        this.winkWidth = (int)res.getDimension(R.dimen.aniways_contextual_card_wink_width);
        this.cardIconHolderWidth = (int)res.getDimension(R.dimen.aniways_contextual_card_icon_holder_width);
        this.cardIconHolderOverlapWidth = this.cardIconHolderWidth - (int)res.getDimension(R.dimen.aniways_contextual_card_reveal_width);
    }

    public void initContent(PhraseContextualContentViewProvider contentProvider, int pagerHeight, int index, int pageSpacerWidth, AniwaysSlidingLayer.OnInteractListener onInteractListener) {
        this.content = contentProvider.getView();
        View innerContentView = (View)this.content;
        this.setInnerContentLayoutParams(innerContentView);
        this.innerContentHolder.addView(innerContentView);
        this.slidingLayer.setOnInteractListener(onInteractListener);
        this.index = index;
        this.measureView();
        this.setCardVisibilityByIndex(index);
        int cardWidth = this.innerContentHolder.getMeasuredWidth() - pageSpacerWidth;
        this.content.initialize(cardWidth);
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.slidingLayer.getLayoutParams();
        this.cardHolder.measure(0, 0);
        int cardHeight = this.cardHolder.getMeasuredHeight();
        lp.topMargin = pagerHeight - cardHeight;
        this.slidingLayer.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.isContentOverSized = cardHeight > this.cardMinHeight + AniwaysPrivateConfig.getInstance().contextualCardHeightThreshold;
        AssetType assetType = contentProvider.getAssetType();
        switch (assetType) {
            case Emoticons: {
                this.cardIcon.setBackgroundResource(R.drawable.aniways_contextual_asset_emoticons);
                break;
            }
            case AnimatedGif: {
                this.cardIcon.setBackgroundResource(R.drawable.aniways_contextual_asset_gifs);
                break;
            }
            case Place: {
                this.cardIcon.setBackgroundResource(R.drawable.aniways_contextual_asset_locations);
            }
        }
    }

    private void setInnerContentLayoutParams(View innerContentView) {
        RelativeLayout.LayoutParams overviewParams = new RelativeLayout.LayoutParams(-2, -2);
        overviewParams.addRule(13);
        innerContentView.setLayoutParams((ViewGroup.LayoutParams)overviewParams);
    }

    private void setCardVisibilityByIndex(int index) {
        if (index == 0) {
            this.cardIconContainer.setVisibility(8);
        } else {
            this.cardIconContainer.setVisibility(0);
        }
    }

    private void measureView() {
        int screenWidth = AniwaysUiUtil.getScreenDisplayMatrix().widthPixels;
        this.measure(View.MeasureSpec.makeMeasureSpec((int)screenWidth, (int)0x40000000), 0);
    }

    public void updateByPosition(float position) {
        this.updateCardBackground(position);
        this.updateCardIcon(position);
    }

    public void wink() {
        ObjectAnimator winkAnimation = ObjectAnimator.ofFloat(this.cardHolder, "translationX", 0.0f, -this.winkWidth);
        ObjectAnimator holdAnimation = ObjectAnimator.ofFloat(this.cardHolder, "translationX", -this.winkWidth, -this.winkWidth);
        ObjectAnimator returnAnimation = ObjectAnimator.ofFloat(this.cardHolder, "translationX", -this.winkWidth, 0.0f);
        winkAnimation.setInterpolator((Interpolator)new OvershootInterpolator(3.0f));
        holdAnimation.setDuration(650L);
        returnAnimation.setInterpolator((Interpolator)new OvershootInterpolator(3.0f));
        AnimatorSet story = new AnimatorSet();
        story.play(winkAnimation).before(holdAnimation);
        story.play(holdAnimation).before(returnAnimation);
        story.start();
    }

    public void showHint() {
        if (this.isContentOverSized) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ContextualAssetView.this.slidingLayer.smoothScrollBy(0, ContextualAssetView.this.hintHeight);
                }
            }, 0L);
        }
    }

    public void hideHint() {
        if (this.isContentOverSized) {
            this.slidingLayer.closeLayer(true, true);
        }
    }

    private void updateCardBackground(float position) {
        int cardColor = ContextualAssetView.getShadedColorByPosition(position, this.cardBaseColor);
        this.cardBackgroundView.setBackgroundColor(cardColor);
        this.cardIconContainer.setBackgroundColor(cardColor);
    }

    private void updateCardIcon(float position) {
        float iconVisibilityCutOff = 1.0f - (float)this.cardIconHolderOverlapWidth / (float)this.getWidth();
        float iconHolderVisibilityCutOff = iconVisibilityCutOff - (float)this.cardIconHolderWidth / (float)this.getWidth();
        float iconHolderMotionRange = iconVisibilityCutOff - iconHolderVisibilityCutOff;
        float iconOpacity = 0.3f;
        int iconHolderWidth = this.cardIconHolderWidth;
        if (position < iconHolderVisibilityCutOff) {
            iconOpacity = 0.0f;
            iconHolderWidth = 0;
        } else if (position < iconVisibilityCutOff) {
            iconOpacity = 0.0f;
            iconHolderWidth = (int)((float)this.cardIconHolderWidth * (1.0f - (iconVisibilityCutOff - position) / iconHolderMotionRange));
        } else if (position <= 1.0f) {
            iconOpacity = 0.3f * (1.0f - (1.0f - position) / (1.0f - iconVisibilityCutOff));
        }
        ViewGroup.LayoutParams lp = this.cardIconContainer.getLayoutParams();
        lp.width = iconHolderWidth;
        this.cardIconContainer.setLayoutParams(lp);
        ViewHelper.setAlpha((View)this.cardIcon, iconOpacity);
    }

    private static int getShadedColorByPosition(float position, int baseColor) {
        int retColor;
        float LightCutOff = 0.7f;
        float BrightnessStepSize = 0.12f;
        if (position <= 0.0f) {
            retColor = baseColor;
        } else {
            int stepsDown = (int)position;
            float remainder = position % 1.0f;
            if (remainder > 0.7f) {
                remainder = 0.7f;
            }
            float ratio = 1.0f - (float)stepsDown * 0.12f - remainder / 0.7f * 0.12f;
            retColor = ContextualAssetView.changeColorBrightness(baseColor, ratio);
        }
        return retColor;
    }

    private static int changeColorBrightness(int color2, float brightnessRatio) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = hsv[2] * brightnessRatio;
        return Color.HSVToColor((float[])hsv);
    }

    public void notifyNotSelected() {
        if (this.content != null) {
            this.content.notifyNotSelected();
        }
    }

    public void notifySelected() {
        if (this.content != null) {
            this.content.notifySelected();
        }
    }

    public void notifyRevealMore() {
        if (this.content != null) {
            this.content.notifyRevealMore();
        }
    }

    public void notifyRevealLess() {
        if (this.content != null) {
            this.content.notifyRevealLess();
        }
    }
}

