/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.view.Display;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.Scroller;
import com.aniways.R;
import java.lang.reflect.Method;
import java.util.Random;

public class AniwaysSlidingLayer
extends FrameLayout {
    private static final String KEY_IS_OPEN = "is_open";
    public static final int STICK_TO_AUTO = 0;
    public static final int STICK_TO_RIGHT = -1;
    public static final int STICK_TO_LEFT = -2;
    public static final int STICK_TO_MIDDLE = -3;
    public static final int STICK_TO_TOP = -4;
    public static final int STICK_TO_BOTTOM = -5;
    private static final int MAX_SCROLLING_DURATION = 200;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final Interpolator sMenuInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (float)Math.pow(t -= 1.0f, 5.0) + 1.0f;
        }
    };
    private static final int INVALID_POINTER = -1;
    protected int mActivePointerId = -1;
    protected VelocityTracker mVelocityTracker;
    protected int mMaximumVelocity;
    private Random mRandom;
    protected Bundle mState;
    private Scroller mScroller;
    private int mShadowWidth;
    private Drawable mShadowDrawable;
    private boolean mForceLayout;
    private int mOffsetWidth;
    private boolean mDrawingCacheEnabled;
    private int mScreenSide = 0;
    private boolean closeOnTapEnabled = true;
    private boolean openOnTapEnabled = true;
    private boolean mEnabled = true;
    private boolean mSlidingFromShadowEnabled = true;
    private boolean mIsDragging;
    private boolean mIsUnableToDrag;
    private int mTouchSlop;
    private float mLastX = -1.0f;
    private float mLastY = -1.0f;
    private float mInitialX = -1.0f;
    private float mInitialY = -1.0f;
    private boolean mIsOpen;
    private boolean mScrolling;
    private OnInteractListener mOnInteractListener;
    private int mMinimumVelocity;
    private int mFlingDistance;
    private boolean mLastTouchAllowed = false;

    public AniwaysSlidingLayer(Context context) {
        this(context, null);
    }

    public AniwaysSlidingLayer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AniwaysSlidingLayer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SlidingLayer);
        this.setStickTo(ta.getInt(R.styleable.SlidingLayer_stickTo, 0));
        int shadowRes = ta.getResourceId(R.styleable.SlidingLayer_shadowDrawable, -1);
        if (shadowRes != -1) {
            this.setShadowDrawable(shadowRes);
        }
        this.setShadowWidth((int)ta.getDimension(R.styleable.SlidingLayer_shadowWidth, 0.0f));
        this.closeOnTapEnabled = ta.getBoolean(R.styleable.SlidingLayer_closeOnTapEnabled, true);
        this.openOnTapEnabled = ta.getBoolean(R.styleable.SlidingLayer_openOnTapEnabled, true);
        this.setOffsetWidth(ta.getDimensionPixelOffset(R.styleable.SlidingLayer_offsetWidth, 0));
        ta.recycle();
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sMenuInterpolator);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        float density = context.getResources().getDisplayMetrics().density;
        this.mFlingDistance = (int)(25.0f * density);
        this.mRandom = new Random();
    }

    public boolean isOpened() {
        return this.mIsOpen;
    }

    public void openLayer(boolean smoothAnim) {
        this.openLayer(smoothAnim, false);
    }

    private void openLayer(boolean smoothAnim, boolean forceOpen) {
        this.switchLayer(true, smoothAnim, forceOpen, 0, 0);
    }

    public void closeLayer(boolean smoothAnim) {
        this.closeLayer(smoothAnim, false);
    }

    public void closeLayer(boolean smoothAnim, boolean forceClose) {
        this.switchLayer(false, smoothAnim, forceClose, 0, 0);
    }

    private void switchLayer(boolean open, boolean smoothAnim, boolean forceSwitch) {
        this.switchLayer(open, smoothAnim, forceSwitch, 0, 0);
    }

    private void switchLayer(boolean open, boolean smoothAnim, boolean forceSwitch, int velocityX, int velocityY) {
        if (!forceSwitch && open == this.mIsOpen) {
            this.setDrawingCacheEnabled(false);
            return;
        }
        if (open) {
            if (this.mOnInteractListener != null) {
                this.mOnInteractListener.onOpen();
            }
        } else if (this.mOnInteractListener != null) {
            this.mOnInteractListener.onClose();
        }
        this.mIsOpen = open;
        float tx = this.mLastX - (float)(this.getWidth() / 2);
        float ty = this.mLastY - (float)(this.getHeight() / 2);
        boolean noVelocityInStickToMidle = this.mScreenSide == -3 && Math.abs(velocityX) < this.mMinimumVelocity && Math.abs(velocityY) < this.mMinimumVelocity;
        int dx = noVelocityInStickToMidle ? (int)tx : velocityX;
        int dy = noVelocityInStickToMidle ? (int)ty : velocityY;
        int[] pos = this.getDestScrollPos(dx, dy);
        if (smoothAnim) {
            this.smoothScrollTo(pos[0], pos[1], Math.max(velocityX, velocityY));
        } else {
            this.completeScroll();
            this.scrollTo(pos[0], pos[1]);
        }
    }

    public void setOnInteractListener(OnInteractListener listener) {
        this.mOnInteractListener = listener;
    }

    public void setShadowWidth(int shadowWidth) {
        this.mShadowWidth = shadowWidth;
        this.invalidate(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    }

    public void setShadowWidthRes(int resId) {
        this.setShadowWidth((int)this.getResources().getDimension(resId));
    }

    public int getShadowWidth() {
        return this.mShadowWidth;
    }

    public void setShadowDrawable(Drawable d) {
        this.mShadowDrawable = d;
        this.refreshDrawableState();
        this.setWillNotDraw(false);
        this.invalidate(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    }

    public void setShadowDrawable(int resId) {
        this.setShadowDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public void setOffsetWidth(int offsetWidth) {
        this.mOffsetWidth = offsetWidth;
        this.invalidate(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    }

    public int getOffsetWidth() {
        return this.mOffsetWidth;
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mShadowDrawable;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.mShadowDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    public boolean isSlidingEnabled() {
        return this.mEnabled;
    }

    public void setSlidingEnabled(boolean _enabled) {
        this.mEnabled = _enabled;
    }

    public boolean isSlidingFromShadowEnabled() {
        return this.mSlidingFromShadowEnabled;
    }

    public void setSlidingFromShadowEnabled(boolean _slidingShadow) {
        this.mSlidingFromShadowEnabled = _slidingShadow;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState state = new SavedState(superState);
        if (this.mState == null) {
            this.mState = new Bundle();
        }
        this.mState.putBoolean(KEY_IS_OPEN, this.isOpened());
        state.mState = this.mState;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.restoreState((Parcelable)savedState.mState);
    }

    public void restoreState(Parcelable in) {
        this.mState = (Bundle)in;
        boolean isOpened = this.mState.getBoolean(KEY_IS_OPEN);
        if (isOpened) {
            this.openLayer(true);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mEnabled) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        if (action == 3 || action == 1) {
            this.mIsDragging = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        if (action != 0) {
            if (this.mIsDragging) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (action) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
                if (pointerIndex == -1) {
                    this.mActivePointerId = -1;
                    break;
                }
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
                float dx = x - this.mLastX;
                float xDiff = Math.abs(dx);
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                float dy = y - this.mLastY;
                float yDiff = Math.abs(y - this.mLastY);
                if (xDiff > (float)this.mTouchSlop && xDiff > yDiff && this.allowDraggingX(dx, this.mInitialX)) {
                    this.mIsDragging = true;
                    this.mLastX = x;
                    this.setDrawingCacheEnabled(true);
                    break;
                }
                if (!(yDiff > (float)this.mTouchSlop) || !(yDiff > xDiff) || !this.allowDraggingY(dy, this.mInitialY)) break;
                this.mIsDragging = true;
                this.mLastY = y;
                this.setDrawingCacheEnabled(true);
                break;
            }
            case 0: {
                this.mActivePointerId = ev.getAction() & (Build.VERSION.SDK_INT >= 8 ? 65280 : 65280);
                this.mLastX = this.mInitialX = MotionEventCompat.getX((MotionEvent)ev, (int)this.mActivePointerId);
                this.mLastY = this.mInitialY = MotionEventCompat.getY((MotionEvent)ev, (int)this.mActivePointerId);
                if (this.allowSlidingFromHereX(this.mInitialX)) {
                    this.mIsDragging = false;
                    this.mIsUnableToDrag = false;
                    return super.onInterceptTouchEvent(ev);
                }
                if (this.allowSlidingFromHereY(this.mInitialY)) {
                    this.mIsDragging = false;
                    this.mIsUnableToDrag = false;
                    return super.onInterceptTouchEvent(ev);
                }
                this.mIsUnableToDrag = true;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        if (!this.mIsDragging) {
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(ev);
        }
        return this.mIsDragging;
    }

    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        if (!(this.mEnabled && (this.mIsDragging || this.mLastTouchAllowed || this.allowSlidingFromHereX(this.mInitialX) || this.allowSlidingFromHereY(this.mInitialY)))) {
            return false;
        }
        int action = ev.getAction();
        boolean bl = this.mLastTouchAllowed = action != 1 && action != 3 && action != 4;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action & 0xFF) {
            case 0: {
                this.completeScroll();
                this.mLastX = this.mInitialX = ev.getX();
                this.mLastY = this.mInitialY = ev.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                break;
            }
            case 2: {
                float leftBound;
                float topBound;
                float bottomBound;
                float rightBound;
                float x;
                if (!this.mIsDragging) {
                    int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                    if (pointerIndex == -1) {
                        this.mActivePointerId = -1;
                        break;
                    }
                    x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
                    float xDiff = Math.abs(x - this.mLastX);
                    float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                    float yDiff = Math.abs(y - this.mLastY);
                    if (xDiff > (float)this.mTouchSlop && xDiff > yDiff) {
                        this.mIsDragging = true;
                        this.mLastX = x;
                        this.setDrawingCacheEnabled(true);
                    } else if (yDiff > (float)this.mTouchSlop && yDiff > xDiff) {
                        this.mIsDragging = true;
                        this.mLastY = y;
                        this.setDrawingCacheEnabled(true);
                    }
                }
                if (!this.mIsDragging) break;
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (activePointerIndex == -1) {
                    this.mActivePointerId = -1;
                    break;
                }
                x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)activePointerIndex);
                float deltaX = this.mLastX - x;
                float deltaY = this.mLastY - y;
                this.mLastX = x;
                this.mLastY = y;
                float oldScrollX = this.getScrollX();
                float oldScrollY = this.getScrollY();
                float scrollX = oldScrollX + deltaX;
                float scrollY = oldScrollY + deltaY;
                switch (this.mScreenSide) {
                    case -2: {
                        rightBound = 0.0f;
                        bottomBound = 0.0f;
                        topBound = 0.0f;
                        leftBound = this.getWidth() - this.mOffsetWidth;
                        break;
                    }
                    case -3: {
                        topBound = this.getHeight() - this.mOffsetWidth;
                        bottomBound = this.mOffsetWidth - this.getHeight();
                        leftBound = this.getWidth() - this.mOffsetWidth;
                        rightBound = this.mOffsetWidth - this.getWidth();
                        break;
                    }
                    case -1: {
                        rightBound = this.mOffsetWidth - this.getWidth();
                        leftBound = 0.0f;
                        bottomBound = 0.0f;
                        topBound = 0.0f;
                        break;
                    }
                    case -4: {
                        topBound = this.getHeight() - this.mOffsetWidth;
                        leftBound = 0.0f;
                        rightBound = 0.0f;
                        bottomBound = 0.0f;
                        break;
                    }
                    case -5: {
                        leftBound = 0.0f;
                        rightBound = 0.0f;
                        topBound = 0.0f;
                        bottomBound = this.mOffsetWidth - this.getHeight();
                        break;
                    }
                    default: {
                        leftBound = 0.0f;
                        rightBound = 0.0f;
                        bottomBound = 0.0f;
                        topBound = 0.0f;
                    }
                }
                if (scrollX > leftBound) {
                    scrollX = leftBound;
                } else if (scrollX < rightBound) {
                    scrollX = rightBound;
                }
                if (scrollY > topBound) {
                    scrollY = topBound;
                } else if (scrollY < bottomBound) {
                    scrollY = bottomBound;
                }
                this.mLastX += scrollX - (float)((int)scrollX);
                this.mLastY += scrollY - (float)((int)scrollY);
                this.scrollTo((int)scrollX, (int)scrollY);
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    int initialVelocityX = (int)VelocityTrackerCompat.getXVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                    int initialVelocityY = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                    int scrollX = this.getScrollX();
                    int scrollY = this.getScrollY();
                    int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                    float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                    float y = MotionEventCompat.getY((MotionEvent)ev, (int)activePointerIndex);
                    int totalDeltaX = (int)(x - this.mInitialX);
                    int totalDeltaY = (int)(y - this.mInitialY);
                    boolean nextStateOpened = this.determineNextStateOpened(scrollX, scrollY, initialVelocityX, initialVelocityY, totalDeltaX, totalDeltaY);
                    this.switchLayer(nextStateOpened, true, true, initialVelocityX, initialVelocityY);
                    this.mActivePointerId = -1;
                    this.endDrag();
                    break;
                }
                if (this.mIsOpen && this.closeOnTapEnabled) {
                    this.closeLayer(true);
                    break;
                }
                if (this.mIsOpen || !this.openOnTapEnabled) break;
                this.openLayer(true);
                break;
            }
            case 3: {
                if (!this.mIsDragging) break;
                this.switchLayer(this.mIsOpen, true, true);
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastX = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                this.mLastY = MotionEventCompat.getY((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastX = MotionEventCompat.getX((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
                this.mLastY = MotionEventCompat.getY((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        if (this.mActivePointerId == -1) {
            this.mLastTouchAllowed = false;
        }
        return true;
    }

    private boolean allowSlidingFromHereX(float initialX) {
        switch (this.mScreenSide) {
            case -3: 
            case -2: 
            case -1: {
                if (this.mIsOpen) {
                    return true;
                }
                if (this.mOffsetWidth <= 0) break;
                switch (this.mScreenSide) {
                    case -2: {
                        return initialX <= (float)this.mOffsetWidth;
                    }
                    case -1: {
                        return initialX >= (float)(this.getWidth() - this.mOffsetWidth);
                    }
                }
            }
        }
        return false;
    }

    private boolean allowSlidingFromHereY(float initialY) {
        switch (this.mScreenSide) {
            case -5: 
            case -4: 
            case -3: {
                if (this.mIsOpen) {
                    return true;
                }
                if (this.mOffsetWidth <= 0) break;
                switch (this.mScreenSide) {
                    case -4: {
                        return initialY <= (float)this.mOffsetWidth;
                    }
                    case -5: {
                        return initialY >= (float)(this.getHeight() - this.mOffsetWidth);
                    }
                }
            }
        }
        return false;
    }

    private boolean allowDraggingX(float dx, float initialX) {
        if (this.mIsOpen && (float)this.getLeft() <= initialX || (float)this.getRight() >= initialX) {
            switch (this.mScreenSide) {
                case -1: {
                    return dx > 0.0f;
                }
                case -2: {
                    return dx < 0.0f;
                }
                case -3: {
                    return dx != 0.0f;
                }
            }
        }
        if (!this.mIsOpen && this.mOffsetWidth > 0 && dx > 0.0f) {
            switch (this.mScreenSide) {
                case -2: {
                    return initialX <= (float)this.mOffsetWidth && dx > 0.0f;
                }
                case -1: {
                    return initialX >= (float)(this.getWidth() - this.mOffsetWidth) && dx < 0.0f;
                }
                case -3: {
                    return dx != 0.0f;
                }
            }
        }
        return false;
    }

    private boolean allowDraggingY(float dy, float initialY) {
        if (this.mIsOpen) {
            if ((float)this.getTop() <= initialY || (float)this.getBottom() >= initialY) {
                switch (this.mScreenSide) {
                    case -5: {
                        return dy > 0.0f;
                    }
                    case -4: {
                        return dy < 0.0f;
                    }
                    case -3: {
                        return dy != 0.0f;
                    }
                }
            }
        } else if (this.mOffsetWidth > 0 || dy > 0.0f) {
            switch (this.mScreenSide) {
                case -4: {
                    return initialY <= (float)this.mOffsetWidth && dy > 0.0f;
                }
                case -5: {
                    return initialY >= (float)(this.getHeight() - this.mOffsetWidth) && dy < 0.0f;
                }
                case -3: {
                    return dy != 0.0f;
                }
            }
        }
        return false;
    }

    private boolean determineNextStateOpened(float swipeOffsetX, float swipeOffsetY, int velocityX, int velocityY, int deltaX, int deltaY) {
        boolean targetState;
        boolean calcX;
        boolean calcY;
        switch (this.mScreenSide) {
            case -5: 
            case -4: {
                calcY = true;
                calcX = false;
                break;
            }
            case -2: 
            case -1: {
                calcX = true;
                calcY = false;
                break;
            }
            case -3: {
                calcY = true;
                calcX = true;
                break;
            }
            default: {
                calcY = false;
                calcX = false;
            }
        }
        if (calcX && Math.abs(deltaX) > this.mFlingDistance && Math.abs(velocityX) > this.mMinimumVelocity) {
            targetState = this.mScreenSide == -1 && velocityX <= 0 || this.mScreenSide == -2 && velocityX > 0;
        } else if (calcY && Math.abs(deltaY) > this.mFlingDistance && Math.abs(velocityY) > this.mMinimumVelocity) {
            targetState = this.mScreenSide == -5 && velocityY <= 0 || this.mScreenSide == -4 && velocityY > 0;
        } else {
            int w = this.getWidth();
            int h = this.getHeight();
            switch (this.mScreenSide) {
                case -1: {
                    targetState = swipeOffsetX > (float)(-w / 2);
                    break;
                }
                case -5: {
                    targetState = swipeOffsetY > (float)(-h / 2);
                    break;
                }
                case -2: {
                    targetState = swipeOffsetX < (float)(w / 2);
                    break;
                }
                case -4: {
                    targetState = swipeOffsetY < (float)(h / 2);
                    break;
                }
                case -3: {
                    targetState = Math.abs(swipeOffsetX) < (float)(w / 2) && Math.abs(swipeOffsetY) < (float)(h / 2);
                    break;
                }
                default: {
                    targetState = true;
                }
            }
        }
        return targetState;
    }

    public void smoothScrollBy(int dx, int dy) {
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int targetX = sx + dx;
        int targetY = sy + dy;
        this.smoothScrollTo(targetX, targetY);
    }

    void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 0);
    }

    void smoothScrollTo(int x, int y, int velocity) {
        if (this.getChildCount() == 0) {
            this.setDrawingCacheEnabled(false);
            return;
        }
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll();
            if (this.mIsOpen) {
                if (this.mOnInteractListener != null) {
                    this.mOnInteractListener.onOpened();
                }
            } else if (this.mOnInteractListener != null) {
                this.mOnInteractListener.onClosed();
            }
            return;
        }
        this.setDrawingCacheEnabled(true);
        this.mScrolling = true;
        int width = this.getWidth();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        velocity = Math.abs(velocity);
        int duration = velocity > 0 ? 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity)) : 200;
        duration = Math.min(duration, 200);
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        this.invalidate();
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return FloatMath.sin((float)f);
    }

    private void endDrag() {
        this.mIsDragging = false;
        this.mIsUnableToDrag = false;
        this.mLastTouchAllowed = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void setDrawingCacheEnabled(boolean enabled) {
        if (this.mDrawingCacheEnabled != enabled) {
            super.setDrawingCacheEnabled(enabled);
            this.mDrawingCacheEnabled = enabled;
            int l = this.getChildCount();
            for (int i = 0; i < l; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                child.setDrawingCacheEnabled(enabled);
            }
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastX = MotionEventCompat.getX((MotionEvent)ev, (int)newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void completeScroll() {
        boolean needPopulate = this.mScrolling;
        if (needPopulate) {
            this.setDrawingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
            if (this.mIsOpen) {
                if (this.mOnInteractListener != null) {
                    this.mOnInteractListener.onOpened();
                }
            } else if (this.mOnInteractListener != null) {
                this.mOnInteractListener.onClosed();
            }
        }
        this.mScrolling = false;
    }

    public void setStickTo(int screenSide) {
        if (screenSide != 0) {
            this.mForceLayout = true;
        }
        this.mScreenSide = screenSide;
        this.closeLayer(false, true);
    }

    public void setCloseOnTapEnabled(boolean _closeOnTapEnabled) {
        this.closeOnTapEnabled = _closeOnTapEnabled;
    }

    public void setOpenOnTapEnabled(boolean _openOnTapEnabled) {
        this.openOnTapEnabled = _openOnTapEnabled;
    }

    private int getScreenSideAuto(int newLeft, int newRight) {
        int newScreenSide;
        if (this.mScreenSide == 0) {
            boolean boundToRightBorder;
            int screenWidth;
            Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
            try {
                Class<Display> cls = Display.class;
                Class[] parameterTypes = new Class[]{Point.class};
                Point parameter = new Point();
                Method method = cls.getMethod("getSize", parameterTypes);
                method.invoke((Object)display, parameter);
                screenWidth = parameter.x;
            }
            catch (Exception e) {
                screenWidth = display.getWidth();
            }
            boolean boundToLeftBorder = newLeft == 0;
            boolean bl = boundToRightBorder = newRight == screenWidth;
            newScreenSide = boundToLeftBorder == boundToRightBorder && this.getLayoutParams().width == -1 ? -3 : (boundToLeftBorder ? -2 : -1);
        } else {
            newScreenSide = this.mScreenSide;
        }
        return newScreenSide;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = AniwaysSlidingLayer.getDefaultSize((int)0, (int)widthMeasureSpec);
        int height = AniwaysSlidingLayer.getDefaultSize((int)0, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        super.onMeasure(AniwaysSlidingLayer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width), AniwaysSlidingLayer.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)height));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.completeScroll();
            int[] pos = this.getDestScrollPos();
            this.scrollTo(pos[0], pos[1]);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int screenSide = this.mScreenSide;
        if (this.mScreenSide == 0) {
            screenSide = this.getScreenSideAuto(left, right);
        }
        if (screenSide != this.mScreenSide || this.mForceLayout) {
            this.mForceLayout = false;
            this.mScreenSide = screenSide;
            if (!this.mIsOpen) {
                this.closeLayer(false, true);
            }
            if (this.mScreenSide == -1) {
                this.setPadding(this.getPaddingLeft() + this.mShadowWidth, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
            } else if (this.mScreenSide == -5) {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop() + this.mShadowWidth, this.getPaddingRight(), this.getPaddingBottom());
            } else if (this.mScreenSide == -2) {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight() + this.mShadowWidth, this.getPaddingBottom());
            } else if (this.mScreenSide == -4) {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom() + this.mShadowWidth);
            } else if (this.mScreenSide == -3) {
                this.setPadding(this.getPaddingLeft() + this.mShadowWidth, this.getPaddingTop(), this.getPaddingRight() + this.mShadowWidth, this.getPaddingBottom());
            }
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    private int[] getDestScrollPos() {
        return this.getDestScrollPos(0, 0);
    }

    private int[] getDestScrollPos(int xValue, int yValue) {
        int[] pos = new int[2];
        if (this.mIsOpen) {
            return pos;
        }
        switch (this.mScreenSide) {
            case -1: {
                pos[0] = -this.getWidth() + this.mOffsetWidth;
                break;
            }
            case -2: {
                pos[0] = this.getWidth() - this.mOffsetWidth;
                break;
            }
            case -4: {
                pos[1] = this.getHeight() - this.mOffsetWidth;
                break;
            }
            case -5: {
                pos[1] = -this.getHeight() + this.mOffsetWidth;
                break;
            }
            case -3: {
                float m = xValue == 0 && yValue == 0 ? (this.mRandom != null ? (float)Math.tan((double)this.mRandom.nextFloat() * Math.PI - 1.5707963267948966) : 1.0f) : (xValue == 0 ? (float)Math.tan(1.5707963267948966) : (float)yValue / (float)xValue);
                if (Math.abs(m) >= 1.0f) {
                    pos[0] = Math.round((float)(this.getOperationSignForDiffMeasure(xValue) * this.getHeight()) / Math.abs(m) - (this.mLastX - (float)(this.getWidth() / 2)));
                    pos[1] = Math.round(this.getOperationSignForDiffMeasure(yValue) * this.getHeight());
                    break;
                }
                pos[0] = Math.round(this.getOperationSignForDiffMeasure(xValue) * this.getWidth());
                pos[1] = Math.round((float)(this.getOperationSignForDiffMeasure(yValue) * this.getWidth()) * Math.abs(m) - (this.mLastY - (float)(this.getHeight() / 2)));
            }
        }
        return pos;
    }

    private int getOperationSignForDiffMeasure(float d) {
        if (this.mRandom == null) {
            return 1;
        }
        return Math.abs(d) < (float)this.mMinimumVelocity ? (this.mRandom.nextBoolean() ? 1 : -1) : (d > 0.0f ? -1 : 1);
    }

    public int getContentLeft() {
        return this.getLeft() + this.getPaddingLeft();
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mShadowWidth > 0 && this.mShadowDrawable != null) {
            if (this.mScreenSide == -1) {
                this.mShadowDrawable.setBounds(0, 0, this.mShadowWidth, this.getHeight());
            }
            if (this.mScreenSide == -4) {
                this.mShadowDrawable.setBounds(0, this.getHeight() - this.mShadowWidth, this.getWidth(), this.getHeight());
            }
            if (this.mScreenSide == -2) {
                this.mShadowDrawable.setBounds(this.getWidth() - this.mShadowWidth, 0, this.getWidth(), this.getHeight());
            }
            if (this.mScreenSide == -5) {
                this.mShadowDrawable.setBounds(0, 0, this.getWidth(), this.mShadowWidth);
            }
            this.mShadowDrawable.draw(canvas);
        }
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
            this.invalidate(this.getLeft() + oldX, this.getTop() + oldY, this.getRight() - oldX, this.getBottom() - oldY);
            return;
        }
        this.completeScroll();
    }

    static class SavedState
    extends View.BaseSavedState {
        Bundle mState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in) {
            super(in);
            this.mState = in.readBundle();
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeBundle(this.mState);
        }
    }

    public static interface OnInteractListener {
        public void onOpen();

        public void onClose();

        public void onOpened();

        public void onClosed();
    }
}

