/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.settings;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.SwitchPreference;
import com.aniways.Aniways;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.data.AniwaysClientConfig;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.ui.views.AniwaysSeekBarPreference;

public class AniwaysSettingsActivity
extends PreferenceActivity
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String TAG = "AniwaysSettingsActivity";
    private Preference contextualSuggestionSwitch;
    private Preference autoSuggestionSwitch;
    private AniwaysSeekBarPreference seekBarPreference;
    private String contextualSuggestionsEnableKey;
    private String autoSuggestionsEnableKey;
    private String iconSizeKey;
    private boolean iconSizeDialogAlreadyDisplayed;

    protected void onPostCreate(Bundle savedInstanceState) {
        try {
            super.onPostCreate(savedInstanceState);
            this.getPreferenceManager().setSharedPreferencesName("com.aniways.SHARED_PREFERENCES");
            this.setContentView(R.layout.aniways_settnigs_main_layout);
            this.addPreferencesFromResource(R.xml.aniways_pref);
            this.initMembers();
            this.setTheme(R.style.Base_Theme_AppCompat_Light);
        }
        catch (Exception ex) {
            Log.e(true, TAG, "Caught an Exception in onPostCreate of AniwaysSettingsActivity", ex);
        }
    }

    private void initMembers() {
        this.contextualSuggestionsEnableKey = this.getResources().getString(R.string.contextual_suggestion_key);
        this.autoSuggestionsEnableKey = this.getResources().getString(R.string.auto_suggest_key);
        this.iconSizeKey = this.getResources().getString(R.string.in_message_icon_size_key);
        this.contextualSuggestionSwitch = this.findPreference(this.contextualSuggestionsEnableKey);
        this.autoSuggestionSwitch = this.findPreference(this.autoSuggestionsEnableKey);
        this.seekBarPreference = (AniwaysSeekBarPreference)this.findPreference(this.iconSizeKey);
        this.setTitles();
        this.setValues();
    }

    private void setValues() {
        this.setSwitchMode(this.autoSuggestionSwitch, AniwaysPrivateConfig.getInstance().suggestionMode == AniwaysPrivateConfig.SuggestionMode.AutoDisplaySuggestions);
        this.setSwitchMode(this.contextualSuggestionSwitch, AniwaysPrivateConfig.getInstance().contextualIconSuggestionsEnabled);
        this.seekBarPreference.setDefaultValue(AniwaysPrivateConfig.getInstance().iconInTextViewHeight);
    }

    private void setTitles() {
        AniwaysClientConfig clientConfig = AniwaysClientConfig.getInstance();
        this.contextualSuggestionSwitch.setTitle((CharSequence)clientConfig.getResourceString("is_aniways_enabled_title"));
        this.autoSuggestionSwitch.setTitle((CharSequence)clientConfig.getResourceString("is_auto_suggest_enabled_title"));
    }

    protected void onResume() {
        try {
            super.onResume();
            this.getPreferenceManager().getSharedPreferences().registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
            this.iconSizeDialogAlreadyDisplayed = false;
        }
        catch (Exception e) {
            Log.e(true, TAG, "Caught an Exception in onResume of AniwaysSettingsActivity", e);
        }
    }

    protected void onPause() {
        try {
            super.onPause();
            this.getPreferenceManager().getSharedPreferences().unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
        catch (Exception e) {
            Log.e(true, TAG, "Caught an Exception in onPause of AniwaysSettingsActivity", e);
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (key.equals(this.contextualSuggestionsEnableKey)) {
            this.onContextualSuggestionSettingChanged();
        } else if (key.equals(this.autoSuggestionsEnableKey)) {
            this.onAutoSuggestionSettingChanged();
        } else if (key.equals(this.iconSizeKey)) {
            this.onIconSizeSettingChanged();
        }
        Log.d(TAG, "key = " + key);
    }

    private void onIconSizeSettingChanged() {
        if (this.seekBarPreference == null) {
            return;
        }
        int iconSizeInDp = this.seekBarPreference.getPersistedValue();
        Aniways.getConfiguration(this.getApplicationContext()).setIconsInTextViewSize(iconSizeInDp);
        if (!this.iconSizeDialogAlreadyDisplayed) {
            this.showChangesWillTakeEffectOnceYouLeaveAndReenterConversation();
        }
    }

    private void onAutoSuggestionSettingChanged() {
        boolean isEnabledByUser = this.getUserSelection(this.autoSuggestionSwitch);
        Aniways.getConfiguration(this.getApplicationContext()).enableAutoPopup(isEnabledByUser);
    }

    private void onContextualSuggestionSettingChanged() {
        final boolean isEnabledByUser = this.getUserSelection(this.contextualSuggestionSwitch);
        if (!isEnabledByUser) {
            this.showHowToActivateDialog(new AniwaysAction<Boolean>(){

                @Override
                public void call(Boolean isEnabledAfterDialog) {
                    Aniways.getConfiguration(AniwaysSettingsActivity.this.getApplicationContext()).enableContextualSuggestions(isEnabledByUser);
                }
            });
        } else {
            Aniways.getConfiguration(this.getApplicationContext()).enableContextualSuggestions(isEnabledByUser);
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean getUserSelection(Preference preference) {
        if (Utils.isAndroidVersionAtLeast(4)) {
            return ((SwitchPreference)preference).isChecked();
        }
        return ((CheckBoxPreference)preference).isChecked();
    }

    private void showHowToActivateDialog(final AniwaysAction<Boolean> callback) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage((CharSequence)this.getString(R.string.disable_contextual_dialog_content)).setTitle((CharSequence)this.getString(R.string.disable_contextual_dialog_title));
        builder.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                callback.call(false);
            }
        });
        builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                AniwaysSettingsActivity.this.setSwitchMode(AniwaysSettingsActivity.this.contextualSuggestionSwitch, true);
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void showChangesWillTakeEffectOnceYouLeaveAndReenterConversation() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage((CharSequence)this.getString(R.string.changes_will_take_effect_after_reentering_conversation_dialog_content)).setTitle((CharSequence)this.getString(R.string.changes_will_take_effect_after_reentering_conversation_dialog_title));
        builder.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
        this.iconSizeDialogAlreadyDisplayed = true;
    }

    @SuppressLint(value={"NewApi"})
    private void setSwitchMode(Preference switchController, boolean isChecked) {
        if (Utils.isAndroidVersionAtLeast(4)) {
            ((SwitchPreference)switchController).setChecked(isChecked);
        } else {
            ((CheckBoxPreference)switchController).setChecked(isChecked);
        }
    }
}

