/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service.helper;

import android.content.Context;
import android.content.SharedPreferences;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.data.AniwaysStorageManager;
import java.io.File;
import java.io.IOException;

public class KeywordsHelper {
    private static KeywordsHelper mInstance;
    private static final String TAG = "AniwaysKeywordsHelper";

    private KeywordsHelper() {
    }

    public static KeywordsHelper getInstance() {
        if (null == mInstance) {
            mInstance = new KeywordsHelper();
        }
        return mInstance;
    }

    public synchronized void setKeywordsVersion(Context context, String version, String eTag) {
        Log.i(TAG, "Setting Keywords version to: " + version);
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString("com.aniways.KEYWORDS_VERSION", version);
        edit.putString("com.aniways.KEYWORDS_ETAG", eTag);
        edit.commit();
    }

    public synchronized String getKeywordsVersion(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        return prefs.getString("com.aniways.KEYWORDS_VERSION", "0.0");
    }

    public synchronized String getKeywordsEtag(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        return prefs.getString("com.aniways.KEYWORDS_ETAG", "");
    }

    public synchronized boolean upadateKeywordsFile(Context context, AniwaysStorageManager storageManager) throws IOException {
        String source = storageManager.getKeywordsCacheDir().getAbsolutePath() + "/" + "keywords";
        String dest = storageManager.getKeywordsDir().getAbsolutePath() + "/" + "keywords";
        File keywordsDirFile = new File(storageManager.getKeywordsDir().getAbsolutePath());
        if (!keywordsDirFile.exists()) {
            if (!keywordsDirFile.mkdirs()) {
                throw new IOException("Could not create keywords dir: " + keywordsDirFile.getAbsolutePath());
            }
            Log.i(TAG, "Created keywords dir: " + keywordsDirFile.getAbsolutePath());
        }
        Log.i(TAG, "Copying new keywords file from " + source + " to: " + dest);
        return new File(source).renameTo(new File(dest));
    }
}

