/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service;

import android.content.Context;
import android.content.Intent;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.VersionComparisonResult;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysBackendSyncChecker;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStorageManager;
import com.aniways.service.WakefulIntentService;
import com.aniways.service.helper.ConfigHelper;
import com.aniways.service.helper.KeywordsHelper;
import com.aniways.service.task.DownloadJSONFileTask;
import com.aniways.service.utils.AniwaysServiceUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class AniwaysIntentService
extends WakefulIntentService {
    private static final String TAG = "AniwaysIntentService";

    public AniwaysIntentService() {
        super(TAG);
    }

    @Override
    protected void doWakefulWork(Intent intent) {
        try {
            Context context = this.getApplicationContext();
            long lastSuccessfulAlarm = AniwaysServiceUtils.getLastSuccessfulUpdate(context);
            if (intent.getAction() != null && intent.getAction().equalsIgnoreCase("com.aniways.SYNC_WITH_SERVER")) {
                Log.i(TAG, "Received request to sync with server from the app (not from the scheduled alarms)");
            }
            Log.i(TAG, "Checking for updates from server. Last successful check was: " + lastSuccessfulAlarm + ". Current time is: " + System.currentTimeMillis());
            boolean result = false;
            try {
                result = this.checkForConfigFromServer(this.getApplicationContext());
                AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
                VersionComparisonResult configResult = null;
                String configVersionString = ConfigHelper.getInstance().getConfigVersion(this.getApplicationContext());
                try {
                    configResult = Utils.compareVersionStrings(config.version, configVersionString);
                }
                catch (IllegalArgumentException e) {
                    Log.e(true, TAG, "Error parsing config version: " + configVersionString, e);
                }
                if (configResult != null && configResult.result == -1) {
                    Log.i(TAG, "detected lower version of config in current config: " + config.version + ". Scheduling parsing the new file");
                    AniwaysBackendSyncChecker.parseConfingAndKeywordsIfNecessary(context, true, false);
                }
            }
            catch (Exception e) {
                Log.e(true, TAG, "Check for updates from server was not successful", e);
            }
            if (result) {
                Log.i(TAG, "Finished checking for config updates successfuly");
            } else {
                Log.w(false, TAG, "check for config updates from server was not successful");
            }
            result = this.checkForUpdates(this.getApplicationContext());
            if (result) {
                long finishTime = System.currentTimeMillis();
                Log.i(TAG, "Finished checking for updates successfuly. Putting finish time in shared preferences: " + finishTime);
                AniwaysServiceUtils.setLastSuccessfulUpdate(context, finishTime);
            } else {
                Log.w(false, TAG, "check for updates from server was not successful");
            }
        }
        catch (Exception e) {
            Log.e(true, TAG, "Check for updates from server was not successful", e);
        }
    }

    private boolean updateKeywords(Context context, String oldKeywordsVersion, String keywordsNewVersion, String newKeywordsEtag, AniwaysStorageManager storageManager) throws IOException {
        Log.i(TAG, "Update keywords. new keywords ver: " + keywordsNewVersion);
        boolean result = false;
        KeywordsHelper keywordsHelper = KeywordsHelper.getInstance();
        if (keywordsHelper.upadateKeywordsFile(context, storageManager)) {
            storageManager.recordLocationOfNewKeywords();
            keywordsHelper.setKeywordsVersion(context, keywordsNewVersion, newKeywordsEtag);
            AniwaysServiceUtils.setUpdateRequired(context, true);
            result = true;
            Log.i(TAG, "Finished updating keywords. New keywords version is: " + keywordsNewVersion);
            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Backend Service: Finished Processing of Keywords Version", keywordsNewVersion, 0L);
            AnalyticsReporter.reportFinishedProcessingKeywordsVersion(oldKeywordsVersion, keywordsNewVersion);
        } else {
            Log.w(false, TAG, "Update of keywords file failed");
        }
        return result;
    }

    private boolean checkForUpdates(Context context) throws InterruptedException, ExecutionException, IOException {
        boolean result = true;
        Log.v(TAG, "Starting Check for updates..");
        AniwaysStorageManager storageManager = AniwaysStorageManager.getInstance(context);
        String oldKeywordsVersion = KeywordsHelper.getInstance().getKeywordsVersion(context);
        String oldKeywordsEtag = KeywordsHelper.getInstance().getKeywordsEtag(context);
        DownloadJSONFileTask downloadKeywordsFile = new DownloadJSONFileTask(context, AniwaysServiceUtils.getKeywordsUrl(), storageManager.getKeywordsCacheDir().getAbsolutePath(), "keywords", oldKeywordsVersion, oldKeywordsEtag);
        Log.i(TAG, "Scheduling download of Keywords file");
        Map downloadKeywordsFileResult = (Map)downloadKeywordsFile.execute(new Void[0]).get();
        Log.i(TAG, "Finished download of keywords file - result is " + (Boolean)downloadKeywordsFileResult.get("status") + ". is update required: " + (Boolean)downloadKeywordsFileResult.get("need_to_upadte"));
        if (((Boolean)downloadKeywordsFileResult.get("status")).booleanValue()) {
            if (((Boolean)downloadKeywordsFileResult.get("need_to_upadte")).booleanValue()) {
                String keywordsNewVersion = (String)downloadKeywordsFileResult.get("version");
                String newKeywordsEtag = (String)downloadKeywordsFileResult.get("etag");
                result &= this.updateKeywords(context, oldKeywordsVersion, keywordsNewVersion, newKeywordsEtag, storageManager);
            } else {
                Log.i(TAG, "No need to update keywords file");
            }
        } else {
            Log.e(false, TAG, "download keywords file error");
            result = false;
        }
        return result;
    }

    private boolean checkForConfigFromServer(Context context) throws InterruptedException, ExecutionException, IOException {
        boolean result = true;
        Log.v(TAG, "Starting Check for config..");
        String oldConfigVersion = ConfigHelper.getInstance().getConfigVersion(context);
        String oldConfigEtag = ConfigHelper.getInstance().getConfigEtag(context);
        DownloadJSONFileTask downloadConfigFile = new DownloadJSONFileTask(context, AniwaysServiceUtils.getConfigUrl(), AniwaysStorageManager.getConfigCacheDirPath(context), AniwaysStorageManager.getConfigFileName(), oldConfigVersion, oldConfigEtag);
        Log.i(TAG, "Scheduling download of config file");
        Map downloadConfigFileResult = (Map)downloadConfigFile.execute(new Void[0]).get();
        Log.i(TAG, "Finished download of config file - result is " + (Boolean)downloadConfigFileResult.get("status") + ". is update required: " + (Boolean)downloadConfigFileResult.get("need_to_upadte"));
        if (((Boolean)downloadConfigFileResult.get("status")).booleanValue()) {
            if (((Boolean)downloadConfigFileResult.get("need_to_upadte")).booleanValue()) {
                AniwaysStorageManager storageManager;
                ConfigHelper helper = ConfigHelper.getInstance();
                if (helper.upadateConfigFile(context, storageManager = AniwaysStorageManager.getInstance(context))) {
                    String configNewVersion = (String)downloadConfigFileResult.get("version");
                    String configNewEtag = (String)downloadConfigFileResult.get("etag");
                    helper.setConfigVersion(context, configNewVersion, configNewEtag);
                    AniwaysServiceUtils.setUpdateRequired(context, true);
                    result = true;
                    Log.i(TAG, "Finished updating config. New version is: " + configNewVersion);
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Backend Service: Finished Processing of config Version", configNewVersion, 0L);
                    AnalyticsReporter.reportFinishedProcessingConfigVersion(oldConfigVersion, configNewVersion);
                } else {
                    Log.w(false, TAG, "Update of config file failed");
                }
            } else {
                Log.i(TAG, "No need to update config file");
            }
        } else {
            Log.e(false, TAG, "download config file error");
            result = false;
        }
        return result;
    }
}

